(*
% File     : MGT054+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Hazard of mortality increases in a drifting environment
% Version  : [Han98] axioms.
% English  : An unendowed organization's hazard of mortality increases with 
%            age in a drifting environment.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 5 [Han98]
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.33 v2.5.0, 0.17 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   14 (   0 unit)
%            Number of atoms       :   50 (   6 equality)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :   45 (   9 ~  ;   4  |;  18  &)
%                                         (   6 <=>;   8 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   10 (   0 propositional; 1-3 arity)
%            Number of functors    :    5 (   2 constant; 0-2 arity)
%            Number of variables   :   36 (   0 singleton;  36 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable has_endowment_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable dissimilar_ : Universe -> Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable sigma_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable capability_ : Universe -> Universe -> Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_1_7 : (forall X T : Universe, ((organization_ X /\ ~(has_endowment_ X)) -> ~(has_immunity_ X T))).
Variable assumption_3_8 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ ~(has_immunity_ X T))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).
Variable definition_2_9 : (forall X T0 T : Universe, (dissimilar_ X T0 T <-> (organization_ X /\ ~((is_aligned_ X T0 <-> is_aligned_ X T))))).
Variable assumption_13_10 : (forall X T : Universe, ((organization_ X /\ (age_ X T) = zero_) -> is_aligned_ X T)).
Variable assumption_14_11 : (forall X T0 T : Universe, ((organization_ X /\ (is_aligned_ X T0 /\ ~(is_aligned_ X T))) -> greater_ (capability_ X T0) (capability_ X T))).
Variable assumption_15_12 : (forall X T0 T : Universe, ((organization_ X /\ (age_ X T0) = zero_) -> (greater_ (age_ X T) sigma_ <-> dissimilar_ X T0 T))).
Variable assumption_16_13 : (forall X T0 T : Universe, ((organization_ X /\ (~(has_immunity_ X T0) /\ (~(has_immunity_ X T) /\ greater_ (capability_ X T) (capability_ X T0)))) -> greater_ (hazard_of_mortality_ X T0) (hazard_of_mortality_ X T))).

Theorem theorem_5_14 : (forall X T0 T1 T2 : Universe, ((organization_ X /\ (~(has_endowment_ X) /\ ((age_ X T0) = zero_ /\ (smaller_or_equal_ (age_ X T1) sigma_ /\ (greater_ (age_ X T2) sigma_ /\ greater_ sigma_ zero_))))) -> greater_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1))).
Proof.
  time hprover.
Qed.

End FOFProblem.
