(*
% File     : MGT051+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Conditions for constant then increasing hazard of mortality
% Version  : [Han98] axioms.
% English  : An endowed organization's hazard of mortality remains constant 
%            during the period of immunity and increases monotonically with 
%            age once immunity ends.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 4 [Han98]
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.56 v2.7.0, 0.67 v2.6.0, 0.50 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   16 (   0 unit)
%            Number of atoms       :   73 (  15 equality)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :   62 (   5 ~  ;   4  |;  29  &)
%                                         (   4 <=>;  20 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    8 (   1 constant; 0-2 arity)
%            Number of variables   :   44 (   0 singleton;  44 !;   0 ?)
%            Maximal term depth    :    2 (   2 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable has_endowment_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.

Variable stock_of_knowledge_ : Universe -> Universe -> Universe.
Variable position_ : Universe -> Universe -> Universe.
Variable internal_friction_ : Universe -> Universe -> Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable external_ties_ : Universe -> Universe -> Universe.
Variable eta_ : Universe.
Variable capability_ : Universe -> Universe -> Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_1_7 : (forall X : Universe, (has_endowment_ X <-> (forall T : Universe, (organization_ X /\ ((smaller_or_equal_ (age_ X T) eta_ -> has_immunity_ X T) /\ (greater_ (age_ X T) eta_ -> ~(has_immunity_ X T))))))).
Variable assumption_2_8 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ has_immunity_ X T)) -> (hazard_of_mortality_ X T0) = (hazard_of_mortality_ X T))).
Variable assumption_3_9 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ ~(has_immunity_ X T))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).
Variable assumption_4_10 : (forall X T0 T : Universe, ((organization_ X /\ (~(has_immunity_ X T0) /\ ~(has_immunity_ X T))) -> (((greater_ (capability_ X T) (capability_ X T0) /\ greater_or_equal_ (position_ X T) (position_ X T0)) -> smaller_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0)) /\ (((greater_or_equal_ (capability_ X T) (capability_ X T0) /\ greater_ (position_ X T) (position_ X T0)) -> smaller_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0)) /\ (((capability_ X T) = (capability_ X T0) /\ (position_ X T) = (position_ X T0)) -> (hazard_of_mortality_ X T) = (hazard_of_mortality_ X T0)))))).
Variable assumption_5_11 : (forall X T0 T : Universe, (organization_ X -> (((greater_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ smaller_or_equal_ (internal_friction_ X T) (internal_friction_ X T0)) -> greater_ (capability_ X T) (capability_ X T0)) /\ (((smaller_or_equal_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ greater_ (internal_friction_ X T) (internal_friction_ X T0)) -> smaller_ (capability_ X T) (capability_ X T0)) /\ (((stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0) /\ (internal_friction_ X T) = (internal_friction_ X T0)) -> (capability_ X T) = (capability_ X T0)))))).
Variable assumption_6_12 : (forall X T0 T : Universe, (organization_ X -> ((greater_ (external_ties_ X T) (external_ties_ X T0) -> greater_ (position_ X T) (position_ X T0)) /\ ((external_ties_ X T) = (external_ties_ X T0) -> (position_ X T) = (position_ X T0))))).
Variable assumption_10_13 : (forall X T0 T : Universe, (organization_ X -> (stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0))).
Variable assumption_11_14 : (forall X T0 T : Universe, (organization_ X -> (external_ties_ X T) = (external_ties_ X T0))).
Variable assumption_12_15 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> greater_ (internal_friction_ X T) (internal_friction_ X T0))).

Theorem theorem_4_16 : (forall X T0 T1 T2 T3 : Universe, ((organization_ X /\ (has_endowment_ X /\ (smaller_or_equal_ (age_ X T0) (age_ X T1) /\ (smaller_or_equal_ (age_ X T1) eta_ /\ (greater_ (age_ X T2) eta_ /\ greater_ (age_ X T3) (age_ X T2)))))) -> (greater_ (hazard_of_mortality_ X T3) (hazard_of_mortality_ X T2) /\ (greater_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
