(*
% File     : MGT050+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Unendowed organization's hazard of mortality increases with age
% Version  : [Han98] axioms.
% English  : An unendowed organization's hazard of mortality increases with 
%            its age.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 3 [Han98]
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.33 v2.5.0, 0.17 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   14 (   0 unit)
%            Number of atoms       :   57 (  13 equality)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   49 (   6 ~  ;   4  |;  19  &)
%                                         (   3 <=>;  17 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    7 (   0 constant; 2-2 arity)
%            Number of variables   :   36 (   0 singleton;  36 !;   0 ?)
%            Maximal term depth    :    2 (   2 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable has_endowment_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.

Variable stock_of_knowledge_ : Universe -> Universe -> Universe.
Variable position_ : Universe -> Universe -> Universe.
Variable internal_friction_ : Universe -> Universe -> Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable external_ties_ : Universe -> Universe -> Universe.
Variable capability_ : Universe -> Universe -> Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_1_7 : (forall X T : Universe, ((organization_ X /\ ~(has_endowment_ X)) -> ~(has_immunity_ X T))).
Variable assumption_4_8 : (forall X T0 T : Universe, ((organization_ X /\ (~(has_immunity_ X T0) /\ ~(has_immunity_ X T))) -> (((greater_ (capability_ X T) (capability_ X T0) /\ greater_or_equal_ (position_ X T) (position_ X T0)) -> smaller_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0)) /\ (((greater_or_equal_ (capability_ X T) (capability_ X T0) /\ greater_ (position_ X T) (position_ X T0)) -> smaller_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0)) /\ (((capability_ X T) = (capability_ X T0) /\ (position_ X T) = (position_ X T0)) -> (hazard_of_mortality_ X T) = (hazard_of_mortality_ X T0)))))).
Variable assumption_5_9 : (forall X T0 T : Universe, (organization_ X -> (((greater_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ smaller_or_equal_ (internal_friction_ X T) (internal_friction_ X T0)) -> greater_ (capability_ X T) (capability_ X T0)) /\ (((smaller_or_equal_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ greater_ (internal_friction_ X T) (internal_friction_ X T0)) -> smaller_ (capability_ X T) (capability_ X T0)) /\ (((stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0) /\ (internal_friction_ X T) = (internal_friction_ X T0)) -> (capability_ X T) = (capability_ X T0)))))).
Variable assumption_6_10 : (forall X T0 T : Universe, (organization_ X -> ((greater_ (external_ties_ X T) (external_ties_ X T0) -> greater_ (position_ X T) (position_ X T0)) /\ ((external_ties_ X T) = (external_ties_ X T0) -> (position_ X T) = (position_ X T0))))).
Variable assumption_10_11 : (forall X T0 T : Universe, (organization_ X -> (stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0))).
Variable assumption_11_12 : (forall X T0 T : Universe, (organization_ X -> (external_ties_ X T) = (external_ties_ X T0))).
Variable assumption_12_13 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> greater_ (internal_friction_ X T) (internal_friction_ X T0))).

Theorem theorem_3_14 : (forall X T0 T : Universe, ((organization_ X /\ (~(has_endowment_ X) /\ greater_ (age_ X T) (age_ X T0))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).
Proof.
  time hprover.
Qed.

End FOFProblem.
