(*
% File     : MGT049+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Structural position does not vary with its age
% Version  : [Han98] axioms.
% English  : An organization's structural position does not vary with its age.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 6 [Han98]
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    9 (   0 unit)
%            Number of atoms       :   26 (   7 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   18 (   1 ~  ;   4  |;   4  &)
%                                         (   3 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   0 constant; 2-2 arity)
%            Number of variables   :   22 (   0 singleton;  22 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.

Variable position_ : Universe -> Universe -> Universe.
Variable external_ties_ : Universe -> Universe -> Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_6_7 : (forall X T0 T : Universe, (organization_ X -> ((greater_ (external_ties_ X T) (external_ties_ X T0) -> greater_ (position_ X T) (position_ X T0)) /\ ((external_ties_ X T) = (external_ties_ X T0) -> (position_ X T) = (position_ X T0))))).
Variable assumption_11_8 : (forall X T0 T : Universe, (organization_ X -> (external_ties_ X T) = (external_ties_ X T0))).

Theorem lemma_6_9 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> (position_ X T) = (position_ X T0))).
Proof.
  time hprover.
Qed.

End FOFProblem.
