(*
% File     : MGT048+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Capability decreases monotonically with its age
% Version  : [Han98] axioms.
% English  : An organization's capability decreases monotonically with its age.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 5 [Han98]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.17 v2.5.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :   10 (   0 unit)
%            Number of atoms       :   34 (   7 equality)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   25 (   1 ~  ;   4  |;   9  &)
%                                         (   3 <=>;   8 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    4 (   0 constant; 2-2 arity)
%            Number of variables   :   25 (   0 singleton;  25 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.

Variable stock_of_knowledge_ : Universe -> Universe -> Universe.
Variable internal_friction_ : Universe -> Universe -> Universe.
Variable capability_ : Universe -> Universe -> Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_5_7 : (forall X T0 T : Universe, (organization_ X -> (((greater_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ smaller_or_equal_ (internal_friction_ X T) (internal_friction_ X T0)) -> greater_ (capability_ X T) (capability_ X T0)) /\ (((smaller_or_equal_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ greater_ (internal_friction_ X T) (internal_friction_ X T0)) -> smaller_ (capability_ X T) (capability_ X T0)) /\ (((stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0) /\ (internal_friction_ X T) = (internal_friction_ X T0)) -> (capability_ X T) = (capability_ X T0)))))).
Variable assumption_10_8 : (forall X T0 T : Universe, (organization_ X -> (stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0))).
Variable assumption_12_9 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> greater_ (internal_friction_ X T) (internal_friction_ X T0))).

Theorem lemma_5_10 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> smaller_ (capability_ X T) (capability_ X T0))).
Proof.
  time hprover.
Qed.

End FOFProblem.
