(*
% File     : MGT043+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Conditions for a higher hazard of mortality
% Version  : [Han98] axioms.
% English  : When an organization lacks immunity, the growth of internal
%            friction elevates its hazard of mortality when its knowledge and
%            the quality of its ties are constant.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 2 [Han98]
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.44 v2.7.0, 0.50 v2.6.0, 0.33 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   10 (   0 unit)
%            Number of atoms       :   50 (  13 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   45 (   5 ~  ;   4  |;  20  &)
%                                         (   3 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    6 (   0 constant; 2-2 arity)
%            Number of variables   :   25 (   0 singleton;  25 !;   0 ?)
%            Maximal term depth    :    2 (   2 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.

Variable stock_of_knowledge_ : Universe -> Universe -> Universe.
Variable position_ : Universe -> Universe -> Universe.
Variable internal_friction_ : Universe -> Universe -> Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable external_ties_ : Universe -> Universe -> Universe.
Variable capability_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_4_7 : (forall X T0 T : Universe, ((organization_ X /\ (~(has_immunity_ X T0) /\ ~(has_immunity_ X T))) -> (((greater_ (capability_ X T) (capability_ X T0) /\ greater_or_equal_ (position_ X T) (position_ X T0)) -> smaller_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0)) /\ (((greater_or_equal_ (capability_ X T) (capability_ X T0) /\ greater_ (position_ X T) (position_ X T0)) -> smaller_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0)) /\ (((capability_ X T) = (capability_ X T0) /\ (position_ X T) = (position_ X T0)) -> (hazard_of_mortality_ X T) = (hazard_of_mortality_ X T0)))))).
Variable assumption_5_8 : (forall X T0 T : Universe, (organization_ X -> (((greater_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ smaller_or_equal_ (internal_friction_ X T) (internal_friction_ X T0)) -> greater_ (capability_ X T) (capability_ X T0)) /\ (((smaller_or_equal_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ greater_ (internal_friction_ X T) (internal_friction_ X T0)) -> smaller_ (capability_ X T) (capability_ X T0)) /\ (((stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0) /\ (internal_friction_ X T) = (internal_friction_ X T0)) -> (capability_ X T) = (capability_ X T0)))))).
Variable assumption_6_9 : (forall X T0 T : Universe, (organization_ X -> ((greater_ (external_ties_ X T) (external_ties_ X T0) -> greater_ (position_ X T) (position_ X T0)) /\ ((external_ties_ X T) = (external_ties_ X T0) -> (position_ X T) = (position_ X T0))))).

Theorem lemma_2_10 : (forall X T0 T : Universe, ((organization_ X /\ (~(has_immunity_ X T0) /\ (~(has_immunity_ X T) /\ ((stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0) /\ (greater_ (internal_friction_ X T) (internal_friction_ X T0) /\ (external_ties_ X T0) = (external_ties_ X T)))))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).
Proof.
  time hprover.
Qed.

End FOFProblem.
