(*
% File     : MGT040+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favours FMs above EPs if change is not extreme
% Version  : [PM93] axioms.
% English  : Selection favors first movers above efficient producers if
%            environmental change is rapid but not extreme during the 
%            observational period. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [PM93]
% Names    : Theorem 9* [PM93]
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.7.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.00 v2.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   14 (   2 unit)
%            Number of atoms       :   54 (   1 equality)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   48 (   8 ~  ;   1  |;  22  &)
%                                         (   0 <=>;  17 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-3 arity)
%            Number of functors    :    6 (   3 constant; 0-2 arity)
%            Number of variables   :   20 (   0 singleton;  20 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable rapid_change_ : Universe -> Prop.
Variable propagation_strategy_ : Universe -> Prop.
Variable observational_period_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable extreme_ : Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable first_movers_ : Universe.
Variable end_time_ : Universe -> Universe.
Variable efficient_producers_ : Universe.
Variable critical_point_ : Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.
Variable an_organisation_ : Universe.

Variable mp3_favoured_trategy_1 : (forall P : Universe, ((observational_period_ P /\ (propagation_strategy_ first_movers_ /\ (propagation_strategy_ efficient_producers_ /\ (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> selection_favors_ efficient_producers_ first_movers_ (end_time_ E)))))) -> selection_favors_ efficient_producers_ first_movers_ P)).
Variable mp5_rapid_change_is_non_critical_2 : (forall P : Universe, ((observational_period_ P /\ rapid_change_ P) -> (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> ~(in_environment_ E (critical_point_ E)))))).
Variable mp6_not_extreme_change_means_not_empty_3 : (forall P : Universe, ((observational_period_ P /\ ~(extreme_ P)) -> (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> ~(empty_ E))))).
Variable mp_organizational_sets1_4 : propagation_strategy_ first_movers_.
Variable mp_organizational_sets2_5 : propagation_strategy_ efficient_producers_.
Variable mp_endpoint_in_environment_6 : (forall E : Universe, (environment_ E -> in_environment_ E (end_time_ E))).
Variable mp_critical_point_not_before_opening_7 : (forall E : Universe, ((environment_ E /\ ~(in_environment_ E (critical_point_ E))) -> greater_ (critical_point_ E) (end_time_ E))).
Variable mp_non_empty_means_organisations_8 : (forall E : Universe, ((environment_ E /\ ~(empty_ E)) -> greater_or_equal_ (end_time_ E) (appear_ an_organisation_ E))).
Variable mp_selection_favours_in_time_9 : (forall E T : Universe, ((environment_ E /\ (greater_or_equal_ T (appear_ efficient_producers_ E) /\ (greater_ (critical_point_ E) T /\ (in_environment_ E (critical_point_ E) -> selection_favors_ first_movers_ efficient_producers_ T)))) -> (~(in_environment_ E (critical_point_ E)) -> selection_favors_ first_movers_ efficient_producers_ (end_time_ E)))).
Variable mp_greater_or_equal_10 : (forall X Y : Universe, (greater_or_equal_ X Y -> (greater_ X Y \/ X = Y))).
Variable mp_appearance_of_EP_11 : (forall E T : Universe, ((in_environment_ E T /\ ~(greater_ (appear_ efficient_producers_ E) T)) -> greater_or_equal_ T (appear_ efficient_producers_ E))).
Variable t2_12 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_or_equal_ T (appear_ first_movers_ E) /\ greater_ (appear_ efficient_producers_ E) T))) -> selection_favors_ first_movers_ efficient_producers_ T)).
Variable t3_13 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E (critical_point_ E) /\ (greater_or_equal_ T (appear_ efficient_producers_ E) /\ greater_ (critical_point_ E) T))) -> selection_favors_ first_movers_ efficient_producers_ T)).

Theorem prove_t9_14 : (forall P : Universe, ((observational_period_ P /\ (rapid_change_ P /\ ~(extreme_ P))) -> selection_favors_ first_movers_ efficient_producers_ P)).
Proof.
  time hprover.
Qed.

End FOFProblem.
