(*
% File     : MGT040+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favours FMs above EPs if change is not extreme
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : Selection favors first movers above efficient producers if
%            environmental change is rapid but not extreme during the 
%            observational period. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.7.0, 0.00 v2.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   16 (   2 unit)
%            Number of atoms       :   60 (   2 equality)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   52 (   8 ~  ;   1  |;  24  &)
%                                         (   0 <=>;  19 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-3 arity)
%            Number of functors    :    6 (   3 constant; 0-2 arity)
%            Number of variables   :   22 (   0 singleton;  22 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable rapid_change_ : Universe -> Prop.
Variable propagation_strategy_ : Universe -> Prop.
Variable observational_period_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable extreme_ : Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable first_movers_ : Universe.
Variable end_time_ : Universe -> Universe.
Variable efficient_producers_ : Universe.
Variable critical_point_ : Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.
Variable an_organisation_ : Universe.

Variable mp3_favoured_trategy_1 : (forall P : Universe, ((observational_period_ P /\ (propagation_strategy_ first_movers_ /\ (propagation_strategy_ efficient_producers_ /\ (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> selection_favors_ efficient_producers_ first_movers_ (end_time_ E)))))) -> selection_favors_ efficient_producers_ first_movers_ P)).
Variable mp5_rapid_change_is_non_critical_2 : (forall P : Universe, ((observational_period_ P /\ rapid_change_ P) -> (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> ~(in_environment_ E (critical_point_ E)))))).
Variable mp6_not_extreme_change_means_not_empty_3 : (forall P : Universe, ((observational_period_ P /\ ~(extreme_ P)) -> (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> ~(empty_ E))))).
Variable mp_organizational_sets1_4 : propagation_strategy_ first_movers_.
Variable mp_organizational_sets2_5 : propagation_strategy_ efficient_producers_.
Variable mp_endpoint_in_environment_6 : (forall E : Universe, (environment_ E -> in_environment_ E (end_time_ E))).
Variable mp_critical_point_not_before_opening_7 : (forall E : Universe, ((environment_ E /\ ~(in_environment_ E (critical_point_ E))) -> greater_ (critical_point_ E) (end_time_ E))).
Variable mp_non_empty_means_organisations_8 : (forall E : Universe, ((environment_ E /\ ~(empty_ E)) -> greater_or_equal_ (end_time_ E) (appear_ an_organisation_ E))).
Variable mp_appearance_before_end_holds_9 : (forall E : Universe, ((environment_ E /\ greater_or_equal_ (end_time_ E) (appear_ an_organisation_ E)) -> in_environment_ E (appear_ an_organisation_ E))).
Variable mp_selection_favours_in_time_10 : (forall E T : Universe, ((environment_ E /\ (greater_or_equal_ T (appear_ efficient_producers_ E) /\ (greater_ (critical_point_ E) T /\ (in_environment_ E (critical_point_ E) -> selection_favors_ first_movers_ efficient_producers_ T)))) -> (~(in_environment_ E (critical_point_ E)) -> selection_favors_ first_movers_ efficient_producers_ (end_time_ E)))).
Variable mp_greater_or_equal_11 : (forall X Y : Universe, (greater_or_equal_ X Y -> (greater_ X Y \/ X = Y))).
Variable mp_appearance_of_EP_12 : (forall E T : Universe, ((in_environment_ E T /\ ~(greater_ (appear_ efficient_producers_ E) T)) -> greater_or_equal_ T (appear_ efficient_producers_ E))).
Variable t2_13 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_or_equal_ T (appear_ first_movers_ E) /\ greater_ (appear_ efficient_producers_ E) T))) -> selection_favors_ first_movers_ efficient_producers_ T)).
Variable t3_14 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E (critical_point_ E) /\ (greater_or_equal_ T (appear_ efficient_producers_ E) /\ greater_ (critical_point_ E) T))) -> selection_favors_ first_movers_ efficient_producers_ T)).
Variable l13_15 : (forall E : Universe, ((environment_ E /\ in_environment_ E (appear_ an_organisation_ E)) -> (appear_ an_organisation_ E) = (appear_ first_movers_ E))).

Theorem prove_t9_16 : (forall P : Universe, ((observational_period_ P /\ (rapid_change_ P /\ ~(extreme_ P))) -> selection_favors_ first_movers_ efficient_producers_ P)).
Proof.
  time hprover.
Qed.

End FOFProblem.
