(*
% File     : MGT039+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favours EPs above Fms if change is slow
% Version  : [PM93] axioms.
% English  : Selection favors efficient producers above first movers if
%            environmental change is slow. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [PM93]
% Names    : Theorem 8 [PM93]
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.56 v2.7.0, 0.50 v2.6.0, 0.57 v2.5.0, 0.62 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   19 (   2 unit)
%            Number of atoms       :   71 (   3 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   54 (   2 ~  ;   1  |;  31  &)
%                                         (   1 <=>;  19 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-4 arity)
%            Number of functors    :    9 (   3 constant; 0-2 arity)
%            Number of variables   :   38 (   0 singleton;  37 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable slow_change_ : Universe -> Prop.
Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable propagation_strategy_ : Universe -> Prop.
Variable observational_period_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable zero_ : Universe.
Variable start_time_ : Universe -> Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable end_time_ : Universe -> Universe.
Variable efficient_producers_ : Universe.
Variable critical_point_ : Universe -> Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.

Variable mp1_high_growth_rates_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulations_ S1 S2 E T /\ greater_ (growth_rate_ S2 T) (growth_rate_ S1 T))) -> selection_favors_ S2 S1 T)).
Variable mp2_favour_members_2 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulation_ S1 E T /\ (subpopulation_ S2 E T /\ (greater_ (cardinality_at_time_ S1 T) zero_ /\ (cardinality_at_time_ S2 T) = zero_)))) -> selection_favors_ S1 S2 T)).
Variable mp3_favoured_trategy_3 : (forall P : Universe, ((observational_period_ P /\ (propagation_strategy_ first_movers_ /\ (propagation_strategy_ efficient_producers_ /\ (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> selection_favors_ efficient_producers_ first_movers_ (end_time_ E)))))) -> selection_favors_ efficient_producers_ first_movers_ P)).
Variable mp4_critical_point_4 : (forall P : Universe, ((observational_period_ P /\ slow_change_ P) -> (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> (exists T : Universe, (in_environment_ E T /\ greater_ T (critical_point_ E))))))).
Variable mp_organizational_sets1_5 : propagation_strategy_ first_movers_.
Variable mp_organizational_sets2_6 : propagation_strategy_ efficient_producers_.
Variable mp_time_in_environment_7 : (forall E T : Universe, ((environment_ E /\ (greater_or_equal_ T (start_time_ E) /\ greater_or_equal_ (end_time_ E) T)) -> in_environment_ E T)).
Variable mp_environment_end_point_8 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> greater_or_equal_ (end_time_ E) T)).
Variable mp_contains_FM_and_EP_9 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))) -> subpopulations_ first_movers_ efficient_producers_ E T)).
Variable mp_first_movers_exist_10 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> greater_or_equal_ (cardinality_at_time_ first_movers_ T) zero_)).
Variable mp_subpopulations_11 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_critical_point_after_EP_12 : (forall E : Universe, (environment_ E -> greater_or_equal_ (critical_point_ E) (appear_ efficient_producers_ E))).
Variable mp_time_of_critical_point_13 : (forall E : Universe, (environment_ E -> greater_or_equal_ (critical_point_ E) (start_time_ E))).
Variable mp_greater_transitivity_14 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_beginning_and_ending_15 : (forall E T : Universe, ((environment_ E /\ (greater_ T (start_time_ E) /\ ~(greater_ T (end_time_ E)))) -> greater_or_equal_ (end_time_ E) T)).
Variable mp_greater_or_equal_16 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable d1_17 : (forall E Tc : Universe, ((environment_ E /\ Tc = (critical_point_ E)) -> (~(greater_ (growth_rate_ efficient_producers_ Tc) (growth_rate_ first_movers_ Tc)) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T Tc) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))).
Variable t6_18 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ efficient_producers_ E))) -> greater_ (cardinality_at_time_ efficient_producers_ T) zero_)).

Theorem prove_t8_19 : (forall P : Universe, ((observational_period_ P /\ slow_change_ P) -> selection_favors_ efficient_producers_ first_movers_ P)).
Proof.
  time hprover.
Qed.

End FOFProblem.
