(*
% File     : MGT039+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favours EPs above Fms if change is slow
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : Selection favors efficient producers above first movers if
%            environmental change is slow. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.22 v2.7.0, 0.33 v2.6.0, 0.43 v2.5.0, 0.38 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   12 (   2 unit)
%            Number of atoms       :   41 (   1 equality)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   30 (   1 ~  ;   1  |;  16  &)
%                                         (   1 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-3 arity)
%            Number of functors    :    5 (   2 constant; 0-1 arity)
%            Number of variables   :   20 (   0 singleton;  19 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable slow_change_ : Universe -> Prop.
Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable propagation_strategy_ : Universe -> Prop.
Variable observational_period_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable start_time_ : Universe -> Universe.
Variable first_movers_ : Universe.
Variable end_time_ : Universe -> Universe.
Variable efficient_producers_ : Universe.
Variable critical_point_ : Universe -> Universe.

Variable mp3_favoured_trategy_1 : (forall P : Universe, ((observational_period_ P /\ (propagation_strategy_ first_movers_ /\ (propagation_strategy_ efficient_producers_ /\ (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> selection_favors_ efficient_producers_ first_movers_ (end_time_ E)))))) -> selection_favors_ efficient_producers_ first_movers_ P)).
Variable mp4_critical_point_2 : (forall P : Universe, ((observational_period_ P /\ slow_change_ P) -> (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> (exists T : Universe, (in_environment_ E T /\ greater_ T (critical_point_ E))))))).
Variable mp_organizational_sets1_3 : propagation_strategy_ first_movers_.
Variable mp_organizational_sets2_4 : propagation_strategy_ efficient_producers_.
Variable mp_time_in_environment_5 : (forall E T : Universe, ((environment_ E /\ (greater_or_equal_ T (start_time_ E) /\ greater_or_equal_ (end_time_ E) T)) -> in_environment_ E T)).
Variable mp_environment_end_point_6 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> greater_or_equal_ (end_time_ E) T)).
Variable mp_time_of_critical_point_7 : (forall E : Universe, (environment_ E -> greater_or_equal_ (critical_point_ E) (start_time_ E))).
Variable mp_greater_transitivity_8 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_greater_or_equal_9 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable mp_beginning_and_ending_10 : (forall E T : Universe, ((environment_ E /\ (greater_ T (start_time_ E) /\ ~(greater_ T (end_time_ E)))) -> greater_or_equal_ (end_time_ E) T)).
Variable l8_11 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ T (critical_point_ E))) -> selection_favors_ efficient_producers_ first_movers_ T)).

Theorem prove_t8_12 : (forall P : Universe, ((observational_period_ P /\ slow_change_ P) -> selection_favors_ efficient_producers_ first_movers_ P)).
Proof.
  time hprover.
Qed.

End FOFProblem.
