(*
% File     : MGT038+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : FMs become extinct in stable environments
% Version  : [PM93] axioms.
% English  : First movers become extinct past a certain point in time 
%            in stable environments. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
% Source   : [PM93]
% Names    : THEOREM 7 [PM93]
%          : T7 [PB+94]
% Status   : CounterSatisfiable
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :   16 (   1 unit)
%            Number of atoms       :   70 (   4 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   54 (   0 ~  ;   3  |;  32  &)
%                                         (   1 <=>;  18 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-4 arity)
%            Number of functors    :   11 (   7 constant; 0-2 arity)
%            Number of variables   :   36 (   0 singleton;  30 !;   6 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable stable_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable finite_set_ : Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable contracts_from_ : Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable to_ : Universe.
Variable t2_ : Universe.
Variable s_ : Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable equilibrium_ : Universe -> Universe.
Variable efficient_producers_ : Universe.
Variable e_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.

Variable mp7_first_movers_exist_1 : finite_set_ first_movers_.
Variable mp_contracting_time_2 : (forall S To : Universe, ((finite_set_ S /\ contracts_from_ To S) -> (exists T2 : Universe, (greater_ T2 To /\ (cardinality_at_time_ s_ t2_) = zero_)))).
Variable mp_contracts_from_3 : (forall E To : Universe, ((environment_ E /\ (stable_ E /\ (in_environment_ E To /\ (forall T : Universe, ((greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_or_equal_ T To) -> greater_ zero_ (growth_rate_ first_movers_ T)))))) -> contracts_from_ To first_movers_)).
Variable mp_contains_FM_and_EP_4 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))) -> subpopulations_ first_movers_ efficient_producers_ E T)).
Variable mp_long_stable_environments_5 : (forall E T1 T2 : Universe, ((environment_ E /\ (stable_ E /\ (in_environment_ E T1 /\ greater_ T2 T1))) -> in_environment_ E T2)).
Variable mp_stable_first_movers_6 : (forall E : Universe, ((environment_ E /\ stable_ E) -> in_environment_ E (appear_ first_movers_ E))).
Variable mp_stable_efficient_producers_7 : (forall E : Universe, ((environment_ E /\ stable_ E) -> in_environment_ E (appear_ efficient_producers_ E))).
Variable mp_first_movers_negative_growth_8 : (forall E : Universe, ((environment_ E /\ (stable_ E /\ (exists T1 : Universe, (in_environment_ E T1 /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T T1) -> greater_ zero_ (growth_rate_ first_movers_ T))))))) -> (exists T2 : Universe, (greater_ T2 (appear_ efficient_producers_ E) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T T2) -> greater_ zero_ (growth_rate_ first_movers_ T))))))).
Variable mp_greater_transitivity_9 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_times_in_environment_10 : (forall E T1 T2 : Universe, ((in_environment_ E T1 /\ in_environment_ E T2) -> (greater_ T2 T1 \/ (T2 = T1 \/ greater_ T1 T2)))).
Variable mp_greater_or_equal_11 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable a3_12 : (forall E : Universe, (environment_ E -> greater_ (appear_ efficient_producers_ e_) (appear_ first_movers_ E))).
Variable a5_13 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists T : Universe, (in_environment_ E T /\ greater_or_equal_ T (equilibrium_ E))))).
Variable t6_14 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ efficient_producers_ E))) -> greater_ (cardinality_at_time_ efficient_producers_ T) zero_)).
Variable l1_15 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))))))).

Theorem prove_t7_16 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (greater_ To (appear_ first_movers_ E) /\ (cardinality_at_time_ first_movers_ to_) = zero_))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
