(*
% File     : MGT038+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : FMs become extinct in stable environments
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : First movers become extinct past a certain point in time 
%            in stable environments. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.7.0, 0.00 v2.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    8 (   1 unit)
%            Number of atoms       :   27 (   2 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   19 (   0 ~  ;   0  |;  12  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    9 (   7 constant; 0-2 arity)
%            Number of variables   :   15 (   0 singleton;  12 !;   3 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable stable_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable finite_set_ : Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable contracts_from_ : Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable to_ : Universe.
Variable t2_ : Universe.
Variable s_ : Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable e_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.

Variable mp7_first_movers_exist_1 : finite_set_ first_movers_.
Variable mp_stable_first_movers_2 : (forall E : Universe, ((environment_ E /\ stable_ E) -> in_environment_ E (appear_ first_movers_ E))).
Variable mp_contracting_time_3 : (forall S To : Universe, ((finite_set_ S /\ contracts_from_ To S) -> (exists T2 : Universe, (greater_ T2 To /\ (cardinality_at_time_ s_ t2_) = zero_)))).
Variable mp_long_stable_environments_4 : (forall E T1 T2 : Universe, ((environment_ E /\ (stable_ E /\ (in_environment_ E T1 /\ greater_ T2 T1))) -> in_environment_ E T2)).
Variable mp_greater_transitivity_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable l9_6 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (greater_ To (appear_ efficient_producers_ E) /\ contracts_from_ To first_movers_)))).
Variable a13_7 : (forall E : Universe, (environment_ E -> greater_ (appear_ efficient_producers_ e_) (appear_ first_movers_ E))).

Theorem prove_t7_8 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (greater_ To (appear_ first_movers_ E) /\ (cardinality_at_time_ first_movers_ to_) = zero_))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
