(*
% File     : MGT037+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Once appeared, efficient producers do not disappear
% Version  : [PM93] axioms.
% English  : 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
% Source   : [PM93]
% Names    : THEOREM 6 [PM93]
%          : T6 [PB+94]
% Status   : CounterSatisfiable
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :   16 (   1 unit)
%            Number of atoms       :   70 (   8 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   63 (   9 ~  ;   3  |;  32  &)
%                                         (   0 <=>;  19 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-3 arity)
%            Number of functors    :   11 (   4 constant; 0-2 arity)
%            Number of variables   :   35 (   0 singleton;  33 !;   2 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable decreases_ : Universe -> Prop.
Variable constant_ : Universe -> Prop.

Variable zero_ : Universe.
Variable resources_ : Universe -> Universe -> Universe.
Variable resilience_ : Universe -> Universe.
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable equilibrium_ : Universe -> Universe.
Variable efficient_producers_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.
Variable an_organisation_ : Universe.

Variable mp_previous_negative_growth_1 : (forall E T : Universe, ((environment_ E /\ (greater_or_equal_ T (appear_ efficient_producers_ E) /\ (cardinality_at_time_ efficient_producers_ T) = zero_)) -> (exists To : Universe, (greater_ To (appear_ efficient_producers_ E) /\ (in_environment_ E To /\ (greater_ T To /\ greater_ zero_ (growth_rate_ efficient_producers_ To))))))).
Variable mp_start_of_organizations_2 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (appear_ an_organisation_ E) T)) -> (number_of_organizations_ E T) = zero_)).
Variable mp_non_decreasing_3 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ ~(decreases_ (number_of_organizations_ E T)))) -> (exists X : Universe, (subpopulation_ X E T /\ (greater_ (cardinality_at_time_ X T) zero_ /\ ~(greater_ zero_ (growth_rate_ X T))))))).
Variable mp_no_members_4 : (forall E T X : Universe, ((environment_ E /\ (in_environment_ E T /\ ((number_of_organizations_ E T) = zero_ /\ subpopulation_ X E T))) -> (cardinality_at_time_ X T) = zero_)).
Variable mp_subpopulations_5 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_empty_not_decreasing_6 : (forall S T : Universe, ((cardinality_at_time_ S T) = zero_ -> ~(greater_ zero_ (growth_rate_ S T)))).
Variable mp_efficient_producers_exist_7 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> ((cardinality_at_time_ efficient_producers_ T) = zero_ \/ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))).
Variable mp_constant_not_decrease_8 : (forall X : Universe, (constant_ X -> ~(decreases_ X))).
Variable mp_environment_inequality_9 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (~(greater_or_equal_ T (appear_ an_organisation_ E)) \/ greater_ (appear_ an_organisation_ E) T))).
Variable a1_10 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ an_organisation_ E))) -> greater_ (number_of_organizations_ E T) zero_)).
Variable a2_11 : greater_ (resilience_ efficient_producers_) (resilience_ first_movers_).
Variable a4_12 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (number_of_organizations_ E T) zero_)) -> ((greater_ (equilibrium_ E) T -> decreases_ (resources_ E T)) /\ (~(greater_ (equilibrium_ E) T) -> constant_ (resources_ E T))))).
Variable a7_13 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> ((decreases_ (resources_ E T) -> ~(decreases_ (number_of_organizations_ E T))) /\ (constant_ (resources_ E T) -> constant_ (number_of_organizations_ E T))))).
Variable a11_14 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)) -> (X = efficient_producers_ \/ X = first_movers_))).
Variable a13_15 : (forall E S1 S2 T : Universe, ((environment_ E /\ (in_environment_ E T /\ (~(greater_ zero_ (growth_rate_ S1 T)) /\ greater_ (resilience_ S2) (resilience_ S1)))) -> ~(greater_ zero_ (growth_rate_ S2 T)))).

Theorem prove_t6_16 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ efficient_producers_ E))) -> greater_ (cardinality_at_time_ efficient_producers_ T) zero_)).
Proof.
  time hprover.
Qed.

End FOFProblem.
