(*
% File     : MGT036+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : First movers never outcompete efficient producers. 
% Version  : [PM93] axioms.
% English  : 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
% Source   : [PM93]
% Names    : THEOREM 5 [PM93]
%          : T5 [PB+94]
% Status   : Theorem
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 0.50 v1.0.0
% Rating (intuit.) : 0.75 v1.1
% Syntax   : Number of formulae    :    7 (   1 unit)
%            Number of atoms       :   24 (   0 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   21 (   4 ~  ;   0  |;   9  &)
%                                         (   2 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-4 arity)
%            Number of functors    :    5 (   3 constant; 0-2 arity)
%            Number of variables   :   20 (   0 singleton;  20 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable outcompetes_ : Universe -> Universe -> Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable zero_ : Universe.
Variable resilience_ : Universe -> Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.

Variable mp_symmetry_of_subpopulations_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ subpopulations_ S1 S2 E T) -> subpopulations_ S2 S1 E T)).
Variable mp_time_point_occur_2 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable mp_growth_rate_relationships_3 : (forall E S1 S2 T : Universe, (((environment_ E /\ subpopulations_ S1 S2 E T) -> greater_or_equal_ (growth_rate_ S1 T) zero_) <-> ~(greater_ zero_ (growth_rate_ S1 T)))).
Variable d2_4 : (forall E S1 S2 T : Universe, ((environment_ E /\ subpopulations_ S1 S2 E T) -> ((greater_or_equal_ (growth_rate_ S2 T) zero_ /\ greater_ zero_ (growth_rate_ S1 T)) <-> outcompetes_ S2 S1 T))).
Variable a2_5 : greater_ (resilience_ efficient_producers_) (resilience_ first_movers_).
Variable a13_6 : (forall E S1 S2 T : Universe, ((environment_ E /\ (in_environment_ E T /\ (~(greater_ zero_ (growth_rate_ S1 T)) /\ greater_ (resilience_ S2) (resilience_ S1)))) -> ~(greater_ zero_ (growth_rate_ S2 T)))).

Theorem prove_t5_7 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> ~(outcompetes_ first_movers_ efficient_producers_ T))).
Proof.
  time hprover.
Qed.

End FOFProblem.
