(*
% File     : MGT035+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : EPs outcompete FMs in stable environments
% Version  : [PM93] axioms.
% English  : Efficient producers outcompete first movers past a certain
%            time in stable environments. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
% Source   : [PM93]
% Names    : THEOREM 4 [PM93]
%          : T4 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :   20 (   0 unit)
%            Number of atoms       :   95 (  10 equality)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   80 (   5 ~  ;   7  |;  39  &)
%                                         (   2 <=>;  27 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   0 propositional; 1-4 arity)
%            Number of functors    :    9 (   3 constant; 0-2 arity)
%            Number of variables   :   50 (   0 singleton;  47 !;   3 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable stable_ : Universe -> Prop.
Variable outcompetes_ : Universe -> Universe -> Universe -> Prop.
Variable increases_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable decreases_ : Universe -> Prop.
Variable constant_ : Universe -> Prop.

Variable zero_ : Universe.
Variable sum_ : Universe -> Universe -> Universe.
Variable resources_ : Universe -> Universe -> Universe.
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable equilibrium_ : Universe -> Universe.
Variable efficient_producers_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.

Variable mp_time_point_in_environment_1 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable mp_environment_not_empty_2 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_ (number_of_organizations_ E T) zero_)).
Variable mp_only_members_3 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ (greater_ (cardinality_at_time_ X T) zero_ -> (X = efficient_producers_ \/ X = first_movers_)))) -> (number_of_organizations_ E T) = (sum_ (cardinality_at_time_ first_movers_ T) (cardinality_at_time_ efficient_producers_ T)))).
Variable mp_FM_and_EP_organisational_4 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_abc_sum_increase_5 : (forall A B C : Universe, ((A = (sum_ B C) /\ constant_ A) -> ((constant_ B /\ constant_ C) \/ ((increases_ B /\ decreases_ C) \/ (decreases_ B /\ increases_ C))))).
Variable mp_growth_rate_6 : (forall X E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_))) -> ((constant_ (cardinality_at_time_ X T) -> (growth_rate_ X T) = zero_) /\ ((increases_ (cardinality_at_time_ X T) -> greater_ (growth_rate_ X T) zero_) /\ (decreases_ (cardinality_at_time_ X T) -> greater_ zero_ (growth_rate_ X T)))))).
Variable mp_positive_number_of_organizations_7 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))).
Variable mp6_1_8 : (forall X Y : Universe, ~((greater_ X Y /\ X = Y))).
Variable mp6_2_9 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable mp_greater_transitivity_10 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_times_in_environment_11 : (forall E T1 T2 : Universe, ((in_environment_ E T1 /\ in_environment_ E T2) -> (greater_ T2 T1 \/ (T2 = T1 \/ greater_ T1 T2)))).
Variable mp_greater_or_equal_12 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable mp_equilibrium_13 : (forall E T : Universe, ((environment_ E /\ greater_or_equal_ T (equilibrium_ E)) -> ~(greater_ (equilibrium_ E) T))).
Variable d2_14 : (forall E S1 S2 T : Universe, ((environment_ E /\ subpopulations_ S1 S2 E T) -> ((greater_or_equal_ (growth_rate_ S2 T) zero_ /\ greater_ zero_ (growth_rate_ S1 T)) <-> outcompetes_ S2 S1 T))).
Variable a4_15 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (number_of_organizations_ E T) zero_)) -> ((greater_ (equilibrium_ E) T -> decreases_ (resources_ E T)) /\ (~(greater_ (equilibrium_ E) T) -> constant_ (resources_ E T))))).
Variable a5_16 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists T : Universe, (in_environment_ E T /\ greater_or_equal_ T (equilibrium_ E))))).
Variable a7_17 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> ((decreases_ (resources_ E T) -> ~(decreases_ (number_of_organizations_ E T))) /\ (constant_ (resources_ E T) -> constant_ (number_of_organizations_ E T))))).
Variable a11_18 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)) -> (X = efficient_producers_ \/ X = first_movers_))).
Variable l1_19 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))))))).

Theorem prove_t4_20 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> outcompetes_ efficient_producers_ first_movers_ T)))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
