(*
% File     : MGT033+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favors FMs above EPs until EPs appear
% Version  : [PM93] axioms.
% English  : Selection favors first movers above efficient producers 
%            until the appearance of efficient producers. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
% Source   : [PM93]
% Names    : THEOREM 2 [PM93]
%          : T2 [PB+94]
% Status   : CounterSatisfiable
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :   18 (   0 unit)
%            Number of atoms       :   62 (   6 equality)
%            Maximal formula depth :   10 (   5 average)
%            Number of connectives :   45 (   1 ~  ;   2  |;  24  &)
%                                         (   1 <=>;  17 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-3 arity)
%            Number of functors    :   10 (   6 constant; 0-2 arity)
%            Number of variables   :   38 (   0 singleton;  37 !;   1 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable zero_ : Universe.
Variable t_ : Universe.
Variable start_time_ : Universe -> Universe.
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable e_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.
Variable an_organisation_ : Universe.

Variable mp2_favour_members_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulation_ S1 E T /\ (subpopulation_ S2 E T /\ (greater_ (cardinality_at_time_ S1 T) zero_ /\ (cardinality_at_time_ S2 T) = zero_)))) -> selection_favors_ S1 S2 T)).
Variable mp_number_mean_non_empty_2 : (forall E T : Universe, ((environment_ E /\ greater_ (number_of_organizations_ E T) zero_) -> (exists S : Universe, (subpopulation_ S E T /\ greater_ (cardinality_at_time_ S T) zero_)))).
Variable mp_zero_is_not_positive_3 : (forall X T : Universe, ((cardinality_at_time_ X t_) = zero_ -> ~(greater_ (cardinality_at_time_ X T) zero_))).
Variable mp_not_present_before_appearance_4 : (forall E X T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (appear_ X E) T)) -> (cardinality_at_time_ X T) = zero_)).
Variable mp_positive_and_sustains_5 : (forall E T : Universe, ((environment_ E /\ greater_ (number_of_organizations_ E T) zero_) -> in_environment_ E T)).
Variable mp_durations_are_time_intervals_6 : (forall E T1 T2 T : Universe, ((environment_ E /\ (in_environment_ E T1 /\ (in_environment_ E T2 /\ (greater_or_equal_ T2 T /\ greater_or_equal_ T T1)))) -> in_environment_ E T)).
Variable mp_opening_time_in_duration_7 : (forall E : Universe, (environment_ E -> in_environment_ E (start_time_ E))).
Variable mp_no_FM_before_opening_8 : (forall E : Universe, (environment_ E -> greater_or_equal_ (appear_ first_movers_ E) (start_time_ E))).
Variable mp_FM_means_organisations_9 : (forall E : Universe, ((environment_ E /\ in_environment_ E (appear_ first_movers_ E)) -> in_environment_ E (appear_ an_organisation_ E))).
Variable mp_FM_not_precede_first_10 : (forall E : Universe, (environment_ E -> greater_or_equal_ (appear_ first_movers_ E) (appear_ an_organisation_ E))).
Variable mp_positive_number_when_appear_11 : (forall E : Universe, (environment_ E -> greater_ (number_of_organizations_ e_ (appear_ an_organisation_ E)) zero_)).
Variable mp_subpopulations_12 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_greater_transitivity_13 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_greater_or_equal_14 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable a1_15 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ an_organisation_ E))) -> greater_ (number_of_organizations_ E T) zero_)).
Variable a3_16 : (forall E : Universe, (environment_ E -> greater_ (appear_ efficient_producers_ e_) (appear_ first_movers_ E))).
Variable a11_17 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)) -> (X = efficient_producers_ \/ X = first_movers_))).

Theorem prove_t2_18 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_or_equal_ T (appear_ first_movers_ E) /\ greater_ (appear_ efficient_producers_ E) T))) -> selection_favors_ first_movers_ efficient_producers_ T)).
Proof.
  time hprover.
Qed.

End FOFProblem.
