(*
% File     : MGT027+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : The FM set contracts in stable environments
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : The first mover set begins to contract past a certain time 
%            in stable environments. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.17 v2.6.0, 0.29 v2.5.0, 0.25 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   0 unit)
%            Number of atoms       :   40 (   1 equality)
%            Maximal formula depth :   10 (   7 average)
%            Number of connectives :   31 (   0 ~  ;   1  |;  19  &)
%                                         (   1 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-4 arity)
%            Number of functors    :    6 (   3 constant; 0-2 arity)
%            Number of variables   :   21 (   0 singleton;  19 !;   2 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable stable_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable contracts_from_ : Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.

Variable mp_contracts_from_1 : (forall E To : Universe, ((environment_ E /\ (stable_ E /\ (in_environment_ E To /\ (forall T : Universe, ((greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_or_equal_ T To) -> greater_ zero_ (growth_rate_ first_movers_ T)))))) -> contracts_from_ To first_movers_)).
Variable mp_non_empty_fm_and_ep_2 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))) -> subpopulations_ first_movers_ efficient_producers_ E T)).
Variable mp_long_stable_environments_3 : (forall E T1 T2 : Universe, ((environment_ E /\ (stable_ E /\ (in_environment_ E T1 /\ greater_ T2 T1))) -> in_environment_ E T2)).
Variable mp_EP_in_stable_environments_4 : (forall E : Universe, ((environment_ E /\ stable_ E) -> in_environment_ E (appear_ efficient_producers_ E))).
Variable mp_greater_transitivity_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_greater_or_equal_6 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable t6_7 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ efficient_producers_ E))) -> greater_ (cardinality_at_time_ efficient_producers_ T) zero_)).
Variable l10_8 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (greater_ To (appear_ efficient_producers_ E) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ zero_ (growth_rate_ first_movers_ T))))))).

Theorem prove_l9_9 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (greater_ To (appear_ efficient_producers_ E) /\ contracts_from_ To first_movers_)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
