(*
% File     : MGT026+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favors efficient producers past the critical point
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.22 v2.7.0, 0.33 v2.6.0, 0.43 v2.5.0, 0.38 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   11 (   0 unit)
%            Number of atoms       :   44 (   3 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   34 (   1 ~  ;   1  |;  20  &)
%                                         (   1 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-4 arity)
%            Number of functors    :    7 (   3 constant; 0-2 arity)
%            Number of variables   :   27 (   0 singleton;  27 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable zero_ : Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable critical_point_ : Universe -> Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable appear_ : Universe -> Universe -> Universe.

Variable mp1_high_growth_rates_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulations_ S1 S2 E T /\ greater_ (growth_rate_ S2 T) (growth_rate_ S1 T))) -> selection_favors_ S2 S1 T)).
Variable mp2_favour_members_2 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulation_ S1 E T /\ (subpopulation_ S2 E T /\ (greater_ (cardinality_at_time_ S1 T) zero_ /\ (cardinality_at_time_ S2 T) = zero_)))) -> selection_favors_ S1 S2 T)).
Variable mp_non_empty_fm_and_ep_3 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))) -> subpopulations_ first_movers_ efficient_producers_ E T)).
Variable mp_first_movers_exist_4 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> greater_or_equal_ (cardinality_at_time_ first_movers_ T) zero_)).
Variable mp_subpopulations_5 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_critical_point_after_EP_6 : (forall E : Universe, (environment_ E -> greater_or_equal_ (critical_point_ E) (appear_ efficient_producers_ E))).
Variable mp_greater_transitivity_7 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_greater_or_equal_8 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable d1_9 : (forall E Tc : Universe, ((environment_ E /\ Tc = (critical_point_ E)) -> (~(greater_ (growth_rate_ efficient_producers_ Tc) (growth_rate_ first_movers_ Tc)) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T Tc) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))).
Variable t6_10 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ efficient_producers_ E))) -> greater_ (cardinality_at_time_ efficient_producers_ T) zero_)).

Theorem prove_l8_11 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ T (critical_point_ E))) -> selection_favors_ efficient_producers_ first_movers_ T)).
Proof.
  time hprover.
Qed.

End FOFProblem.
