(*
% File     : MGT025+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Constant population means opposite growth rates
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : If one of the two subpopulations has positive growth rate, 
%            then the other subpopulation must have negative growth rate 
%            if the total number of organizations is constant. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.44 v2.7.0, 0.50 v2.6.0, 0.43 v2.5.0, 0.38 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    8 (   0 unit)
%            Number of atoms       :   49 (   9 equality)
%            Maximal formula depth :    9 (   7 average)
%            Number of connectives :   41 (   0 ~  ;   6  |;  23  &)
%                                         (   0 <=>;  12 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-4 arity)
%            Number of functors    :    7 (   3 constant; 0-2 arity)
%            Number of variables   :   20 (   0 singleton;  20 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable increases_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable decreases_ : Universe -> Prop.
Variable constant_ : Universe -> Prop.

Variable zero_ : Universe.
Variable sum_ : Universe -> Universe -> Universe.
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.

Variable mp_only_members_1 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ (greater_ (cardinality_at_time_ X T) zero_ -> (X = efficient_producers_ \/ X = first_movers_)))) -> (number_of_organizations_ E T) = (sum_ (cardinality_at_time_ first_movers_ T) (cardinality_at_time_ efficient_producers_ T)))).
Variable mp_subpopulations_2 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_abc_sum_increase_3 : (forall A B C : Universe, ((A = (sum_ B C) /\ constant_ A) -> ((constant_ B /\ constant_ C) \/ ((increases_ B /\ decreases_ C) \/ (decreases_ B /\ increases_ C))))).
Variable mp_growth_rate_4 : (forall X E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_))) -> ((constant_ (cardinality_at_time_ X T) -> (growth_rate_ X T) = zero_) /\ ((increases_ (cardinality_at_time_ X T) -> greater_ (growth_rate_ X T) zero_) /\ (decreases_ (cardinality_at_time_ X T) -> greater_ zero_ (growth_rate_ X T)))))).
Variable mp_non_zero_producers_5 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))).
Variable mp_time_point_occur_6 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable a9_7 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)) -> (X = efficient_producers_ \/ X = first_movers_))).

Theorem prove_l7_8 : (forall E T : Universe, ((environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T /\ constant_ (number_of_organizations_ E T))) -> (((growth_rate_ first_movers_ T) = zero_ /\ (growth_rate_ efficient_producers_ T) = zero_) \/ ((greater_ (growth_rate_ first_movers_ T) zero_ /\ greater_ zero_ (growth_rate_ efficient_producers_ T)) \/ (greater_ (growth_rate_ efficient_producers_ T) zero_ /\ greater_ zero_ (growth_rate_ first_movers_ T)))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
