(*
% File     : MGT023+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Stable environments have a critical point.
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.11 v2.7.0, 0.17 v2.6.0, 0.29 v2.5.0, 0.25 v2.4.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :   17 (   1 equality)
%            Maximal formula depth :   10 (   8 average)
%            Number of connectives :   16 (   2 ~  ;   0  |;   9  &)
%                                         (   0 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-4 arity)
%            Number of functors    :    4 (   2 constant; 0-2 arity)
%            Number of variables   :    7 (   0 singleton;   6 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable stable_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable critical_point_ : Universe -> Universe.

Variable d1_1 : (forall E To : Universe, ((environment_ E /\ (~(greater_ (growth_rate_ efficient_producers_ To) (growth_rate_ first_movers_ To)) /\ (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))) -> To = (critical_point_ E))).
Variable l12_2 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (~(greater_ (growth_rate_ efficient_producers_ To) (growth_rate_ first_movers_ To)) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))))).

Theorem prove_l5_3 : (forall E : Universe, ((environment_ E /\ stable_ E) -> in_environment_ E (critical_point_ E))).
Proof.
  time hprover.
Qed.

End FOFProblem.
