(*
% File     : MGT022+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Decreasing resource availability affects FMS more than EPs
% Version  : [PB+94] axioms.
% English  : Decreasing resource availability affects the disbanding rate 
%            of first movers more than the disbanding rate of efficient 
%            producers.
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : LEMMA 4 [PM93]
%          : L4 [PB+94]
% Status   : Theorem
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Rating (intuit.) : 0.00 v1.1
% Syntax   : Number of formulae    :    4 (   1 unit)
%            Number of atoms       :   16 (   0 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   14 (   2 ~  ;   0  |;   5  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-4 arity)
%            Number of functors    :    6 (   2 constant; 0-2 arity)
%            Number of variables   :    7 (   0 singleton;   7 !;   0 ?)
%            Maximal term depth    :    3 (   2 average)
% Comments : Same as version with [PM93] axioms.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable increases_ : Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable decreases_ : Universe -> Prop.
Variable constant_ : Universe -> Prop.

Variable resources_ : Universe -> Universe -> Universe.
Variable resilience_ : Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable disbanding_rate_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable mp_constant_not_decrease_1 : (forall X : Universe, (constant_ X -> ~(decreases_ X))).
Variable a5_2 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulations_ S1 S2 E T /\ greater_ (resilience_ S2) (resilience_ S1))) -> ((decreases_ (resources_ E T) -> increases_ (difference_ (disbanding_rate_ S1 T) (disbanding_rate_ S2 T))) /\ (constant_ (resources_ E T) -> constant_ (difference_ (disbanding_rate_ S1 T) (disbanding_rate_ S2 T)))))).
Variable a2_3 : greater_ (resilience_ efficient_producers_) (resilience_ first_movers_).

Theorem prove_l4_4 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> ((decreases_ (resources_ E T) -> increases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))) /\ (constant_ (resources_ E T) -> ~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
