(*
% File     : MGT021+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Difference between disbanding rates does not decrease
% Version  : [PB+94] axioms.
% English  : The difference between the disbanding rates of first movers 
%            and efficient producers does not decrease with time. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : LEMMA 3 [PM93]
%          : L3 [PB+94]
% Status   : Theorem
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Rating (intuit.) : 0.75 v1.1
% Syntax   : Number of formulae    :    7 (   0 unit)
%            Number of atoms       :   27 (   1 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   24 (   4 ~  ;   1  |;   8  &)
%                                         (   0 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-4 arity)
%            Number of functors    :    8 (   3 constant; 0-2 arity)
%            Number of variables   :   13 (   0 singleton;  13 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : Same as version with [PM93] axioms.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable increases_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.
Variable decreases_ : Universe -> Prop.
Variable constant_ : Universe -> Prop.

Variable zero_ : Universe.
Variable resources_ : Universe -> Universe -> Universe.
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable equilibrium_ : Universe -> Universe.
Variable efficient_producers_ : Universe.
Variable disbanding_rate_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable mp_time_point_in_environment_1 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable mp_environment_not_empty_2 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_ (number_of_organizations_ E T) zero_)).
Variable mp_increase_not_decrease_3 : (forall X : Universe, (increases_ X -> ~(decreases_ X))).
Variable mp_greater_or_equal_4 : (forall X Y : Universe, (greater_or_equal_ X Y -> (greater_ X Y \/ X = Y))).
Variable a3_5 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (number_of_organizations_ E T) zero_)) -> ((greater_ (equilibrium_ E) T -> decreases_ (resources_ E T)) /\ (~(greater_ (equilibrium_ E) T) -> constant_ (resources_ E T))))).
Variable l4_6 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> ((decreases_ (resources_ E T) -> increases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))) /\ (constant_ (resources_ E T) -> ~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))))))).

Theorem prove_l3_7 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> ~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
