(*
% File     : MGT019+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Growth rate of EPs exceeds that of FMs in stable environments
% Version  : [PM93] axioms.
% English  : The growth rate of efficent producers exceeds the growth rate 
%            of first movers past a certain time in stable environments.
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
% Source   : [PM93]
% Names    : LEMMA 1 [PM93]
%          : L1 [PB+94]
% Status   : CounterSatisfiable
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   21 (   1 equality)
%            Maximal formula depth :    8 (   6 average)
%            Number of connectives :   17 (   1 ~  ;   1  |;   8  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-4 arity)
%            Number of functors    :    5 (   2 constant; 0-2 arity)
%            Number of variables   :   11 (   0 singleton;   9 !;   2 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : There is no MGT019+1 as Kamps did not send it to me.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable stable_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable growth_rate_ : Universe -> Universe -> Universe.
Variable founding_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable disbanding_rate_ : Universe -> Universe -> Universe.

Variable l2_1 : ~((forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T)))).
Variable mp_EP_lower_disbanding_rate_2 : (forall T : Universe, ((greater_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T) /\ greater_or_equal_ (founding_rate_ efficient_producers_ T) (founding_rate_ first_movers_ T)) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))).
Variable mp_greater_or_equal_3 : (forall X Y : Universe, (greater_or_equal_ X Y -> (greater_ X Y \/ X = Y))).
Variable a8_4 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_or_equal_ (founding_rate_ efficient_producers_ T) (founding_rate_ first_movers_ T))))))).

Theorem prove_l1_5 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
