(*
% File     : MGT013+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : If organization complexity increases, its size cannot decrease 
% Version  : [PB+94] axioms.
% English  : If the complexity of an organization gets bigger, its size
%            cannot get smaller (in lack of reorganization).
% Refs     : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    :
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    9 (   0 unit)
%            Number of atoms       :   42 (   4 equality)
%            Maximal formula depth :   16 (   8 average)
%            Number of connectives :   38 (   5 ~  ;   2  |;  24  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   33 (   0 singleton;  33 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Not published due to publication constraints. [Kam95].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable time_ : Universe -> Prop.
Variable size_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_free_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable complexity_ : Universe -> Universe -> Universe -> Prop.


Variable mp6_1_1 : (forall X Y : Universe, ~((greater_ X Y /\ X = Y))).
Variable mp6_2_2 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable mp15_3 : (forall X T : Universe, (organization_ X T -> time_ T)).
Variable mp16_4 : (forall T1 T2 : Universe, ((time_ T1 /\ time_ T2) -> (greater_ T1 T2 \/ (T1 = T2 \/ greater_ T2 T1)))).
Variable mp17_5 : (forall X T1 T2 : Universe, (reorganization_free_ X T1 T2 -> reorganization_free_ X T2 T1)).
Variable mp18_6 : (forall X C1 C2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (complexity_ X C1 T1 /\ (complexity_ X C2 T2 /\ T1 = T2)))) -> C1 = C2)).
Variable t11_FOL_7 : (forall X S1 S2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (size_ X S1 T1 /\ (size_ X S2 T2 /\ greater_ T2 T1))))) -> ~(greater_ S1 S2))).
Variable t12_FOL_8 : (forall X C1 C2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (complexity_ X C1 T1 /\ (complexity_ X C2 T2 /\ greater_ T2 T1))))) -> ~(greater_ C1 C2))).

Theorem t13_FOL_9 : (forall X C1 C2 S1 S2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (complexity_ X C1 T1 /\ (complexity_ X C2 T2 /\ (size_ X S1 T1 /\ (size_ X S2 T2 /\ greater_ C2 C1))))))) -> ~(greater_ S1 S2))).
Proof.
  time hprover.
Qed.

End FOFProblem.
