(*
% File     : MGT009+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Large organization have higher reproducibility
% Version  : [PB+94] axioms.
% English  : 
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 9 [PB+92]
%          : T9FOL1 [PB+94]
% Status   : Theorem
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Rating (intuit.) : 0.75 v1.1
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   34 (   0 equality)
%            Maximal formula depth :   21 (  16 average)
%            Number of connectives :   30 (   0 ~  ;   0  |;  25  &)
%                                         (   1 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   29 (   0 singleton;  28 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable size_ : Universe -> Universe -> Universe -> Prop.
Variable reproducibility_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_free_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable inertia_ : Universe -> Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable class_ : Universe -> Universe -> Universe -> Prop.


Variable mp5_1 : (forall X T : Universe, (organization_ X T -> (exists I : Universe, inertia_ X I T))).
Variable a3_FOL_2 : (forall X Y T1 T2 Rp1 Rp2 I1 I2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reorganization_free_ X T1 T1 /\ (reorganization_free_ Y T2 T2 /\ (reproducibility_ X Rp1 T1 /\ (reproducibility_ Y Rp2 T2 /\ (inertia_ X I1 T1 /\ inertia_ Y I2 T2))))))) -> (greater_ Rp2 Rp1 <-> greater_ I2 I1))).
Variable a5_FOL_3 : (forall X Y C S1 S2 I1 I2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (class_ X C T1 /\ (class_ Y C T2 /\ (size_ X S1 T1 /\ (size_ Y S2 T2 /\ (inertia_ X I1 T1 /\ (inertia_ Y I2 T2 /\ greater_ S2 S1)))))))) -> greater_ I2 I1)).

Theorem t9_FOL_4 : (forall X Y C Rp1 Rp2 S1 S2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reorganization_free_ X T1 T1 /\ (reorganization_free_ Y T2 T2 /\ (class_ X C T1 /\ (class_ Y C T2 /\ (reproducibility_ X Rp1 T1 /\ (reproducibility_ Y Rp2 T2 /\ (size_ X S1 T1 /\ (size_ Y S2 T2 /\ greater_ S2 S1)))))))))) -> greater_ Rp2 Rp1)).
Proof.
  time hprover.
Qed.

End FOFProblem.
