(*
% File     : MGT005+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Complexity increases the risk of death due to reorganization.
% Version  : Especial.
%            Theorem formulation : Updated.
% English  : 
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 5+ [Kam94]
% Status   : Theorem
% Rating   : 0.22 v3.1.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   13 (   0 unit)
%            Number of atoms       :  104 (   7 equality)
%            Maximal formula depth :   34 (  14 average)
%            Number of connectives :   95 (   4 ~  ;   4  |;  74  &)
%                                         (   0 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 2-3 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   79 (   0 singleton;  75 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable survival_chance_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_type_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_free_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable complexity_ : Universe -> Universe -> Universe -> Prop.
Variable class_ : Universe -> Universe -> Universe -> Prop.

Variable p2_ : Universe.
Variable p1_ : Universe.

Variable mp6_1_1 : (forall X Y : Universe, ~((greater_ X Y /\ X = Y))).
Variable mp6_2_2 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable mp11_3 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp14_4 : (forall X Y P1 P2 T : Universe, ((survival_chance_ X P1 T /\ survival_chance_ Y P2 T) -> (greater_ p1_ p2_ \/ (p1_ = p2_ \/ greater_ p2_ p1_)))).
Variable mp12_5 : (forall X T : Universe, (organization_ X T -> (exists P : Universe, survival_chance_ X P T))).
Variable mp13_6 : (forall X T T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (greater_ T T1 /\ greater_ T2 T))) -> organization_ X T)).
Variable mp7_7 : (forall X Ta Tb : Universe, (reorganization_ X Ta Tb -> greater_ Tb Ta)).
Variable t3_FOL_8 : (forall X P1 P2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (survival_chance_ X P1 T1 /\ (survival_chance_ X P2 T2 /\ greater_ T2 T1))))) -> greater_ P2 P1)).
Variable t4_FOL_9 : (forall X P1 P2 T1 T2 Ta Tb : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_ X Ta Tb /\ (survival_chance_ X P1 T1 /\ (survival_chance_ X P2 T2 /\ (~(greater_ Ta T1) /\ (greater_ T2 T1 /\ ~(greater_ T2 Tb)))))))) -> greater_ P1 P2)).
Variable a10_FOL_10 : (forall X Y Re C C1 C2 Ta Tb Tc : Universe, ((organization_ X Ta /\ (organization_ Y Ta /\ (organization_ Y Tc /\ (class_ X C Ta /\ (class_ Y C Ta /\ (reorganization_ X Ta Tb /\ (reorganization_ Y Ta Tc /\ (reorganization_type_ X Re Ta /\ (reorganization_type_ Y Re Ta /\ (complexity_ X C1 Ta /\ (complexity_ Y C2 Ta /\ greater_ C2 C1))))))))))) -> greater_ Tc Tb)).
Variable a11_FOL_11 : (forall X Y Re C P P1 P2 C1 C2 Ta Tb Tc : Universe, ((organization_ X Ta /\ (organization_ Y Ta /\ (organization_ X Tb /\ (organization_ Y Tb /\ (class_ X C Ta /\ (class_ Y C Ta /\ (survival_chance_ X P Ta /\ (survival_chance_ Y P Ta /\ (reorganization_ X Ta Tb /\ (reorganization_ Y Ta Tc /\ (reorganization_type_ X Re Ta /\ (reorganization_type_ Y Re Ta /\ (survival_chance_ X P1 Tb /\ (survival_chance_ Y P2 Tb /\ (complexity_ X C1 Ta /\ (complexity_ Y C2 Ta /\ greater_ C2 C1)))))))))))))))) -> (greater_ P1 P2 \/ P1 = P2))).
Variable a15_FOL_12 : (forall X Y Px1 Px2 Py1 Py2 T1 T2 : Universe, ((greater_ T2 T1 /\ (survival_chance_ X Px1 T1 /\ (survival_chance_ Y Py1 T1 /\ (survival_chance_ X Px2 T2 /\ (survival_chance_ Y Py2 T2 /\ (greater_ Px2 Px1 /\ greater_ Py1 Px2)))))) -> (exists T0 Px0 Py0 : Universe, (greater_ T0 T1 /\ (greater_ T2 T0 /\ (survival_chance_ X Px0 T0 /\ (survival_chance_ Y Py0 T0 /\ Px0 = Py0))))))).

Theorem t5_plus_FOL_13 : (forall X Y Re C P P1 P2 C1 C2 T Ta Tb Tc : Universe, ((organization_ X Ta /\ (organization_ Y Ta /\ (organization_ X Tc /\ (organization_ Y Tc /\ (class_ X C Ta /\ (class_ Y C Ta /\ (survival_chance_ X P Ta /\ (survival_chance_ Y P Ta /\ (reorganization_ X Ta Tb /\ (reorganization_ Y Ta Tc /\ (reorganization_type_ X Re Ta /\ (reorganization_type_ Y Re Ta /\ (reorganization_free_ X Tb Tc /\ (survival_chance_ X P1 T /\ (survival_chance_ Y P2 T /\ (complexity_ X C1 Ta /\ (complexity_ Y C2 Ta /\ (greater_ C2 C1 /\ (T = Tc -> greater_ P1 P2))))))))))))))))))) -> (T = Tb -> (greater_ P1 P2 \/ P1 = P2)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
