(*
% File     : MGT004+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Attempts at reorganization increase death rates.
% Version  : [PB+94] axioms.
% English  : 
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 4 [PB+92]
%          : T4FOL1 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   36 (   0 equality)
%            Maximal formula depth :   21 (  14 average)
%            Number of connectives :   35 (   4 ~  ;   0  |;  26  &)
%                                         (   0 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   32 (   0 singleton;  30 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable survival_chance_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_ : Universe -> Universe -> Universe -> Prop.
Variable reliability_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable accountability_ : Universe -> Universe -> Universe -> Prop.


Variable mp1_1 : (forall X T : Universe, (organization_ X T -> (exists R : Universe, reliability_ X R T))).
Variable mp2_2 : (forall X T : Universe, (organization_ X T -> (exists A : Universe, accountability_ X A T))).
Variable a1_FOL_3 : (forall X Y R1 R2 A1 A2 P1 P2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reliability_ X R1 T1 /\ (reliability_ Y R2 T2 /\ (accountability_ X A1 T1 /\ (accountability_ Y A2 T2 /\ (survival_chance_ X P1 T1 /\ (survival_chance_ Y P2 T2 /\ (greater_ R2 R1 /\ greater_ A2 A1))))))))) -> greater_ P2 P1)).
Variable a6_FOL_4 : (forall X R1 R2 A1 A2 T1 T2 Ta Tb : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_ X Ta Tb /\ (reliability_ X R1 T1 /\ (reliability_ X R2 T2 /\ (accountability_ X A1 T1 /\ (accountability_ X A2 T2 /\ (~(greater_ Ta T1) /\ (greater_ T2 T1 /\ ~(greater_ T2 Tb)))))))))) -> (greater_ R1 R2 /\ greater_ A1 A2))).

Theorem t4_FOL_5 : (forall X P1 P2 T1 T2 Ta Tb : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_ X Ta Tb /\ (survival_chance_ X P1 T1 /\ (survival_chance_ X P2 T2 /\ (~(greater_ Ta T1) /\ (greater_ T2 T1 /\ ~(greater_ T2 Tb)))))))) -> greater_ P1 P2)).
Proof.
  time hprover.
Qed.

End FOFProblem.
