(*
% File     : MGT003+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Organizational death rates decrease with age.
% Version  : [PB+94] axioms.
% English  : 
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 3 [PB+92]
%          : T3FOL2 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   29 (   0 equality)
%            Maximal formula depth :   18 (  11 average)
%            Number of connectives :   24 (   0 ~  ;   0  |;  19  &)
%                                         (   0 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   24 (   0 singleton;  23 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable survival_chance_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_free_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable inertia_ : Universe -> Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.


Variable mp4_1 : (forall X T1 T2 : Universe, (reorganization_free_ X T1 T2 -> (reorganization_free_ X T1 T1 /\ reorganization_free_ X T2 T2))).
Variable mp5_2 : (forall X T : Universe, (organization_ X T -> (exists I : Universe, inertia_ X I T))).
Variable t1_FOL_3 : (forall X Y T1 T2 I1 I2 P1 P2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reorganization_free_ X T1 T1 /\ (reorganization_free_ Y T2 T2 /\ (inertia_ X I1 T1 /\ (inertia_ Y I2 T2 /\ (survival_chance_ X P1 T1 /\ (survival_chance_ Y P2 T2 /\ greater_ I2 I1)))))))) -> greater_ P2 P1)).
Variable t2_FOL_4 : (forall X I1 I2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (inertia_ X I1 T1 /\ (inertia_ X I2 T2 /\ greater_ T2 T1))))) -> greater_ I2 I1)).

Theorem t3_FOL_5 : (forall X P1 P2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (survival_chance_ X P1 T1 /\ (survival_chance_ X P2 T2 /\ greater_ T2 T1))))) -> greater_ P2 P1)).
Proof.
  time hprover.
Qed.

End FOFProblem.
