(*
% File     : MGT001+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favors organizations with high inertia
% Version  : [PB+94] axioms.
% English  : Selection within populations of organizations in modern
%            societies favours organizations whose structure have high
%            inertia.
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 1 [PB+92]
%          : T1FOL3 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :    7 (   0 unit)
%            Number of atoms       :   48 (   0 equality)
%            Maximal formula depth :   21 (  13 average)
%            Number of connectives :   41 (   0 ~  ;   0  |;  32  &)
%                                         (   2 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   45 (   0 singleton;  42 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable survival_chance_ : Universe -> Universe -> Universe -> Prop.
Variable reproducibility_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_free_ : Universe -> Universe -> Universe -> Prop.
Variable reliability_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable inertia_ : Universe -> Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable accountability_ : Universe -> Universe -> Universe -> Prop.


Variable mp1_1 : (forall X T : Universe, (organization_ X T -> (exists R : Universe, reliability_ X R T))).
Variable mp2_2 : (forall X T : Universe, (organization_ X T -> (exists A : Universe, accountability_ X A T))).
Variable mp3_3 : (forall X T : Universe, (organization_ X T -> (exists Rp : Universe, reproducibility_ X Rp T))).
Variable a1_FOL_4 : (forall X Y R1 R2 A1 A2 P1 P2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reliability_ X R1 T1 /\ (reliability_ Y R2 T2 /\ (accountability_ X A1 T1 /\ (accountability_ Y A2 T2 /\ (survival_chance_ X P1 T1 /\ (survival_chance_ Y P2 T2 /\ (greater_ R2 R1 /\ greater_ A2 A1))))))))) -> greater_ P2 P1)).
Variable a2_FOL_5 : (forall X Y T1 T2 R1 R2 A1 A2 Rp1 Rp2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reliability_ X R1 T1 /\ (reliability_ Y R2 T2 /\ (accountability_ X A1 T1 /\ (accountability_ Y A2 T2 /\ (reproducibility_ X Rp1 T1 /\ reproducibility_ Y Rp2 T2))))))) -> (greater_ Rp2 Rp1 <-> (greater_ R2 R1 /\ greater_ A2 A1)))).
Variable a3_FOL_6 : (forall X Y T1 T2 Rp1 Rp2 I1 I2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reorganization_free_ X T1 T1 /\ (reorganization_free_ Y T2 T2 /\ (reproducibility_ X Rp1 T1 /\ (reproducibility_ Y Rp2 T2 /\ (inertia_ X I1 T1 /\ inertia_ Y I2 T2))))))) -> (greater_ Rp2 Rp1 <-> greater_ I2 I1))).

Theorem t1_FOL_7 : (forall X Y T1 T2 I1 I2 P1 P2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reorganization_free_ X T1 T1 /\ (reorganization_free_ Y T2 T2 /\ (inertia_ X I1 T1 /\ (inertia_ Y I2 T2 /\ (survival_chance_ X P1 T1 /\ (survival_chance_ Y P2 T2 /\ greater_ I2 I1)))))))) -> greater_ P2 P1)).
Proof.
  time hprover.
Qed.

End FOFProblem.
