(*
% File     : LCL414+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Peter Andrews Problem THM147
% Version  : Especial.
% English  : 
% Refs     : [And97] Andrews (1994), Email to G. Sutcliffe
% Source   : [And97]
% Names    : THM147 [And97]
% Status   : Theorem
% Rating   : 0.00 v2.5.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.1.0, 0.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :    7 (   0 equality)
%            Maximal formula depth :    8 (   8 average)
%            Number of connectives :   10 (   4 ~  ;   2  |;   4  &)
%                                         (   0 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 1-1 arity)
%            Number of functors    :    2 (   0 constant; 1-2 arity)
%            Number of variables   :   10 (   0 singleton;   9 !;   1 ?)
%            Maximal term depth    :    4 (   2 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable a_truth_ : Universe -> Prop.

Variable not_ : Universe -> Universe.
Variable implies_ : Universe -> Universe -> Universe.


Theorem thm147_1 : ~(((forall P Q : Universe, (~(a_truth_ (implies_ P Q)) \/ (~(a_truth_ P) \/ a_truth_ Q))) /\ ((forall P Q : Universe, a_truth_ (implies_ P (implies_ Q P))) /\ ((forall P Q R : Universe, a_truth_ (implies_ (implies_ P (implies_ Q R)) (implies_ (implies_ P Q) (implies_ P R)))) /\ ((forall P Q : Universe, a_truth_ (implies_ (implies_ (not_ P) (not_ Q)) (implies_ Q P))) /\ (exists A : Universe, ~(a_truth_ (implies_ A A)))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
