(*
% File     : KRS174+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Sets with appropriate extensions are related by unionOf
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_unionOf-Manifest003 [Bec03]
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   15 (   2 unit)
%            Number of atoms       :   41 (  11 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   30 (   4 ~  ;   2  |;  11  &)
%                                         (   6 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   22 (   0 singleton;  22 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cB_ : Universe -> Prop.
Variable cA_and_B_ : Universe -> Prop.
Variable cA_ : Universe -> Prop.

Variable ib_ : Universe.
Variable ia_ : Universe.

Variable cA_substitution_1_1 : (forall A B : Universe, ((A = B /\ cA_ A) -> cA_ B)).
Variable cA_and_B_substitution_1_2 : (forall A B : Universe, ((A = B /\ cA_and_B_ A) -> cA_and_B_ B)).
Variable cB_substitution_1_3 : (forall A B : Universe, ((A = B /\ cB_ A) -> cB_ B)).
Variable cowlNothing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable xsd_integer_substitution_1_6 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_7 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_8 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_9 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_10 : (forall X : Universe, (cA_ X <-> X = ia_)).
Variable axiom_3_11 : (forall X : Universe, (cA_and_B_ X <-> (X = ib_ \/ X = ia_))).
Variable axiom_4_12 : (forall X : Universe, (cB_ X <-> X = ib_)).
Variable axiom_5_13 : cowlThing_ ia_.
Variable axiom_6_14 : cowlThing_ ib_.

Theorem the_axiom_15 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (forall X : Universe, (cA_and_B_ X <-> (cB_ X \/ cA_ X))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
