(*
% File     : KRS163+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Disjoint classes have different members
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_disjointWith-Manifest001 [Bec03]
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   14 (   4 unit)
%            Number of atoms       :   35 (   7 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   27 (   6 ~  ;   0  |;  13  &)
%                                         (   2 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   17 (   0 singleton;  17 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cB_ : Universe -> Prop.
Variable cA_ : Universe -> Prop.

Variable ib_ : Universe.
Variable ia_ : Universe.

Variable cA_substitution_1_1 : (forall A B : Universe, ((A = B /\ cA_ A) -> cA_ B)).
Variable cB_substitution_1_2 : (forall A B : Universe, ((A = B /\ cB_ A) -> cB_ B)).
Variable cowlNothing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable xsd_integer_substitution_1_5 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_6 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_7 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_8 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_9 : cA_ ia_.
Variable axiom_3_10 : cowlThing_ ia_.
Variable axiom_4_11 : cB_ ib_.
Variable axiom_5_12 : cowlThing_ ib_.
Variable axiom_6_13 : (forall X : Universe, ~((cB_ X /\ cA_ X))).

Theorem the_axiom_14 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cowlThing_ ia_ /\ (cowlThing_ ib_ /\ ia_ <> ib_)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
