(*
% File     : KRS160+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_ph ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest667 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   23 (   8 unit)
%            Number of atoms       :   49 (   0 equality)
%            Maximal formula depth :    6 (   3 average)
%            Number of connectives :   33 (   7 ~  ;   0  |;  12  &)
%                                         (  13 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   18 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   24 (   0 singleton;  16 !;   8 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable ra_Px4_ : Universe -> Universe -> Prop.
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC8xcomp_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC6xcomp_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC2xcomp_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV21081_ : Universe.
Variable iV21080_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (cC4_ X /\ cC2_ X))).
Variable axiom_3_4 : (forall X : Universe, (cC12_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC10_ Y)))).
Variable axiom_4_5 : (forall X : Universe, (cC2_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_5_6 : (forall X : Universe, (cC2xcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_6_7 : (forall X : Universe, (cC6_ X <-> (cC2xcomp_ X /\ cC4_ X))).
Variable axiom_7_8 : (forall X : Universe, (cC6_ X <-> ~((exists Y : Universe, ra_Px4_ X Y)))).
Variable axiom_8_9 : (forall X : Universe, (cC6xcomp_ X <-> (exists Y0 : Universe, ra_Px4_ X Y0))).
Variable axiom_9_10 : (forall X : Universe, (cC8_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_10_11 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6_ Y)))).
Variable axiom_11_12 : (forall X : Universe, (cC8xcomp_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_12_13 : (forall X : Universe, (cTEST_ X <-> (cC8xcomp_ X /\ cC12_ X))).
Variable axiom_13_14 : cTEST_ iV21080_.
Variable axiom_14_15 : cC8xcomp_ iV21080_.
Variable axiom_15_16 : cowlThing_ iV21080_.
Variable axiom_16_17 : (forall X : Universe, (rR1_ iV21080_ X -> cC6xcomp_ X)).
Variable axiom_17_18 : rR1_ iV21080_ iV21081_.
Variable axiom_18_19 : cC4_ iV21081_.
Variable axiom_19_20 : cC6xcomp_ iV21081_.
Variable axiom_20_21 : cC2_ iV21081_.
Variable axiom_21_22 : cowlThing_ iV21081_.

Theorem the_axiom_23 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cowlThing_ iV21080_ /\ (cC12_ iV21080_ /\ (cC10_ iV21081_ /\ cowlThing_ iV21081_))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
