(*
% File     : KRS159+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_path ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest666 [Bec03]
% Status   : Theorem
% Rating   : 0.44 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :  343 ( 127 unit)
%            Number of atoms       :  690 (   0 equality)
%            Maximal formula depth :   52 (   3 average)
%            Number of connectives :  401 (  54 ~  ;   0  |; 132  &)
%                                         ( 187 <=>;  28 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :  197 (   0 propositional; 1-2 arity)
%            Number of functors    :   11 (  11 constant; 0-0 arity)
%            Number of variables   :  353 (   0 singleton; 217 !; 136 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable ra_Px92_ : Universe -> Universe -> Prop.
Variable ra_Px91_ : Universe -> Universe -> Prop.
Variable ra_Px90_ : Universe -> Universe -> Prop.
Variable ra_Px9_ : Universe -> Universe -> Prop.
Variable ra_Px89_ : Universe -> Universe -> Prop.
Variable ra_Px88_ : Universe -> Universe -> Prop.
Variable ra_Px87_ : Universe -> Universe -> Prop.
Variable ra_Px86_ : Universe -> Universe -> Prop.
Variable ra_Px85_ : Universe -> Universe -> Prop.
Variable ra_Px84_ : Universe -> Universe -> Prop.
Variable ra_Px83_ : Universe -> Universe -> Prop.
Variable ra_Px82_ : Universe -> Universe -> Prop.
Variable ra_Px81_ : Universe -> Universe -> Prop.
Variable ra_Px80_ : Universe -> Universe -> Prop.
Variable ra_Px8_ : Universe -> Universe -> Prop.
Variable ra_Px79_ : Universe -> Universe -> Prop.
Variable ra_Px78_ : Universe -> Universe -> Prop.
Variable ra_Px77_ : Universe -> Universe -> Prop.
Variable ra_Px60_ : Universe -> Universe -> Prop.
Variable ra_Px58_ : Universe -> Universe -> Prop.
Variable ra_Px56_ : Universe -> Universe -> Prop.
Variable ra_Px55_ : Universe -> Universe -> Prop.
Variable ra_Px52_ : Universe -> Universe -> Prop.
Variable ra_Px51_ : Universe -> Universe -> Prop.
Variable ra_Px50_ : Universe -> Universe -> Prop.
Variable ra_Px5_ : Universe -> Universe -> Prop.
Variable ra_Px47_ : Universe -> Universe -> Prop.
Variable ra_Px44_ : Universe -> Universe -> Prop.
Variable ra_Px43_ : Universe -> Universe -> Prop.
Variable ra_Px42_ : Universe -> Universe -> Prop.
Variable ra_Px39_ : Universe -> Universe -> Prop.
Variable ra_Px36_ : Universe -> Universe -> Prop.
Variable ra_Px35_ : Universe -> Universe -> Prop.
Variable ra_Px34_ : Universe -> Universe -> Prop.
Variable ra_Px33_ : Universe -> Universe -> Prop.
Variable ra_Px3_ : Universe -> Universe -> Prop.
Variable ra_Px29_ : Universe -> Universe -> Prop.
Variable ra_Px28_ : Universe -> Universe -> Prop.
Variable ra_Px27_ : Universe -> Universe -> Prop.
Variable ra_Px26_ : Universe -> Universe -> Prop.
Variable ra_Px25_ : Universe -> Universe -> Prop.
Variable ra_Px24_ : Universe -> Universe -> Prop.
Variable ra_Px21_ : Universe -> Universe -> Prop.
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable ra_Px18_ : Universe -> Universe -> Prop.
Variable ra_Px17_ : Universe -> Universe -> Prop.
Variable ra_Px16_ : Universe -> Universe -> Prop.
Variable ra_Px13_ : Universe -> Universe -> Prop.
Variable ra_Px10_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTOP_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC98xcomp_ : Universe -> Prop.
Variable cC98_ : Universe -> Prop.
Variable cC96xcomp_ : Universe -> Prop.
Variable cC96_ : Universe -> Prop.
Variable cC94xcomp_ : Universe -> Prop.
Variable cC94_ : Universe -> Prop.
Variable cC92xcomp_ : Universe -> Prop.
Variable cC92_ : Universe -> Prop.
Variable cC90_ : Universe -> Prop.
Variable cC88_ : Universe -> Prop.
Variable cC86_ : Universe -> Prop.
Variable cC84_ : Universe -> Prop.
Variable cC82_ : Universe -> Prop.
Variable cC80_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC78_ : Universe -> Prop.
Variable cC76xcomp_ : Universe -> Prop.
Variable cC76_ : Universe -> Prop.
Variable cC74xcomp_ : Universe -> Prop.
Variable cC74_ : Universe -> Prop.
Variable cC72xcomp_ : Universe -> Prop.
Variable cC72_ : Universe -> Prop.
Variable cC70xcomp_ : Universe -> Prop.
Variable cC70_ : Universe -> Prop.
Variable cC6xcomp_ : Universe -> Prop.
Variable cC68xcomp_ : Universe -> Prop.
Variable cC68_ : Universe -> Prop.
Variable cC66xcomp_ : Universe -> Prop.
Variable cC66_ : Universe -> Prop.
Variable cC64_ : Universe -> Prop.
Variable cC62_ : Universe -> Prop.
Variable cC60_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC58_ : Universe -> Prop.
Variable cC56_ : Universe -> Prop.
Variable cC54xcomp_ : Universe -> Prop.
Variable cC54_ : Universe -> Prop.
Variable cC52xcomp_ : Universe -> Prop.
Variable cC52_ : Universe -> Prop.
Variable cC50xcomp_ : Universe -> Prop.
Variable cC50_ : Universe -> Prop.
Variable cC48xcomp_ : Universe -> Prop.
Variable cC48_ : Universe -> Prop.
Variable cC46xcomp_ : Universe -> Prop.
Variable cC46_ : Universe -> Prop.
Variable cC44xcomp_ : Universe -> Prop.
Variable cC44_ : Universe -> Prop.
Variable cC42_ : Universe -> Prop.
Variable cC40_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC38_ : Universe -> Prop.
Variable cC36_ : Universe -> Prop.
Variable cC34xcomp_ : Universe -> Prop.
Variable cC34_ : Universe -> Prop.
Variable cC32xcomp_ : Universe -> Prop.
Variable cC32_ : Universe -> Prop.
Variable cC30xcomp_ : Universe -> Prop.
Variable cC30_ : Universe -> Prop.
Variable cC2xcomp_ : Universe -> Prop.
Variable cC28xcomp_ : Universe -> Prop.
Variable cC28_ : Universe -> Prop.
Variable cC26xcomp_ : Universe -> Prop.
Variable cC26_ : Universe -> Prop.
Variable cC24xcomp_ : Universe -> Prop.
Variable cC24_ : Universe -> Prop.
Variable cC22_ : Universe -> Prop.
Variable cC20_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC18xcomp_ : Universe -> Prop.
Variable cC180_ : Universe -> Prop.
Variable cC18_ : Universe -> Prop.
Variable cC178xcomp_ : Universe -> Prop.
Variable cC178_ : Universe -> Prop.
Variable cC176xcomp_ : Universe -> Prop.
Variable cC176_ : Universe -> Prop.
Variable cC174_ : Universe -> Prop.
Variable cC172xcomp_ : Universe -> Prop.
Variable cC172_ : Universe -> Prop.
Variable cC170xcomp_ : Universe -> Prop.
Variable cC170_ : Universe -> Prop.
Variable cC168_ : Universe -> Prop.
Variable cC166xcomp_ : Universe -> Prop.
Variable cC166_ : Universe -> Prop.
Variable cC164xcomp_ : Universe -> Prop.
Variable cC164_ : Universe -> Prop.
Variable cC162xcomp_ : Universe -> Prop.
Variable cC162_ : Universe -> Prop.
Variable cC160xcomp_ : Universe -> Prop.
Variable cC160_ : Universe -> Prop.
Variable cC16_ : Universe -> Prop.
Variable cC158_ : Universe -> Prop.
Variable cC156_ : Universe -> Prop.
Variable cC154_ : Universe -> Prop.
Variable cC152_ : Universe -> Prop.
Variable cC150xcomp_ : Universe -> Prop.
Variable cC150_ : Universe -> Prop.
Variable cC148xcomp_ : Universe -> Prop.
Variable cC148_ : Universe -> Prop.
Variable cC146xcomp_ : Universe -> Prop.
Variable cC146_ : Universe -> Prop.
Variable cC144xcomp_ : Universe -> Prop.
Variable cC144_ : Universe -> Prop.
Variable cC142xcomp_ : Universe -> Prop.
Variable cC142_ : Universe -> Prop.
Variable cC140xcomp_ : Universe -> Prop.
Variable cC140_ : Universe -> Prop.
Variable cC14_ : Universe -> Prop.
Variable cC138_ : Universe -> Prop.
Variable cC136_ : Universe -> Prop.
Variable cC134_ : Universe -> Prop.
Variable cC132_ : Universe -> Prop.
Variable cC130_ : Universe -> Prop.
Variable cC12xcomp_ : Universe -> Prop.
Variable cC128xcomp_ : Universe -> Prop.
Variable cC128_ : Universe -> Prop.
Variable cC126xcomp_ : Universe -> Prop.
Variable cC126_ : Universe -> Prop.
Variable cC124xcomp_ : Universe -> Prop.
Variable cC124_ : Universe -> Prop.
Variable cC122xcomp_ : Universe -> Prop.
Variable cC122_ : Universe -> Prop.
Variable cC120xcomp_ : Universe -> Prop.
Variable cC120_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC118xcomp_ : Universe -> Prop.
Variable cC118_ : Universe -> Prop.
Variable cC116_ : Universe -> Prop.
Variable cC114_ : Universe -> Prop.
Variable cC112_ : Universe -> Prop.
Variable cC110_ : Universe -> Prop.
Variable cC108_ : Universe -> Prop.
Variable cC106xcomp_ : Universe -> Prop.
Variable cC106_ : Universe -> Prop.
Variable cC104xcomp_ : Universe -> Prop.
Variable cC104_ : Universe -> Prop.
Variable cC102xcomp_ : Universe -> Prop.
Variable cC102_ : Universe -> Prop.
Variable cC100xcomp_ : Universe -> Prop.
Variable cC100_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV21036_ : Universe.
Variable iV21035_ : Universe.
Variable iV21034_ : Universe.
Variable iV21033_ : Universe.
Variable iV21032_ : Universe.
Variable iV21031_ : Universe.
Variable iV21030_ : Universe.
Variable iV21029_ : Universe.
Variable iV21028_ : Universe.
Variable iV21027_ : Universe.
Variable iV21026_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (cC8_ X /\ cC4_ X))).
Variable axiom_3_4 : (forall X : Universe, (cC100_ X <-> (exists Y0 : Universe, ra_Px33_ X Y0))).
Variable axiom_4_5 : (forall X : Universe, (cC100xcomp_ X <-> ~((exists Y : Universe, ra_Px33_ X Y)))).
Variable axiom_5_6 : (forall X : Universe, (cC102_ X <-> ~((exists Y : Universe, ra_Px34_ X Y)))).
Variable axiom_6_7 : (forall X : Universe, (cC102_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6xcomp_ Y)))).
Variable axiom_7_8 : (forall X : Universe, (cC102xcomp_ X <-> (exists Y0 : Universe, ra_Px34_ X Y0))).
Variable axiom_8_9 : (forall X : Universe, (cC104_ X <-> (cC102xcomp_ X /\ cC100xcomp_ X))).
Variable axiom_9_10 : (forall X : Universe, (cC104_ X <-> ~((exists Y : Universe, ra_Px85_ X Y)))).
Variable axiom_10_11 : (forall X : Universe, (cC104xcomp_ X <-> (exists Y0 : Universe, ra_Px85_ X Y0))).
Variable axiom_11_12 : (forall X : Universe, (cC106_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC104_ Y)))).
Variable axiom_12_13 : (forall X : Universe, (cC106_ X <-> (exists Y0 : Universe, ra_Px36_ X Y0))).
Variable axiom_13_14 : (forall X : Universe, (cC106xcomp_ X <-> ~((exists Y : Universe, ra_Px36_ X Y)))).
Variable axiom_14_15 : (forall X : Universe, (cC108_ X <-> (cC98xcomp_ X /\ cC106xcomp_ X))).
Variable axiom_15_16 : (forall X : Universe, (cC110_ X <-> (cC108_ X /\ cTOP_ X))).
Variable axiom_16_17 : (forall X : Universe, (cC112_ X <-> (cC110_ X /\ cC90_ X))).
Variable axiom_17_18 : (forall X : Universe, (cC114_ X <-> cTOP_ X)).
Variable axiom_18_19 : (forall X : Universe, (cC116_ X <-> (cC114_ X /\ cC112_ X))).
Variable axiom_19_20 : (forall X : Universe, (cC118_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC92xcomp_ Y)))).
Variable axiom_20_21 : (forall X : Universe, (cC118_ X <-> (exists Y0 : Universe, ra_Px39_ X Y0))).
Variable axiom_21_22 : (forall X : Universe, (cC118xcomp_ X <-> ~((exists Y : Universe, ra_Px39_ X Y)))).
Variable axiom_22_23 : (forall X : Universe, (cC12_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_23_24 : (forall X : Universe, (cC12xcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_24_25 : (forall X : Universe, (cC120_ X <-> (exists Y0 : Universe, ra_Px84_ X Y0))).
Variable axiom_25_26 : (forall X : Universe, (cC120_ X <-> (cC92xcomp_ X /\ cC118xcomp_ X))).
Variable axiom_26_27 : (forall X : Universe, (cC120xcomp_ X <-> ~((exists Y : Universe, ra_Px84_ X Y)))).
Variable axiom_27_28 : (forall X : Universe, (cC122_ X <-> ~((exists Y : Universe, ra_Px43_ X Y)))).
Variable axiom_28_29 : (forall X : Universe, (cC122_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC120_ Y)))).
Variable axiom_29_30 : (forall X : Universe, (cC122xcomp_ X <-> (exists Y0 : Universe, ra_Px43_ X Y0))).
Variable axiom_30_31 : (forall X : Universe, (cC124_ X <-> (exists Y0 : Universe, ra_Px42_ X Y0))).
Variable axiom_31_32 : (forall X : Universe, (cC124_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC92xcomp_ Y)))).
Variable axiom_32_33 : (forall X : Universe, (cC124xcomp_ X <-> ~((exists Y : Universe, ra_Px42_ X Y)))).
Variable axiom_33_34 : (forall X : Universe, (cC126_ X <-> (exists Y0 : Universe, ra_Px83_ X Y0))).
Variable axiom_34_35 : (forall X : Universe, (cC126_ X <-> (cC124xcomp_ X /\ cC100xcomp_ X))).
Variable axiom_35_36 : (forall X : Universe, (cC126xcomp_ X <-> ~((exists Y : Universe, ra_Px83_ X Y)))).
Variable axiom_36_37 : (forall X : Universe, (cC128_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC126_ Y)))).
Variable axiom_37_38 : (forall X : Universe, (cC128_ X <-> (exists Y0 : Universe, ra_Px44_ X Y0))).
Variable axiom_38_39 : (forall X : Universe, (cC128xcomp_ X <-> ~((exists Y : Universe, ra_Px44_ X Y)))).
Variable axiom_39_40 : (forall X : Universe, (cC130_ X <-> (cC128xcomp_ X /\ cC122xcomp_ X))).
Variable axiom_40_41 : (forall X : Universe, (cC132_ X <-> (cC130_ X /\ cTOP_ X))).
Variable axiom_41_42 : (forall X : Universe, (cC134_ X <-> (cC116_ X /\ cC132_ X))).
Variable axiom_42_43 : (forall X : Universe, (cC136_ X <-> cTOP_ X)).
Variable axiom_43_44 : (forall X : Universe, (cC138_ X <-> (cC136_ X /\ cC134_ X))).
Variable axiom_44_45 : (forall X : Universe, (cC14_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC12xcomp_ Y)))).
Variable axiom_45_46 : (forall X : Universe, (cC140_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC100xcomp_ Y)))).
Variable axiom_46_47 : (forall X : Universe, (cC140_ X <-> (exists Y0 : Universe, ra_Px47_ X Y0))).
Variable axiom_47_48 : (forall X : Universe, (cC140xcomp_ X <-> ~((exists Y : Universe, ra_Px47_ X Y)))).
Variable axiom_48_49 : (forall X : Universe, (cC142_ X <-> (cC140xcomp_ X /\ cC92xcomp_ X))).
Variable axiom_49_50 : (forall X : Universe, (cC142_ X <-> ~((exists Y : Universe, ra_Px82_ X Y)))).
Variable axiom_50_51 : (forall X : Universe, (cC142xcomp_ X <-> (exists Y0 : Universe, ra_Px82_ X Y0))).
Variable axiom_51_52 : (forall X : Universe, (cC144_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC142_ Y)))).
Variable axiom_52_53 : (forall X : Universe, (cC144_ X <-> (exists Y0 : Universe, ra_Px51_ X Y0))).
Variable axiom_53_54 : (forall X : Universe, (cC144xcomp_ X <-> ~((exists Y : Universe, ra_Px51_ X Y)))).
Variable axiom_54_55 : (forall X : Universe, (cC146_ X <-> (exists Y0 : Universe, ra_Px50_ X Y0))).
Variable axiom_55_56 : (forall X : Universe, (cC146_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC100xcomp_ Y)))).
Variable axiom_56_57 : (forall X : Universe, (cC146xcomp_ X <-> ~((exists Y : Universe, ra_Px50_ X Y)))).
Variable axiom_57_58 : (forall X : Universe, (cC148_ X <-> (exists Y0 : Universe, ra_Px81_ X Y0))).
Variable axiom_58_59 : (forall X : Universe, (cC148_ X <-> (cC100xcomp_ X /\ cC146xcomp_ X))).
Variable axiom_59_60 : (forall X : Universe, (cC148xcomp_ X <-> ~((exists Y : Universe, ra_Px81_ X Y)))).
Variable axiom_60_61 : (forall X : Universe, (cC150_ X <-> ~((exists Y : Universe, ra_Px52_ X Y)))).
Variable axiom_61_62 : (forall X : Universe, (cC150_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC148_ Y)))).
Variable axiom_62_63 : (forall X : Universe, (cC150xcomp_ X <-> (exists Y0 : Universe, ra_Px52_ X Y0))).
Variable axiom_63_64 : (forall X : Universe, (cC152_ X <-> (cC144xcomp_ X /\ cC150xcomp_ X))).
Variable axiom_64_65 : (forall X : Universe, (cC154_ X <-> (cC152_ X /\ cTOP_ X))).
Variable axiom_65_66 : (forall X : Universe, (cC156_ X <-> (cC154_ X /\ cC138_ X))).
Variable axiom_66_67 : (forall X : Universe, (cC158_ X <-> (cC22_ X /\ cC156_ X))).
Variable axiom_67_68 : (forall X : Universe, (cC16_ X <-> (cC10_ X /\ cC14_ X))).
Variable axiom_68_69 : (forall X : Universe, (cC160_ X <-> (exists Y0 : Universe, ra_Px80_ X Y0))).
Variable axiom_69_70 : (forall X : Universe, (cC160_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6xcomp_ Y)))).
Variable axiom_70_71 : (forall X : Universe, (cC160xcomp_ X <-> ~((exists Y : Universe, ra_Px80_ X Y)))).
Variable axiom_71_72 : (forall X : Universe, (cC162_ X <-> ~((exists Y : Universe, ra_Px55_ X Y)))).
Variable axiom_72_73 : (forall X : Universe, (cC162_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC160_ Y)))).
Variable axiom_73_74 : (forall X : Universe, (cC162xcomp_ X <-> (exists Y0 : Universe, ra_Px55_ X Y0))).
Variable axiom_74_75 : (forall X : Universe, (cC164_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC92xcomp_ Y)))).
Variable axiom_75_76 : (forall X : Universe, (cC164_ X <-> ~((exists Y : Universe, ra_Px79_ X Y)))).
Variable axiom_76_77 : (forall X : Universe, (cC164xcomp_ X <-> (exists Y0 : Universe, ra_Px79_ X Y0))).
Variable axiom_77_78 : (forall X : Universe, (cC166_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC164_ Y)))).
Variable axiom_78_79 : (forall X : Universe, (cC166_ X <-> (exists Y0 : Universe, ra_Px56_ X Y0))).
Variable axiom_79_80 : (forall X : Universe, (cC166xcomp_ X <-> ~((exists Y : Universe, ra_Px56_ X Y)))).
Variable axiom_80_81 : (forall X : Universe, (cC168_ X <-> (cC162xcomp_ X /\ cC166xcomp_ X))).
Variable axiom_81_82 : (forall X : Universe, (cC170_ X <-> (exists Y0 : Universe, ra_Px78_ X Y0))).
Variable axiom_82_83 : (forall X : Universe, (cC170_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC18xcomp_ Y)))).
Variable axiom_83_84 : (forall X : Universe, (cC170xcomp_ X <-> ~((exists Y : Universe, ra_Px78_ X Y)))).
Variable axiom_84_85 : (forall X : Universe, (cC172_ X <-> ~((exists Y : Universe, ra_Px58_ X Y)))).
Variable axiom_85_86 : (forall X : Universe, (cC172_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC170_ Y)))).
Variable axiom_86_87 : (forall X : Universe, (cC172xcomp_ X <-> (exists Y0 : Universe, ra_Px58_ X Y0))).
Variable axiom_87_88 : (forall X : Universe, (cC174_ X <-> (cC172xcomp_ X /\ cC168_ X))).
Variable axiom_88_89 : (forall X : Universe, (cC176_ X <-> (exists Y0 : Universe, ra_Px77_ X Y0))).
Variable axiom_89_90 : (forall X : Universe, (cC176_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC100xcomp_ Y)))).
Variable axiom_90_91 : (forall X : Universe, (cC176xcomp_ X <-> ~((exists Y : Universe, ra_Px77_ X Y)))).
Variable axiom_91_92 : (forall X : Universe, (cC178_ X <-> (exists Y0 : Universe, ra_Px60_ X Y0))).
Variable axiom_92_93 : (forall X : Universe, (cC178_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC176_ Y)))).
Variable axiom_93_94 : (forall X : Universe, (cC178xcomp_ X <-> ~((exists Y : Universe, ra_Px60_ X Y)))).
Variable axiom_94_95 : (forall X : Universe, (cC18_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_95_96 : (forall X : Universe, (cC18xcomp_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_96_97 : (forall X : Universe, (cC180_ X <-> (cC174_ X /\ cC178xcomp_ X))).
Variable axiom_97_98 : (forall X : Universe, (cC2_ X <-> (exists Y0 : Universe, ra_Px3_ X Y0))).
Variable axiom_98_99 : (forall X : Universe, (cC2xcomp_ X <-> ~((exists Y : Universe, ra_Px3_ X Y)))).
Variable axiom_99_100 : (forall X : Universe, (cC20_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC18xcomp_ Y)))).
Variable axiom_100_101 : (forall X : Universe, (cC22_ X <-> (cC20_ X /\ cC16_ X))).
Variable axiom_101_102 : (forall X : Universe, (cC24_ X <-> (exists Y0 : Universe, ra_Px5_ X Y0))).
Variable axiom_102_103 : (forall X : Universe, (cC24_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_103_104 : (forall X : Universe, (cC24xcomp_ X <-> ~((exists Y : Universe, ra_Px5_ X Y)))).
Variable axiom_104_105 : (forall X : Universe, (cC26_ X <-> (exists Y0 : Universe, ra_Px92_ X Y0))).
Variable axiom_105_106 : (forall X : Universe, (cC26_ X <-> (cC24xcomp_ X /\ cC2xcomp_ X))).
Variable axiom_106_107 : (forall X : Universe, (cC26xcomp_ X <-> ~((exists Y : Universe, ra_Px92_ X Y)))).
Variable axiom_107_108 : (forall X : Universe, (cC28_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC26_ Y)))).
Variable axiom_108_109 : (forall X : Universe, (cC28_ X <-> (exists Y0 : Universe, ra_Px9_ X Y0))).
Variable axiom_109_110 : (forall X : Universe, (cC28xcomp_ X <-> ~((exists Y : Universe, ra_Px9_ X Y)))).
Variable axiom_110_111 : (forall X : Universe, (cC30_ X <-> (exists Y0 : Universe, ra_Px8_ X Y0))).
Variable axiom_111_112 : (forall X : Universe, (cC30_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC12xcomp_ Y)))).
Variable axiom_112_113 : (forall X : Universe, (cC30xcomp_ X <-> ~((exists Y : Universe, ra_Px8_ X Y)))).
Variable axiom_113_114 : (forall X : Universe, (cC32_ X <-> ~((exists Y : Universe, ra_Px91_ X Y)))).
Variable axiom_114_115 : (forall X : Universe, (cC32_ X <-> (cC2xcomp_ X /\ cC30xcomp_ X))).
Variable axiom_115_116 : (forall X : Universe, (cC32xcomp_ X <-> (exists Y0 : Universe, ra_Px91_ X Y0))).
Variable axiom_116_117 : (forall X : Universe, (cC34_ X <-> ~((exists Y : Universe, ra_Px10_ X Y)))).
Variable axiom_117_118 : (forall X : Universe, (cC34_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC32_ Y)))).
Variable axiom_118_119 : (forall X : Universe, (cC34xcomp_ X <-> (exists Y0 : Universe, ra_Px10_ X Y0))).
Variable axiom_119_120 : (forall X : Universe, (cC36_ X <-> (cC34xcomp_ X /\ cC28xcomp_ X))).
Variable axiom_120_121 : (forall X : Universe, (cC38_ X <-> (cC36_ X /\ cTOP_ X))).
Variable axiom_121_122 : (forall X : Universe, (cC4_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_122_123 : (forall X : Universe, (cC40_ X <-> cTOP_ X)).
Variable axiom_123_124 : (forall X : Universe, (cC42_ X <-> (cC40_ X /\ cC38_ X))).
Variable axiom_124_125 : (forall X : Universe, (cC44_ X <-> ~((exists Y : Universe, ra_Px13_ X Y)))).
Variable axiom_125_126 : (forall X : Universe, (cC44_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_126_127 : (forall X : Universe, (cC44xcomp_ X <-> (exists Y0 : Universe, ra_Px13_ X Y0))).
Variable axiom_127_128 : (forall X : Universe, (cC46_ X <-> (exists Y0 : Universe, ra_Px90_ X Y0))).
Variable axiom_128_129 : (forall X : Universe, (cC46_ X <-> (cC44xcomp_ X /\ cC12xcomp_ X))).
Variable axiom_129_130 : (forall X : Universe, (cC46xcomp_ X <-> ~((exists Y : Universe, ra_Px90_ X Y)))).
Variable axiom_130_131 : (forall X : Universe, (cC48_ X <-> (exists Y0 : Universe, ra_Px17_ X Y0))).
Variable axiom_131_132 : (forall X : Universe, (cC48_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC46_ Y)))).
Variable axiom_132_133 : (forall X : Universe, (cC48xcomp_ X <-> ~((exists Y : Universe, ra_Px17_ X Y)))).
Variable axiom_133_134 : (forall X : Universe, (cC50_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC12xcomp_ Y)))).
Variable axiom_134_135 : (forall X : Universe, (cC50_ X <-> ~((exists Y : Universe, ra_Px16_ X Y)))).
Variable axiom_135_136 : (forall X : Universe, (cC50xcomp_ X <-> (exists Y0 : Universe, ra_Px16_ X Y0))).
Variable axiom_136_137 : (forall X : Universe, (cC52_ X <-> (exists Y0 : Universe, ra_Px89_ X Y0))).
Variable axiom_137_138 : (forall X : Universe, (cC52_ X <-> (cC50xcomp_ X /\ cC12xcomp_ X))).
Variable axiom_138_139 : (forall X : Universe, (cC52xcomp_ X <-> ~((exists Y : Universe, ra_Px89_ X Y)))).
Variable axiom_139_140 : (forall X : Universe, (cC54_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC52_ Y)))).
Variable axiom_140_141 : (forall X : Universe, (cC54_ X <-> (exists Y0 : Universe, ra_Px18_ X Y0))).
Variable axiom_141_142 : (forall X : Universe, (cC54xcomp_ X <-> ~((exists Y : Universe, ra_Px18_ X Y)))).
Variable axiom_142_143 : (forall X : Universe, (cC56_ X <-> (cC48xcomp_ X /\ cC54xcomp_ X))).
Variable axiom_143_144 : (forall X : Universe, (cC58_ X <-> (cC56_ X /\ cTOP_ X))).
Variable axiom_144_145 : (forall X : Universe, (cC6_ X <-> (exists Y0 : Universe, ra_Px27_ X Y0))).
Variable axiom_145_146 : (forall X : Universe, (cC6xcomp_ X <-> ~((exists Y : Universe, ra_Px27_ X Y)))).
Variable axiom_146_147 : (forall X : Universe, (cC60_ X <-> (cC58_ X /\ cC42_ X))).
Variable axiom_147_148 : (forall X : Universe, (cC62_ X <-> cTOP_ X)).
Variable axiom_148_149 : (forall X : Universe, (cC64_ X <-> (cC60_ X /\ cC62_ X))).
Variable axiom_149_150 : (forall X : Universe, (cC66_ X <-> (exists Y0 : Universe, ra_Px21_ X Y0))).
Variable axiom_150_151 : (forall X : Universe, (cC66_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_151_152 : (forall X : Universe, (cC66xcomp_ X <-> ~((exists Y : Universe, ra_Px21_ X Y)))).
Variable axiom_152_153 : (forall X : Universe, (cC68_ X <-> ~((exists Y : Universe, ra_Px88_ X Y)))).
Variable axiom_153_154 : (forall X : Universe, (cC68_ X <-> (cC18xcomp_ X /\ cC66xcomp_ X))).
Variable axiom_154_155 : (forall X : Universe, (cC68xcomp_ X <-> (exists Y0 : Universe, ra_Px88_ X Y0))).
Variable axiom_155_156 : (forall X : Universe, (cC70_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC68_ Y)))).
Variable axiom_156_157 : (forall X : Universe, (cC70_ X <-> ~((exists Y : Universe, ra_Px25_ X Y)))).
Variable axiom_157_158 : (forall X : Universe, (cC70xcomp_ X <-> (exists Y0 : Universe, ra_Px25_ X Y0))).
Variable axiom_158_159 : (forall X : Universe, (cC72_ X <-> (exists Y0 : Universe, ra_Px24_ X Y0))).
Variable axiom_159_160 : (forall X : Universe, (cC72_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC12xcomp_ Y)))).
Variable axiom_160_161 : (forall X : Universe, (cC72xcomp_ X <-> ~((exists Y : Universe, ra_Px24_ X Y)))).
Variable axiom_161_162 : (forall X : Universe, (cC74_ X <-> (cC72xcomp_ X /\ cC18xcomp_ X))).
Variable axiom_162_163 : (forall X : Universe, (cC74_ X <-> (exists Y0 : Universe, ra_Px87_ X Y0))).
Variable axiom_163_164 : (forall X : Universe, (cC74xcomp_ X <-> ~((exists Y : Universe, ra_Px87_ X Y)))).
Variable axiom_164_165 : (forall X : Universe, (cC76_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC74_ Y)))).
Variable axiom_165_166 : (forall X : Universe, (cC76_ X <-> (exists Y0 : Universe, ra_Px26_ X Y0))).
Variable axiom_166_167 : (forall X : Universe, (cC76xcomp_ X <-> ~((exists Y : Universe, ra_Px26_ X Y)))).
Variable axiom_167_168 : (forall X : Universe, (cC78_ X <-> (cC70xcomp_ X /\ cC76xcomp_ X))).
Variable axiom_168_169 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6xcomp_ Y)))).
Variable axiom_169_170 : (forall X : Universe, (cC80_ X <-> (cC78_ X /\ cTOP_ X))).
Variable axiom_170_171 : (forall X : Universe, (cC82_ X <-> (cC64_ X /\ cC80_ X))).
Variable axiom_171_172 : (forall X : Universe, (cC84_ X <-> cTOP_ X)).
Variable axiom_172_173 : (forall X : Universe, (cC86_ X <-> (cC82_ X /\ cC84_ X))).
Variable axiom_173_174 : (forall X : Universe, (cC88_ X <-> cTOP_ X)).
Variable axiom_174_175 : (forall X : Universe, (cC90_ X <-> (cC86_ X /\ cC88_ X))).
Variable axiom_175_176 : (forall X : Universe, (cC92_ X <-> ~((exists Y : Universe, ra_Px28_ X Y)))).
Variable axiom_176_177 : (forall X : Universe, (cC92xcomp_ X <-> (exists Y0 : Universe, ra_Px28_ X Y0))).
Variable axiom_177_178 : (forall X : Universe, (cC94_ X <-> (exists Y0 : Universe, ra_Px29_ X Y0))).
Variable axiom_178_179 : (forall X : Universe, (cC94_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6xcomp_ Y)))).
Variable axiom_179_180 : (forall X : Universe, (cC94xcomp_ X <-> ~((exists Y : Universe, ra_Px29_ X Y)))).
Variable axiom_180_181 : (forall X : Universe, (cC96_ X <-> (cC94xcomp_ X /\ cC92xcomp_ X))).
Variable axiom_181_182 : (forall X : Universe, (cC96_ X <-> (exists Y0 : Universe, ra_Px86_ X Y0))).
Variable axiom_182_183 : (forall X : Universe, (cC96xcomp_ X <-> ~((exists Y : Universe, ra_Px86_ X Y)))).
Variable axiom_183_184 : (forall X : Universe, (cC98_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC96_ Y)))).
Variable axiom_184_185 : (forall X : Universe, (cC98_ X <-> (exists Y0 : Universe, ra_Px35_ X Y0))).
Variable axiom_185_186 : (forall X : Universe, (cC98xcomp_ X <-> ~((exists Y : Universe, ra_Px35_ X Y)))).
Variable axiom_186_187 : (forall X : Universe, (cTEST_ X <-> (cC158_ X /\ cC180_ X))).
Variable axiom_187_188 : cC150xcomp_ iV21026_.
Variable axiom_188_189 : (forall X : Universe, (rR1_ iV21026_ X -> cC170xcomp_ X)).
Variable axiom_189_190 : (forall X : Universe, (rR1_ iV21026_ X -> cC46xcomp_ X)).
Variable axiom_190_191 : cTOP_ iV21026_.
Variable axiom_191_192 : (forall X : Universe, (rR1_ iV21026_ X -> cC160xcomp_ X)).
Variable axiom_192_193 : (forall X : Universe, (rR1_ iV21026_ X -> cC176xcomp_ X)).
Variable axiom_193_194 : (forall X : Universe, (rR1_ iV21026_ X -> cC164xcomp_ X)).
Variable axiom_194_195 : (forall X : Universe, (rR1_ iV21026_ X -> cC148xcomp_ X)).
Variable axiom_195_196 : cC76xcomp_ iV21026_.
Variable axiom_196_197 : cC98xcomp_ iV21026_.
Variable axiom_197_198 : cC128xcomp_ iV21026_.
Variable axiom_198_199 : cC166xcomp_ iV21026_.
Variable axiom_199_200 : cC106xcomp_ iV21026_.
Variable axiom_200_201 : (forall X : Universe, (rR1_ iV21026_ X -> cC120xcomp_ X)).
Variable axiom_201_202 : (forall X : Universe, (rR1_ iV21026_ X -> cC68xcomp_ X)).
Variable axiom_202_203 : (forall X : Universe, (rR1_ iV21026_ X -> cC26xcomp_ X)).
Variable axiom_203_204 : cC34xcomp_ iV21026_.
Variable axiom_204_205 : cC144xcomp_ iV21026_.
Variable axiom_205_206 : cC28xcomp_ iV21026_.
Variable axiom_206_207 : (forall X : Universe, (rR1_ iV21026_ X -> cC104xcomp_ X)).
Variable axiom_207_208 : (forall X : Universe, (rR1_ iV21026_ X -> cC126xcomp_ X)).
Variable axiom_208_209 : (forall X : Universe, (rR1_ iV21026_ X -> cC96xcomp_ X)).
Variable axiom_209_210 : cC54xcomp_ iV21026_.
Variable axiom_210_211 : cC122xcomp_ iV21026_.
Variable axiom_211_212 : (forall X : Universe, (rR1_ iV21026_ X -> cC52xcomp_ X)).
Variable axiom_212_213 : (forall X : Universe, (rR1_ iV21026_ X -> cC142xcomp_ X)).
Variable axiom_213_214 : cC162xcomp_ iV21026_.
Variable axiom_214_215 : (forall X : Universe, (rR1_ iV21026_ X -> cC32xcomp_ X)).
Variable axiom_215_216 : cC70xcomp_ iV21026_.
Variable axiom_216_217 : cC172xcomp_ iV21026_.
Variable axiom_217_218 : cC48xcomp_ iV21026_.
Variable axiom_218_219 : (forall X : Universe, (rR1_ iV21026_ X -> cC74xcomp_ X)).
Variable axiom_219_220 : cowlThing_ iV21026_.
Variable axiom_220_221 : cC178xcomp_ iV21026_.
Variable axiom_221_222 : cTEST_ iV21026_.
Variable axiom_222_223 : rR1_ iV21026_ iV21030_.
Variable axiom_223_224 : rR1_ iV21026_ iV21027_.
Variable axiom_224_225 : rR1_ iV21026_ iV21028_.
Variable axiom_225_226 : rR1_ iV21026_ iV21029_.
Variable axiom_226_227 : cC12_ iV21027_.
Variable axiom_227_228 : (forall X : Universe, (rR1_ iV21027_ X -> cC18_ X)).
Variable axiom_228_229 : cC176xcomp_ iV21027_.
Variable axiom_229_230 : cC96xcomp_ iV21027_.
Variable axiom_230_231 : cC170xcomp_ iV21027_.
Variable axiom_231_232 : cC120xcomp_ iV21027_.
Variable axiom_232_233 : cC92_ iV21027_.
Variable axiom_233_234 : (forall X : Universe, (rR1_ iV21027_ X -> cC6_ X)).
Variable axiom_234_235 : cC148xcomp_ iV21027_.
Variable axiom_235_236 : cC142xcomp_ iV21027_.
Variable axiom_236_237 : cC68xcomp_ iV21027_.
Variable axiom_237_238 : cC2xcomp_ iV21027_.
Variable axiom_238_239 : cC18_ iV21027_.
Variable axiom_239_240 : cC52xcomp_ iV21027_.
Variable axiom_240_241 : (forall X : Universe, (rR1_ iV21027_ X -> cC100_ X)).
Variable axiom_241_242 : cC104xcomp_ iV21027_.
Variable axiom_242_243 : cC26xcomp_ iV21027_.
Variable axiom_243_244 : cC46xcomp_ iV21027_.
Variable axiom_244_245 : cC126xcomp_ iV21027_.
Variable axiom_245_246 : cC164xcomp_ iV21027_.
Variable axiom_246_247 : cC100_ iV21027_.
Variable axiom_247_248 : cC160xcomp_ iV21027_.
Variable axiom_248_249 : cowlThing_ iV21027_.
Variable axiom_249_250 : cC74xcomp_ iV21027_.
Variable axiom_250_251 : cC32xcomp_ iV21027_.
Variable axiom_251_252 : (forall X : Universe, (rR1_ iV21027_ X -> cC92_ X)).
Variable axiom_252_253 : rR1_ iV21027_ iV21036_.
Variable axiom_253_254 : rR1_ iV21027_ iV21035_.
Variable axiom_254_255 : cowlThing_ iV21028_.
Variable axiom_255_256 : (forall X : Universe, (rR1_ iV21029_ X -> cC6_ X)).
Variable axiom_256_257 : cC176xcomp_ iV21029_.
Variable axiom_257_258 : cC96xcomp_ iV21029_.
Variable axiom_258_259 : cC120xcomp_ iV21029_.
Variable axiom_259_260 : cC170xcomp_ iV21029_.
Variable axiom_260_261 : (forall X : Universe, (rR1_ iV21029_ X -> cC18_ X)).
Variable axiom_261_262 : cC92_ iV21029_.
Variable axiom_262_263 : cC148xcomp_ iV21029_.
Variable axiom_263_264 : cC142xcomp_ iV21029_.
Variable axiom_264_265 : cC68xcomp_ iV21029_.
Variable axiom_265_266 : cC12xcomp_ iV21029_.
Variable axiom_266_267 : (forall X : Universe, (rR1_ iV21029_ X -> cC92_ X)).
Variable axiom_267_268 : cC18_ iV21029_.
Variable axiom_268_269 : cC52xcomp_ iV21029_.
Variable axiom_269_270 : cC104xcomp_ iV21029_.
Variable axiom_270_271 : cC2_ iV21029_.
Variable axiom_271_272 : cC26xcomp_ iV21029_.
Variable axiom_272_273 : cC46xcomp_ iV21029_.
Variable axiom_273_274 : (forall X : Universe, (rR1_ iV21029_ X -> cC100_ X)).
Variable axiom_274_275 : cC126xcomp_ iV21029_.
Variable axiom_275_276 : cC164xcomp_ iV21029_.
Variable axiom_276_277 : cC100_ iV21029_.
Variable axiom_277_278 : cC160xcomp_ iV21029_.
Variable axiom_278_279 : cowlThing_ iV21029_.
Variable axiom_279_280 : cC74xcomp_ iV21029_.
Variable axiom_280_281 : cC32xcomp_ iV21029_.
Variable axiom_281_282 : rR1_ iV21029_ iV21034_.
Variable axiom_282_283 : rR1_ iV21029_ iV21033_.
Variable axiom_283_284 : cC12_ iV21030_.
Variable axiom_284_285 : cC176xcomp_ iV21030_.
Variable axiom_285_286 : cC96xcomp_ iV21030_.
Variable axiom_286_287 : cC170xcomp_ iV21030_.
Variable axiom_287_288 : cC120xcomp_ iV21030_.
Variable axiom_288_289 : cC92_ iV21030_.
Variable axiom_289_290 : cC148xcomp_ iV21030_.
Variable axiom_290_291 : cC142xcomp_ iV21030_.
Variable axiom_291_292 : cC68xcomp_ iV21030_.
Variable axiom_292_293 : (forall X : Universe, (rR1_ iV21030_ X -> cC6_ X)).
Variable axiom_293_294 : cC18xcomp_ iV21030_.
Variable axiom_294_295 : cC52xcomp_ iV21030_.
Variable axiom_295_296 : cC104xcomp_ iV21030_.
Variable axiom_296_297 : cC2_ iV21030_.
Variable axiom_297_298 : (forall X : Universe, (rR1_ iV21030_ X -> cC100_ X)).
Variable axiom_298_299 : cC26xcomp_ iV21030_.
Variable axiom_299_300 : (forall X : Universe, (rR1_ iV21030_ X -> cC18_ X)).
Variable axiom_300_301 : cC46xcomp_ iV21030_.
Variable axiom_301_302 : cC126xcomp_ iV21030_.
Variable axiom_302_303 : cC164xcomp_ iV21030_.
Variable axiom_303_304 : (forall X : Universe, (rR1_ iV21030_ X -> cC92_ X)).
Variable axiom_304_305 : cC100_ iV21030_.
Variable axiom_305_306 : cC160xcomp_ iV21030_.
Variable axiom_306_307 : cowlThing_ iV21030_.
Variable axiom_307_308 : cC74xcomp_ iV21030_.
Variable axiom_308_309 : cC32xcomp_ iV21030_.
Variable axiom_309_310 : rR1_ iV21030_ iV21032_.
Variable axiom_310_311 : rR1_ iV21030_ iV21031_.
Variable axiom_311_312 : cowlThing_ iV21031_.
Variable axiom_312_313 : cC2xcomp_ iV21032_.
Variable axiom_313_314 : cC92_ iV21032_.
Variable axiom_314_315 : cC100_ iV21032_.
Variable axiom_315_316 : cC6_ iV21032_.
Variable axiom_316_317 : cowlThing_ iV21032_.
Variable axiom_317_318 : cC18_ iV21032_.
Variable axiom_318_319 : cC92_ iV21033_.
Variable axiom_319_320 : cC12xcomp_ iV21033_.
Variable axiom_320_321 : cC100_ iV21033_.
Variable axiom_321_322 : cC6_ iV21033_.
Variable axiom_322_323 : cowlThing_ iV21033_.
Variable axiom_323_324 : cC18_ iV21033_.
Variable axiom_324_325 : cC92_ iV21034_.
Variable axiom_325_326 : cC2xcomp_ iV21034_.
Variable axiom_326_327 : cC100_ iV21034_.
Variable axiom_327_328 : cC6_ iV21034_.
Variable axiom_328_329 : cowlThing_ iV21034_.
Variable axiom_329_330 : cC18_ iV21034_.
Variable axiom_330_331 : cC92_ iV21035_.
Variable axiom_331_332 : cC12xcomp_ iV21035_.
Variable axiom_332_333 : cC100_ iV21035_.
Variable axiom_333_334 : cC6_ iV21035_.
Variable axiom_334_335 : cowlThing_ iV21035_.
Variable axiom_335_336 : cC18_ iV21035_.
Variable axiom_336_337 : cC92_ iV21036_.
Variable axiom_337_338 : cC2xcomp_ iV21036_.
Variable axiom_338_339 : cC100_ iV21036_.
Variable axiom_339_340 : cC6_ iV21036_.
Variable axiom_340_341 : cowlThing_ iV21036_.
Variable axiom_341_342 : cC18_ iV21036_.

Theorem the_axiom_343 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cC108_ iV21026_ /\ (cC40_ iV21026_ /\ (cC136_ iV21026_ /\ (cC10_ iV21026_ /\ (cC90_ iV21026_ /\ (cowlThing_ iV21026_ /\ (cC58_ iV21026_ /\ (cC56_ iV21026_ /\ (cC158_ iV21026_ /\ (cC110_ iV21026_ /\ (cC22_ iV21026_ /\ (cC60_ iV21026_ /\ (cC154_ iV21026_ /\ (cC180_ iV21026_ /\ (cC78_ iV21026_ /\ (cC16_ iV21026_ /\ (cC132_ iV21026_ /\ (cC114_ iV21026_ /\ (cC20_ iV21026_ /\ (cC84_ iV21026_ /\ (cC38_ iV21026_ /\ (cC138_ iV21026_ /\ (cC174_ iV21026_ /\ (cC62_ iV21026_ /\ (cC8_ iV21026_ /\ (cC36_ iV21026_ /\ (cC112_ iV21026_ /\ (cC64_ iV21026_ /\ (cC116_ iV21026_ /\ (cC82_ iV21026_ /\ (cC14_ iV21026_ /\ (cC152_ iV21026_ /\ (cC80_ iV21026_ /\ (cC88_ iV21026_ /\ (cC130_ iV21026_ /\ (cC168_ iV21026_ /\ (cC4_ iV21026_ /\ (cC134_ iV21026_ /\ (cC42_ iV21026_ /\ (cC156_ iV21026_ /\ (cC86_ iV21026_ /\ (cC30_ iV21027_ /\ (cowlThing_ iV21027_ /\ (cC24_ iV21027_ /\ (cC50_ iV21029_ /\ (cC44_ iV21029_ /\ (cowlThing_ iV21029_ /\ (cC72_ iV21030_ /\ (cC66_ iV21030_ /\ cowlThing_ iV21030_))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
