(*
% File     : KRS158+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_lin ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest665 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   31 (  11 unit)
%            Number of atoms       :   71 (   0 equality)
%            Maximal formula depth :   11 (   3 average)
%            Number of connectives :   47 (   7 ~  ;   0  |;  21  &)
%                                         (  17 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   22 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   3 constant; 0-0 arity)
%            Number of variables   :   31 (   0 singleton;  21 !;  10 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable ra_Px6_ : Universe -> Universe -> Prop.
Variable ra_Px3_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTOP_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC4xcomp_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC2xcomp_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC18_ : Universe -> Prop.
Variable cC16_ : Universe -> Prop.
Variable cC14_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC10xcomp_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV16562_ : Universe.
Variable iV16561_ : Universe.
Variable iV16560_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (exists Y0 : Universe, ra_Px3_ X Y0))).
Variable axiom_3_4 : (forall X : Universe, (cC10_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_4_5 : (forall X : Universe, (cC10xcomp_ X <-> ~((exists Y : Universe, ra_Px3_ X Y)))).
Variable axiom_5_6 : (forall X : Universe, (cC12_ X <-> (cC10xcomp_ X /\ cC2xcomp_ X))).
Variable axiom_6_7 : (forall X : Universe, (cC14_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC12_ Y)))).
Variable axiom_7_8 : (forall X : Universe, (cC16_ X <-> (cC14_ X /\ cC8_ X))).
Variable axiom_8_9 : (forall X : Universe, (cC18_ X <-> (cTOP_ X /\ cC16_ X))).
Variable axiom_9_10 : (forall X : Universe, (cC2_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_10_11 : (forall X : Universe, (cC2xcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_11_12 : (forall X : Universe, (cC4_ X <-> (exists Y0 : Universe, ra_Px6_ X Y0))).
Variable axiom_12_13 : (forall X : Universe, (cC4_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_13_14 : (forall X : Universe, (cC4xcomp_ X <-> ~((exists Y : Universe, ra_Px6_ X Y)))).
Variable axiom_14_15 : (forall X : Universe, (cC6_ X <-> (cC4xcomp_ X /\ cC2xcomp_ X))).
Variable axiom_15_16 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6_ Y)))).
Variable axiom_16_17 : (forall X : Universe, (cTEST_ X <-> (cTOP_ X /\ cC18_ X))).
Variable axiom_17_18 : cowlThing_ iV16560_.
Variable axiom_18_19 : cTEST_ iV16560_.
Variable axiom_19_20 : cTOP_ iV16560_.
Variable axiom_20_21 : rR1_ iV16560_ iV16562_.
Variable axiom_21_22 : rR1_ iV16560_ iV16561_.
Variable axiom_22_23 : cowlThing_ iV16561_.
Variable axiom_23_24 : (forall X : Universe, (rR1_ iV16561_ X -> cC2_ X)).
Variable axiom_24_25 : cC4xcomp_ iV16561_.
Variable axiom_25_26 : cC2xcomp_ iV16561_.
Variable axiom_26_27 : cowlThing_ iV16562_.
Variable axiom_27_28 : (forall X : Universe, (rR1_ iV16562_ X -> cC2_ X)).
Variable axiom_28_29 : cC10xcomp_ iV16562_.
Variable axiom_29_30 : cC2xcomp_ iV16562_.

Theorem the_axiom_31 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cC18_ iV16560_ /\ (cC14_ iV16560_ /\ (cC8_ iV16560_ /\ (cC16_ iV16560_ /\ (cowlThing_ iV16560_ /\ (cC6_ iV16561_ /\ (cowlThing_ iV16561_ /\ (cC12_ iV16562_ /\ cowlThing_ iV16562_)))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
