(*
% File     : KRS156+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_dum ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest663 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :  146 (  13 unit)
%            Number of atoms       :  355 (   0 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :  241 (  32 ~  ;   0  |;  77  &)
%                                         ( 128 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :  133 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   3 constant; 0-0 arity)
%            Number of variables   :  228 (   0 singleton; 134 !;  94 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable ra_Px9_ : Universe -> Universe -> Prop.
Variable ra_Px6_ : Universe -> Universe -> Prop.
Variable ra_Px50_ : Universe -> Universe -> Prop.
Variable ra_Px5_ : Universe -> Universe -> Prop.
Variable ra_Px49_ : Universe -> Universe -> Prop.
Variable ra_Px47_ : Universe -> Universe -> Prop.
Variable ra_Px46_ : Universe -> Universe -> Prop.
Variable ra_Px45_ : Universe -> Universe -> Prop.
Variable ra_Px44_ : Universe -> Universe -> Prop.
Variable ra_Px43_ : Universe -> Universe -> Prop.
Variable ra_Px41_ : Universe -> Universe -> Prop.
Variable ra_Px40_ : Universe -> Universe -> Prop.
Variable ra_Px36_ : Universe -> Universe -> Prop.
Variable ra_Px34_ : Universe -> Universe -> Prop.
Variable ra_Px33_ : Universe -> Universe -> Prop.
Variable ra_Px32_ : Universe -> Universe -> Prop.
Variable ra_Px31_ : Universe -> Universe -> Prop.
Variable ra_Px30_ : Universe -> Universe -> Prop.
Variable ra_Px29_ : Universe -> Universe -> Prop.
Variable ra_Px24_ : Universe -> Universe -> Prop.
Variable ra_Px20_ : Universe -> Universe -> Prop.
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable ra_Px19_ : Universe -> Universe -> Prop.
Variable ra_Px18_ : Universe -> Universe -> Prop.
Variable ra_Px15_ : Universe -> Universe -> Prop.
Variable ra_Px11_ : Universe -> Universe -> Prop.
Variable ra_Px10_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTOP_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC98xcomp_ : Universe -> Prop.
Variable cC98_ : Universe -> Prop.
Variable cC96_ : Universe -> Prop.
Variable cC94_ : Universe -> Prop.
Variable cC92_ : Universe -> Prop.
Variable cC90_ : Universe -> Prop.
Variable cC8xcomp_ : Universe -> Prop.
Variable cC88_ : Universe -> Prop.
Variable cC86_ : Universe -> Prop.
Variable cC84_ : Universe -> Prop.
Variable cC82_ : Universe -> Prop.
Variable cC80xcomp_ : Universe -> Prop.
Variable cC80_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC78_ : Universe -> Prop.
Variable cC76_ : Universe -> Prop.
Variable cC74_ : Universe -> Prop.
Variable cC72_ : Universe -> Prop.
Variable cC70_ : Universe -> Prop.
Variable cC68_ : Universe -> Prop.
Variable cC66_ : Universe -> Prop.
Variable cC64_ : Universe -> Prop.
Variable cC62_ : Universe -> Prop.
Variable cC60xcomp_ : Universe -> Prop.
Variable cC60_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC58xcomp_ : Universe -> Prop.
Variable cC58_ : Universe -> Prop.
Variable cC56_ : Universe -> Prop.
Variable cC54xcomp_ : Universe -> Prop.
Variable cC54_ : Universe -> Prop.
Variable cC52_ : Universe -> Prop.
Variable cC50_ : Universe -> Prop.
Variable cC48_ : Universe -> Prop.
Variable cC46_ : Universe -> Prop.
Variable cC44xcomp_ : Universe -> Prop.
Variable cC44_ : Universe -> Prop.
Variable cC42_ : Universe -> Prop.
Variable cC40_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC38_ : Universe -> Prop.
Variable cC36xcomp_ : Universe -> Prop.
Variable cC36_ : Universe -> Prop.
Variable cC34xcomp_ : Universe -> Prop.
Variable cC34_ : Universe -> Prop.
Variable cC32xcomp_ : Universe -> Prop.
Variable cC32_ : Universe -> Prop.
Variable cC30xcomp_ : Universe -> Prop.
Variable cC30_ : Universe -> Prop.
Variable cC2xcomp_ : Universe -> Prop.
Variable cC28xcomp_ : Universe -> Prop.
Variable cC28_ : Universe -> Prop.
Variable cC26xcomp_ : Universe -> Prop.
Variable cC26_ : Universe -> Prop.
Variable cC24xcomp_ : Universe -> Prop.
Variable cC24_ : Universe -> Prop.
Variable cC22_ : Universe -> Prop.
Variable cC20xcomp_ : Universe -> Prop.
Variable cC20_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC18_ : Universe -> Prop.
Variable cC16_ : Universe -> Prop.
Variable cC140_ : Universe -> Prop.
Variable cC14_ : Universe -> Prop.
Variable cC138_ : Universe -> Prop.
Variable cC136_ : Universe -> Prop.
Variable cC134_ : Universe -> Prop.
Variable cC132xcomp_ : Universe -> Prop.
Variable cC132_ : Universe -> Prop.
Variable cC130xcomp_ : Universe -> Prop.
Variable cC130_ : Universe -> Prop.
Variable cC12xcomp_ : Universe -> Prop.
Variable cC128xcomp_ : Universe -> Prop.
Variable cC128_ : Universe -> Prop.
Variable cC126_ : Universe -> Prop.
Variable cC124_ : Universe -> Prop.
Variable cC122_ : Universe -> Prop.
Variable cC120_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC118xcomp_ : Universe -> Prop.
Variable cC118_ : Universe -> Prop.
Variable cC116_ : Universe -> Prop.
Variable cC114xcomp_ : Universe -> Prop.
Variable cC114_ : Universe -> Prop.
Variable cC112xcomp_ : Universe -> Prop.
Variable cC112_ : Universe -> Prop.
Variable cC110xcomp_ : Universe -> Prop.
Variable cC110_ : Universe -> Prop.
Variable cC10xcomp_ : Universe -> Prop.
Variable cC108xcomp_ : Universe -> Prop.
Variable cC108_ : Universe -> Prop.
Variable cC106xcomp_ : Universe -> Prop.
Variable cC106_ : Universe -> Prop.
Variable cC104_ : Universe -> Prop.
Variable cC102xcomp_ : Universe -> Prop.
Variable cC102_ : Universe -> Prop.
Variable cC100_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV5478_ : Universe.
Variable iV5476_ : Universe.
Variable iV5475_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (exists Y0 : Universe, ra_Px50_ X Y0))).
Variable axiom_3_4 : (forall X : Universe, (cC10_ X <-> (cC2xcomp_ X /\ cC8xcomp_ X))).
Variable axiom_4_5 : (forall X : Universe, (cC10xcomp_ X <-> ~((exists Y : Universe, ra_Px50_ X Y)))).
Variable axiom_5_6 : (forall X : Universe, (cC100_ X <-> (cC98xcomp_ X /\ cC94_ X))).
Variable axiom_6_7 : (forall X : Universe, (cC102_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC100_ Y)))).
Variable axiom_7_8 : (forall X : Universe, (cC102_ X <-> (exists Y0 : Universe, ra_Px30_ X Y0))).
Variable axiom_8_9 : (forall X : Universe, (cC102xcomp_ X <-> ~((exists Y : Universe, ra_Px30_ X Y)))).
Variable axiom_9_10 : (forall X : Universe, (cC104_ X <-> (cC102xcomp_ X /\ cC88_ X))).
Variable axiom_10_11 : (forall X : Universe, (cC106_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC104_ Y)))).
Variable axiom_11_12 : (forall X : Universe, (cC106_ X <-> ~((exists Y : Universe, ra_Px31_ X Y)))).
Variable axiom_12_13 : (forall X : Universe, (cC106xcomp_ X <-> (exists Y0 : Universe, ra_Px31_ X Y0))).
Variable axiom_13_14 : (forall X : Universe, (cC108_ X <-> (exists Y0 : Universe, ra_Px32_ X Y0))).
Variable axiom_14_15 : (forall X : Universe, (cC108_ X <-> (cC84_ X /\ cC106xcomp_ X))).
Variable axiom_15_16 : (forall X : Universe, (cC108xcomp_ X <-> ~((exists Y : Universe, ra_Px32_ X Y)))).
Variable axiom_16_17 : (forall X : Universe, (cC110_ X <-> (cC62_ X /\ cC108xcomp_ X))).
Variable axiom_17_18 : (forall X : Universe, (cC110_ X <-> (exists Y0 : Universe, ra_Px33_ X Y0))).
Variable axiom_18_19 : (forall X : Universe, (cC110xcomp_ X <-> ~((exists Y : Universe, ra_Px33_ X Y)))).
Variable axiom_19_20 : (forall X : Universe, (cC112_ X <-> ~((exists Y : Universe, ra_Px43_ X Y)))).
Variable axiom_20_21 : (forall X : Universe, (cC112_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC110xcomp_ Y)))).
Variable axiom_21_22 : (forall X : Universe, (cC112xcomp_ X <-> (exists Y0 : Universe, ra_Px43_ X Y0))).
Variable axiom_22_23 : (forall X : Universe, (cC114_ X <-> ~((exists Y : Universe, ra_Px34_ X Y)))).
Variable axiom_23_24 : (forall X : Universe, (cC114_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC112_ Y)))).
Variable axiom_24_25 : (forall X : Universe, (cC114xcomp_ X <-> (exists Y0 : Universe, ra_Px34_ X Y0))).
Variable axiom_25_26 : (forall X : Universe, (cC116_ X <-> (cTOP_ X /\ cC114xcomp_ X))).
Variable axiom_26_27 : (forall X : Universe, (cC118_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_27_28 : (forall X : Universe, (cC118_ X <-> (exists Y0 : Universe, ra_Px36_ X Y0))).
Variable axiom_28_29 : (forall X : Universe, (cC118xcomp_ X <-> ~((exists Y : Universe, ra_Px36_ X Y)))).
Variable axiom_29_30 : (forall X : Universe, (cC12_ X <-> (exists Y0 : Universe, ra_Px45_ X Y0))).
Variable axiom_30_31 : (forall X : Universe, (cC12_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC10_ Y)))).
Variable axiom_31_32 : (forall X : Universe, (cC12xcomp_ X <-> ~((exists Y : Universe, ra_Px45_ X Y)))).
Variable axiom_32_33 : (forall X : Universe, (cC120_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC118xcomp_ Y)))).
Variable axiom_33_34 : (forall X : Universe, (cC122_ X <-> (cC2xcomp_ X /\ cC120_ X))).
Variable axiom_34_35 : (forall X : Universe, (cC124_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_35_36 : (forall X : Universe, (cC126_ X <-> (cC2_ X /\ cC124_ X))).
Variable axiom_36_37 : (forall X : Universe, (cC128_ X <-> ~((exists Y : Universe, ra_Px40_ X Y)))).
Variable axiom_37_38 : (forall X : Universe, (cC128_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC126_ Y)))).
Variable axiom_38_39 : (forall X : Universe, (cC128xcomp_ X <-> (exists Y0 : Universe, ra_Px40_ X Y0))).
Variable axiom_39_40 : (forall X : Universe, (cC130_ X <-> (exists Y0 : Universe, ra_Px47_ X Y0))).
Variable axiom_40_41 : (forall X : Universe, (cC130_ X <-> (cC2xcomp_ X /\ cC128xcomp_ X))).
Variable axiom_41_42 : (forall X : Universe, (cC130xcomp_ X <-> ~((exists Y : Universe, ra_Px47_ X Y)))).
Variable axiom_42_43 : (forall X : Universe, (cC132_ X <-> (exists Y0 : Universe, ra_Px41_ X Y0))).
Variable axiom_43_44 : (forall X : Universe, (cC132_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC130_ Y)))).
Variable axiom_44_45 : (forall X : Universe, (cC132xcomp_ X <-> ~((exists Y : Universe, ra_Px41_ X Y)))).
Variable axiom_45_46 : (forall X : Universe, (cC134_ X <-> (cC132xcomp_ X /\ cC122_ X))).
Variable axiom_46_47 : (forall X : Universe, (cC136_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC134_ Y)))).
Variable axiom_47_48 : (forall X : Universe, (cC138_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC136_ Y)))).
Variable axiom_48_49 : (forall X : Universe, (cC14_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC12_ Y)))).
Variable axiom_49_50 : (forall X : Universe, (cC140_ X <-> (cTOP_ X /\ cC138_ X))).
Variable axiom_50_51 : (forall X : Universe, (cC16_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_51_52 : (forall X : Universe, (cC18_ X <-> (cC16_ X /\ cC2_ X))).
Variable axiom_52_53 : (forall X : Universe, (cC2_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_53_54 : (forall X : Universe, (cC2xcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_54_55 : (forall X : Universe, (cC20_ X <-> (exists Y0 : Universe, ra_Px5_ X Y0))).
Variable axiom_55_56 : (forall X : Universe, (cC20_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC18_ Y)))).
Variable axiom_56_57 : (forall X : Universe, (cC20xcomp_ X <-> ~((exists Y : Universe, ra_Px5_ X Y)))).
Variable axiom_57_58 : (forall X : Universe, (cC22_ X <-> (cC2xcomp_ X /\ cC20xcomp_ X))).
Variable axiom_58_59 : (forall X : Universe, (cC24_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC22_ Y)))).
Variable axiom_59_60 : (forall X : Universe, (cC24_ X <-> (exists Y0 : Universe, ra_Px6_ X Y0))).
Variable axiom_60_61 : (forall X : Universe, (cC24xcomp_ X <-> ~((exists Y : Universe, ra_Px6_ X Y)))).
Variable axiom_61_62 : (forall X : Universe, (cC26_ X <-> (cC14_ X /\ cC24xcomp_ X))).
Variable axiom_62_63 : (forall X : Universe, (cC26_ X <-> ~((exists Y : Universe, ra_Px10_ X Y)))).
Variable axiom_63_64 : (forall X : Universe, (cC26xcomp_ X <-> (exists Y0 : Universe, ra_Px10_ X Y0))).
Variable axiom_64_65 : (forall X : Universe, (cC28_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_65_66 : (forall X : Universe, (cC28_ X <-> ~((exists Y : Universe, ra_Px49_ X Y)))).
Variable axiom_66_67 : (forall X : Universe, (cC28xcomp_ X <-> (exists Y0 : Universe, ra_Px49_ X Y0))).
Variable axiom_67_68 : (forall X : Universe, (cC30_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC28_ Y)))).
Variable axiom_68_69 : (forall X : Universe, (cC30_ X <-> (exists Y0 : Universe, ra_Px44_ X Y0))).
Variable axiom_69_70 : (forall X : Universe, (cC30xcomp_ X <-> ~((exists Y : Universe, ra_Px44_ X Y)))).
Variable axiom_70_71 : (forall X : Universe, (cC32_ X <-> (exists Y0 : Universe, ra_Px9_ X Y0))).
Variable axiom_71_72 : (forall X : Universe, (cC32_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_72_73 : (forall X : Universe, (cC32xcomp_ X <-> ~((exists Y : Universe, ra_Px9_ X Y)))).
Variable axiom_73_74 : (forall X : Universe, (cC34_ X <-> ~((exists Y : Universe, ra_Px46_ X Y)))).
Variable axiom_74_75 : (forall X : Universe, (cC34_ X <-> (cC32xcomp_ X /\ cC30_ X))).
Variable axiom_75_76 : (forall X : Universe, (cC34xcomp_ X <-> (exists Y0 : Universe, ra_Px46_ X Y0))).
Variable axiom_76_77 : (forall X : Universe, (cC36_ X <-> (exists Y0 : Universe, ra_Px11_ X Y0))).
Variable axiom_77_78 : (forall X : Universe, (cC36_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC34_ Y)))).
Variable axiom_78_79 : (forall X : Universe, (cC36xcomp_ X <-> ~((exists Y : Universe, ra_Px11_ X Y)))).
Variable axiom_79_80 : (forall X : Universe, (cC38_ X <-> (cC26xcomp_ X /\ cC36xcomp_ X))).
Variable axiom_80_81 : (forall X : Universe, (cC4_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_81_82 : (forall X : Universe, (cC40_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_82_83 : (forall X : Universe, (cC42_ X <-> (cC2xcomp_ X /\ cC40_ X))).
Variable axiom_83_84 : (forall X : Universe, (cC44_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_84_85 : (forall X : Universe, (cC44_ X <-> (exists Y0 : Universe, ra_Px15_ X Y0))).
Variable axiom_85_86 : (forall X : Universe, (cC44xcomp_ X <-> ~((exists Y : Universe, ra_Px15_ X Y)))).
Variable axiom_86_87 : (forall X : Universe, (cC46_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC44xcomp_ Y)))).
Variable axiom_87_88 : (forall X : Universe, (cC48_ X <-> (cC42_ X /\ cC46_ X))).
Variable axiom_88_89 : (forall X : Universe, (cC50_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_89_90 : (forall X : Universe, (cC52_ X <-> (cC2_ X /\ cC50_ X))).
Variable axiom_90_91 : (forall X : Universe, (cC54_ X <-> (exists Y0 : Universe, ra_Px18_ X Y0))).
Variable axiom_91_92 : (forall X : Universe, (cC54_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC52_ Y)))).
Variable axiom_92_93 : (forall X : Universe, (cC54xcomp_ X <-> ~((exists Y : Universe, ra_Px18_ X Y)))).
Variable axiom_93_94 : (forall X : Universe, (cC56_ X <-> (cC2xcomp_ X /\ cC54xcomp_ X))).
Variable axiom_94_95 : (forall X : Universe, (cC58_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC56_ Y)))).
Variable axiom_95_96 : (forall X : Universe, (cC58_ X <-> ~((exists Y : Universe, ra_Px19_ X Y)))).
Variable axiom_96_97 : (forall X : Universe, (cC58xcomp_ X <-> (exists Y0 : Universe, ra_Px19_ X Y0))).
Variable axiom_97_98 : (forall X : Universe, (cC6_ X <-> (cC2_ X /\ cC4_ X))).
Variable axiom_98_99 : (forall X : Universe, (cC60_ X <-> (cC48_ X /\ cC58xcomp_ X))).
Variable axiom_99_100 : (forall X : Universe, (cC60_ X <-> (exists Y0 : Universe, ra_Px20_ X Y0))).
Variable axiom_100_101 : (forall X : Universe, (cC60xcomp_ X <-> ~((exists Y : Universe, ra_Px20_ X Y)))).
Variable axiom_101_102 : (forall X : Universe, (cC62_ X <-> (cC38_ X /\ cC60xcomp_ X))).
Variable axiom_102_103 : (forall X : Universe, (cC64_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_103_104 : (forall X : Universe, (cC66_ X <-> (cC64_ X /\ cC2_ X))).
Variable axiom_104_105 : (forall X : Universe, (cC68_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_105_106 : (forall X : Universe, (cC70_ X <-> (cC2_ X /\ cC68_ X))).
Variable axiom_106_107 : (forall X : Universe, (cC72_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC70_ Y)))).
Variable axiom_107_108 : (forall X : Universe, (cC74_ X <-> (cC66_ X /\ cC72_ X))).
Variable axiom_108_109 : (forall X : Universe, (cC76_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_109_110 : (forall X : Universe, (cC78_ X <-> (cC2_ X /\ cC76_ X))).
Variable axiom_110_111 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6_ Y)))).
Variable axiom_111_112 : (forall X : Universe, (cC8_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_112_113 : (forall X : Universe, (cC8xcomp_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_113_114 : (forall X : Universe, (cC80_ X <-> (exists Y0 : Universe, ra_Px24_ X Y0))).
Variable axiom_114_115 : (forall X : Universe, (cC80_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC78_ Y)))).
Variable axiom_115_116 : (forall X : Universe, (cC80xcomp_ X <-> ~((exists Y : Universe, ra_Px24_ X Y)))).
Variable axiom_116_117 : (forall X : Universe, (cC82_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC80xcomp_ Y)))).
Variable axiom_117_118 : (forall X : Universe, (cC84_ X <-> (cC82_ X /\ cC74_ X))).
Variable axiom_118_119 : (forall X : Universe, (cC86_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_119_120 : (forall X : Universe, (cC88_ X <-> (cC86_ X /\ cC2_ X))).
Variable axiom_120_121 : (forall X : Universe, (cC90_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_121_122 : (forall X : Universe, (cC92_ X <-> (cC2_ X /\ cC90_ X))).
Variable axiom_122_123 : (forall X : Universe, (cC94_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC92_ Y)))).
Variable axiom_123_124 : (forall X : Universe, (cC96_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2xcomp_ Y)))).
Variable axiom_124_125 : (forall X : Universe, (cC98_ X <-> (cC2_ X /\ cC96_ X))).
Variable axiom_125_126 : (forall X : Universe, (cC98_ X <-> (exists Y0 : Universe, ra_Px29_ X Y0))).
Variable axiom_126_127 : (forall X : Universe, (cC98xcomp_ X <-> ~((exists Y : Universe, ra_Px29_ X Y)))).
Variable axiom_127_128 : (forall X : Universe, (cTEST_ X <-> (cC140_ X /\ cC116_ X))).
Variable axiom_128_129 : cTOP_ iV5475_.
Variable axiom_129_130 : cowlThing_ iV5475_.
Variable axiom_130_131 : cC114xcomp_ iV5475_.
Variable axiom_131_132 : cTEST_ iV5475_.
Variable axiom_132_133 : (forall X : Universe, (rR1_ iV5475_ X -> cC112xcomp_ X)).
Variable axiom_133_134 : rR1_ iV5475_ iV5476_.
Variable axiom_134_135 : cowlThing_ iV5476_.
Variable axiom_135_136 : cC12xcomp_ iV5478_.
Variable axiom_136_137 : cC30xcomp_ iV5478_.
Variable axiom_137_138 : cC2_ iV5478_.
Variable axiom_138_139 : cowlThing_ iV5478_.
Variable axiom_139_140 : cC118xcomp_ iV5478_.
Variable axiom_140_141 : (forall X : Universe, (rR1_ iV5478_ X -> cC2_ X)).
Variable axiom_141_142 : cC130xcomp_ iV5478_.
Variable axiom_142_143 : cC34xcomp_ iV5478_.
Variable axiom_143_144 : (forall X : Universe, (rR1_ iV5478_ X -> cC10xcomp_ X)).
Variable axiom_144_145 : (forall X : Universe, (rR1_ iV5478_ X -> cC28xcomp_ X)).

Theorem the_axiom_146 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cC116_ iV5475_ /\ (cC140_ iV5475_ /\ (cowlThing_ iV5475_ /\ cC138_ iV5475_))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
