(*
% File     : KRS153+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_poly ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest208 [Bec03]
% Status   : Theorem
% Rating   : 0.33 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :  201 (  99 unit)
%            Number of atoms       :  408 (   0 equality)
%            Maximal formula depth :   47 (   3 average)
%            Number of connectives :  333 ( 126 ~  ;   0  |; 106  &)
%                                         (  60 <=>;  41 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   72 (   0 propositional; 1-2 arity)
%            Number of functors    :   16 (  16 constant; 0-0 arity)
%            Number of variables   :  131 (   0 singleton; 103 !;  28 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTOP_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC98_ : Universe -> Prop.
Variable cC96_ : Universe -> Prop.
Variable cC94_ : Universe -> Prop.
Variable cC92_ : Universe -> Prop.
Variable cC90_ : Universe -> Prop.
Variable cC88_ : Universe -> Prop.
Variable cC86_ : Universe -> Prop.
Variable cC84_ : Universe -> Prop.
Variable cC82_ : Universe -> Prop.
Variable cC80_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC78_ : Universe -> Prop.
Variable cC76_ : Universe -> Prop.
Variable cC74_ : Universe -> Prop.
Variable cC72_ : Universe -> Prop.
Variable cC70_ : Universe -> Prop.
Variable cC68_ : Universe -> Prop.
Variable cC66_ : Universe -> Prop.
Variable cC64_ : Universe -> Prop.
Variable cC62_ : Universe -> Prop.
Variable cC60_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC58_ : Universe -> Prop.
Variable cC56_ : Universe -> Prop.
Variable cC54_ : Universe -> Prop.
Variable cC52_ : Universe -> Prop.
Variable cC50_ : Universe -> Prop.
Variable cC48_ : Universe -> Prop.
Variable cC46_ : Universe -> Prop.
Variable cC44_ : Universe -> Prop.
Variable cC42_ : Universe -> Prop.
Variable cC40_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC38_ : Universe -> Prop.
Variable cC36_ : Universe -> Prop.
Variable cC34_ : Universe -> Prop.
Variable cC32_ : Universe -> Prop.
Variable cC30_ : Universe -> Prop.
Variable cC28_ : Universe -> Prop.
Variable cC26_ : Universe -> Prop.
Variable cC24_ : Universe -> Prop.
Variable cC22_ : Universe -> Prop.
Variable cC20_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC18_ : Universe -> Prop.
Variable cC16_ : Universe -> Prop.
Variable cC14_ : Universe -> Prop.
Variable cC130_ : Universe -> Prop.
Variable cC128_ : Universe -> Prop.
Variable cC126_ : Universe -> Prop.
Variable cC124_ : Universe -> Prop.
Variable cC122_ : Universe -> Prop.
Variable cC120_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC118_ : Universe -> Prop.
Variable cC116_ : Universe -> Prop.
Variable cC114_ : Universe -> Prop.
Variable cC112_ : Universe -> Prop.
Variable cC110_ : Universe -> Prop.
Variable cC108_ : Universe -> Prop.
Variable cC106_ : Universe -> Prop.
Variable cC104_ : Universe -> Prop.
Variable cC102_ : Universe -> Prop.
Variable cC100_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV16465_ : Universe.
Variable iV16464_ : Universe.
Variable iV16463_ : Universe.
Variable iV16462_ : Universe.
Variable iV16461_ : Universe.
Variable iV16460_ : Universe.
Variable iV16459_ : Universe.
Variable iV16457_ : Universe.
Variable iV16455_ : Universe.
Variable iV16453_ : Universe.
Variable iV16449_ : Universe.
Variable iV16448_ : Universe.
Variable iV16442_ : Universe.
Variable iV16441_ : Universe.
Variable iV16440_ : Universe.
Variable iV16439_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (cC8_ X /\ cC6_ X))).
Variable axiom_3_4 : (forall X : Universe, (cC100_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC98_ Y))))).
Variable axiom_4_5 : (forall X : Universe, (cC104_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC102_ Y))))).
Variable axiom_5_6 : (forall X : Universe, (cC106_ X <-> (~(cC100_ X) /\ cC104_ X))).
Variable axiom_6_7 : (forall X : Universe, (cC108_ X <-> (cC28_ X /\ cC106_ X))).
Variable axiom_7_8 : (forall X : Universe, (cC110_ X <-> (~(cC12_ X) /\ ~(cC4_ X)))).
Variable axiom_8_9 : (forall X : Universe, (cC112_ X <-> (~(cC102_ X) /\ cC110_ X))).
Variable axiom_9_10 : (forall X : Universe, (cC116_ X <-> (cC112_ X /\ ~(cC114_ X)))).
Variable axiom_10_11 : (forall X : Universe, (cC120_ X <-> (cC116_ X /\ ~(cC118_ X)))).
Variable axiom_11_12 : (forall X : Universe, (cC122_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC120_ Y))))).
Variable axiom_12_13 : (forall X : Universe, (cC124_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC122_ Y)))).
Variable axiom_13_14 : (forall X : Universe, (cC126_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC124_ Y)))).
Variable axiom_14_15 : (forall X : Universe, (cC128_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC126_ Y)))).
Variable axiom_15_16 : (forall X : Universe, (cC130_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC128_ Y)))).
Variable axiom_16_17 : (forall X : Universe, (cC14_ X <-> (cC10_ X /\ cC12_ X))).
Variable axiom_17_18 : (forall X : Universe, (cC18_ X <-> (cC14_ X /\ cC16_ X))).
Variable axiom_18_19 : (forall X : Universe, (cC20_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC18_ Y))))).
Variable axiom_19_20 : (forall X : Universe, (cC22_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC20_ Y)))).
Variable axiom_20_21 : (forall X : Universe, (cC24_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC22_ Y)))).
Variable axiom_21_22 : (forall X : Universe, (cC26_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC24_ Y)))).
Variable axiom_22_23 : (forall X : Universe, (cC28_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC26_ Y)))).
Variable axiom_23_24 : (forall X : Universe, (cC30_ X <-> (cC4_ X /\ cC2_ X))).
Variable axiom_24_25 : (forall X : Universe, (cC32_ X <-> (~(cC2_ X) /\ ~(cC4_ X)))).
Variable axiom_25_26 : (forall X : Universe, (cC34_ X <-> (~(cC32_ X) /\ ~(cC30_ X)))).
Variable axiom_26_27 : (forall X : Universe, (cC36_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC34_ Y))))).
Variable axiom_27_28 : (forall X : Universe, (cC38_ X <-> (~(cC36_ X) /\ cTOP_ X))).
Variable axiom_28_29 : (forall X : Universe, (cC40_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC38_ Y))))).
Variable axiom_29_30 : (forall X : Universe, (cC42_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC8_ Y))))).
Variable axiom_30_31 : (forall X : Universe, (cC44_ X <-> (~(cC40_ X) /\ cC42_ X))).
Variable axiom_31_32 : (forall X : Universe, (cC46_ X <-> (cC8_ X /\ cC4_ X))).
Variable axiom_32_33 : (forall X : Universe, (cC48_ X <-> (~(cC8_ X) /\ ~(cC4_ X)))).
Variable axiom_33_34 : (forall X : Universe, (cC50_ X <-> (~(cC46_ X) /\ ~(cC48_ X)))).
Variable axiom_34_35 : (forall X : Universe, (cC52_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC50_ Y))))).
Variable axiom_35_36 : (forall X : Universe, (cC54_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC52_ Y)))).
Variable axiom_36_37 : (forall X : Universe, (cC56_ X <-> (cC44_ X /\ ~(cC54_ X)))).
Variable axiom_37_38 : (forall X : Universe, (cC58_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC56_ Y))))).
Variable axiom_38_39 : (forall X : Universe, (cC6_ X <-> (cC4_ X /\ cC2_ X))).
Variable axiom_39_40 : (forall X : Universe, (cC60_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC12_ Y))))).
Variable axiom_40_41 : (forall X : Universe, (cC62_ X <-> (cC60_ X /\ ~(cC58_ X)))).
Variable axiom_41_42 : (forall X : Universe, (cC64_ X <-> (cC8_ X /\ cC12_ X))).
Variable axiom_42_43 : (forall X : Universe, (cC66_ X <-> (~(cC8_ X) /\ ~(cC12_ X)))).
Variable axiom_43_44 : (forall X : Universe, (cC68_ X <-> (~(cC64_ X) /\ ~(cC66_ X)))).
Variable axiom_44_45 : (forall X : Universe, (cC70_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC68_ Y))))).
Variable axiom_45_46 : (forall X : Universe, (cC72_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC70_ Y)))).
Variable axiom_46_47 : (forall X : Universe, (cC74_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC72_ Y)))).
Variable axiom_47_48 : (forall X : Universe, (cC76_ X <-> (~(cC74_ X) /\ cC62_ X))).
Variable axiom_48_49 : (forall X : Universe, (cC78_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC76_ Y))))).
Variable axiom_49_50 : (forall X : Universe, (cC80_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC16_ Y))))).
Variable axiom_50_51 : (forall X : Universe, (cC82_ X <-> (~(cC78_ X) /\ cC80_ X))).
Variable axiom_51_52 : (forall X : Universe, (cC84_ X <-> (cC2_ X /\ cC12_ X))).
Variable axiom_52_53 : (forall X : Universe, (cC86_ X <-> (~(cC12_ X) /\ ~(cC2_ X)))).
Variable axiom_53_54 : (forall X : Universe, (cC88_ X <-> (~(cC84_ X) /\ ~(cC86_ X)))).
Variable axiom_54_55 : (forall X : Universe, (cC90_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC88_ Y))))).
Variable axiom_55_56 : (forall X : Universe, (cC92_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC90_ Y)))).
Variable axiom_56_57 : (forall X : Universe, (cC94_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC92_ Y)))).
Variable axiom_57_58 : (forall X : Universe, (cC96_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC94_ Y)))).
Variable axiom_58_59 : (forall X : Universe, (cC98_ X <-> (~(cC96_ X) /\ cC82_ X))).
Variable axiom_59_60 : (forall X : Universe, (cTEST_ X <-> (cC108_ X /\ cC130_ X))).
Variable axiom_60_61 : (forall X : Universe, (rR1_ iV16439_ X -> cC98_ X)).
Variable axiom_61_62 : cTEST_ iV16439_.
Variable axiom_62_63 : ~(cC100_ iV16439_).
Variable axiom_63_64 : cowlThing_ iV16439_.
Variable axiom_64_65 : rR1_ iV16439_ iV16440_.
Variable axiom_65_66 : rR1_ iV16439_ iV16442_.
Variable axiom_66_67 : rR1_ iV16439_ iV16441_.
Variable axiom_67_68 : (forall X : Universe, (rR1_ iV16440_ X -> cC76_ X)).
Variable axiom_68_69 : (forall X : Universe, (rR1_ iV16440_ X -> ~(cC94_ X))).
Variable axiom_69_70 : ~(cC102_ iV16440_).
Variable axiom_70_71 : ~(cC78_ iV16440_).
Variable axiom_71_72 : ~(cC96_ iV16440_).
Variable axiom_72_73 : cowlThing_ iV16440_.
Variable axiom_73_74 : rR1_ iV16440_ iV16463_.
Variable axiom_74_75 : cowlThing_ iV16441_.
Variable axiom_75_76 : cowlThing_ iV16442_.
Variable axiom_76_77 : ~(cC36_ iV16448_).
Variable axiom_77_78 : (forall X : Universe, (rR1_ iV16448_ X -> cC68_ X)).
Variable axiom_78_79 : (forall X : Universe, (rR1_ iV16448_ X -> cC34_ X)).
Variable axiom_79_80 : cTOP_ iV16448_.
Variable axiom_80_81 : (forall X : Universe, (rR1_ iV16448_ X -> cC50_ X)).
Variable axiom_81_82 : ~(cC52_ iV16448_).
Variable axiom_82_83 : ~(cC70_ iV16448_).
Variable axiom_83_84 : ~(cC90_ iV16448_).
Variable axiom_84_85 : cowlThing_ iV16448_.
Variable axiom_85_86 : (forall X : Universe, (rR1_ iV16448_ X -> cC88_ X)).
Variable axiom_86_87 : rR1_ iV16448_ iV16449_.
Variable axiom_87_88 : cowlThing_ iV16449_.
Variable axiom_88_89 : (forall X : Universe, (rR1_ iV16453_ X -> ~(cC92_ X))).
Variable axiom_89_90 : (forall X : Universe, (rR1_ iV16453_ X -> ~(cC72_ X))).
Variable axiom_90_91 : ~(cC16_ iV16453_).
Variable axiom_91_92 : ~(cC58_ iV16453_).
Variable axiom_92_93 : ~(cC74_ iV16453_).
Variable axiom_93_94 : (forall X : Universe, (rR1_ iV16453_ X -> cC56_ X)).
Variable axiom_94_95 : cowlThing_ iV16453_.
Variable axiom_95_96 : ~(cC94_ iV16453_).
Variable axiom_96_97 : rR1_ iV16453_ iV16461_.
Variable axiom_97_98 : ~(cC12_ iV16455_).
Variable axiom_98_99 : ~(cC40_ iV16455_).
Variable axiom_99_100 : (forall X : Universe, (rR1_ iV16455_ X -> ~(cC90_ X))).
Variable axiom_100_101 : (forall X : Universe, (rR1_ iV16455_ X -> ~(cC70_ X))).
Variable axiom_101_102 : (forall X : Universe, (rR1_ iV16455_ X -> ~(cC52_ X))).
Variable axiom_102_103 : ~(cC72_ iV16455_).
Variable axiom_103_104 : ~(cC54_ iV16455_).
Variable axiom_104_105 : ~(cC92_ iV16455_).
Variable axiom_105_106 : cowlThing_ iV16455_.
Variable axiom_106_107 : (forall X : Universe, (rR1_ iV16455_ X -> cC38_ X)).
Variable axiom_107_108 : rR1_ iV16455_ iV16460_.
Variable axiom_108_109 : ~(cC36_ iV16457_).
Variable axiom_109_110 : (forall X : Universe, (rR1_ iV16457_ X -> cC88_ X)).
Variable axiom_110_111 : ~(cC52_ iV16457_).
Variable axiom_111_112 : (forall X : Universe, (rR1_ iV16457_ X -> cC68_ X)).
Variable axiom_112_113 : (forall X : Universe, (rR1_ iV16457_ X -> cC34_ X)).
Variable axiom_113_114 : cTOP_ iV16457_.
Variable axiom_114_115 : ~(cC90_ iV16457_).
Variable axiom_115_116 : ~(cC70_ iV16457_).
Variable axiom_116_117 : (forall X : Universe, (rR1_ iV16457_ X -> cC50_ X)).
Variable axiom_117_118 : cowlThing_ iV16457_.
Variable axiom_118_119 : ~(cC8_ iV16457_).
Variable axiom_119_120 : cC4_ iV16459_.
Variable axiom_120_121 : ~(cC48_ iV16459_).
Variable axiom_121_122 : ~(cC30_ iV16459_).
Variable axiom_122_123 : ~(cC6_ iV16459_).
Variable axiom_123_124 : ~(cC86_ iV16459_).
Variable axiom_124_125 : ~(cC46_ iV16459_).
Variable axiom_125_126 : ~(cC14_ iV16459_).
Variable axiom_126_127 : ~(cC18_ iV16459_).
Variable axiom_127_128 : ~(cC66_ iV16459_).
Variable axiom_128_129 : cC12_ iV16459_.
Variable axiom_129_130 : ~(cC8_ iV16459_).
Variable axiom_130_131 : ~(cC2_ iV16459_).
Variable axiom_131_132 : ~(cC10_ iV16459_).
Variable axiom_132_133 : ~(cC84_ iV16459_).
Variable axiom_133_134 : ~(cC64_ iV16459_).
Variable axiom_134_135 : cowlThing_ iV16459_.
Variable axiom_135_136 : ~(cC32_ iV16459_).
Variable axiom_136_137 : ~(cC90_ iV16460_).
Variable axiom_137_138 : ~(cC36_ iV16460_).
Variable axiom_138_139 : (forall X : Universe, (rR1_ iV16460_ X -> cC68_ X)).
Variable axiom_139_140 : ~(cC52_ iV16460_).
Variable axiom_140_141 : cTOP_ iV16460_.
Variable axiom_141_142 : ~(cC8_ iV16460_).
Variable axiom_142_143 : ~(cC70_ iV16460_).
Variable axiom_143_144 : (forall X : Universe, (rR1_ iV16460_ X -> cC88_ X)).
Variable axiom_144_145 : (forall X : Universe, (rR1_ iV16460_ X -> cC50_ X)).
Variable axiom_145_146 : (forall X : Universe, (rR1_ iV16460_ X -> cC34_ X)).
Variable axiom_146_147 : cowlThing_ iV16460_.
Variable axiom_147_148 : ~(cC40_ iV16461_).
Variable axiom_148_149 : (forall X : Universe, (rR1_ iV16461_ X -> ~(cC52_ X))).
Variable axiom_149_150 : ~(cC92_ iV16461_).
Variable axiom_150_151 : (forall X : Universe, (rR1_ iV16461_ X -> ~(cC90_ X))).
Variable axiom_151_152 : ~(cC12_ iV16461_).
Variable axiom_152_153 : ~(cC54_ iV16461_).
Variable axiom_153_154 : (forall X : Universe, (rR1_ iV16461_ X -> ~(cC70_ X))).
Variable axiom_154_155 : (forall X : Universe, (rR1_ iV16461_ X -> cC38_ X)).
Variable axiom_155_156 : cowlThing_ iV16461_.
Variable axiom_156_157 : ~(cC72_ iV16461_).
Variable axiom_157_158 : rR1_ iV16461_ iV16462_.
Variable axiom_158_159 : ~(cC52_ iV16462_).
Variable axiom_159_160 : ~(cC8_ iV16462_).
Variable axiom_160_161 : (forall X : Universe, (rR1_ iV16462_ X -> cC68_ X)).
Variable axiom_161_162 : ~(cC36_ iV16462_).
Variable axiom_162_163 : cTOP_ iV16462_.
Variable axiom_163_164 : ~(cC90_ iV16462_).
Variable axiom_164_165 : (forall X : Universe, (rR1_ iV16462_ X -> cC34_ X)).
Variable axiom_165_166 : (forall X : Universe, (rR1_ iV16462_ X -> cC50_ X)).
Variable axiom_166_167 : (forall X : Universe, (rR1_ iV16462_ X -> cC88_ X)).
Variable axiom_167_168 : ~(cC70_ iV16462_).
Variable axiom_168_169 : cowlThing_ iV16462_.
Variable axiom_169_170 : (forall X : Universe, (rR1_ iV16463_ X -> ~(cC92_ X))).
Variable axiom_170_171 : ~(cC94_ iV16463_).
Variable axiom_171_172 : (forall X : Universe, (rR1_ iV16463_ X -> cC56_ X)).
Variable axiom_172_173 : (forall X : Universe, (rR1_ iV16463_ X -> ~(cC72_ X))).
Variable axiom_173_174 : ~(cC74_ iV16463_).
Variable axiom_174_175 : ~(cC58_ iV16463_).
Variable axiom_175_176 : ~(cC16_ iV16463_).
Variable axiom_176_177 : cowlThing_ iV16463_.
Variable axiom_177_178 : rR1_ iV16463_ iV16464_.
Variable axiom_178_179 : ~(cC72_ iV16464_).
Variable axiom_179_180 : ~(cC40_ iV16464_).
Variable axiom_180_181 : (forall X : Universe, (rR1_ iV16464_ X -> ~(cC70_ X))).
Variable axiom_181_182 : ~(cC54_ iV16464_).
Variable axiom_182_183 : (forall X : Universe, (rR1_ iV16464_ X -> cC38_ X)).
Variable axiom_183_184 : ~(cC12_ iV16464_).
Variable axiom_184_185 : ~(cC92_ iV16464_).
Variable axiom_185_186 : (forall X : Universe, (rR1_ iV16464_ X -> ~(cC90_ X))).
Variable axiom_186_187 : (forall X : Universe, (rR1_ iV16464_ X -> ~(cC52_ X))).
Variable axiom_187_188 : cowlThing_ iV16464_.
Variable axiom_188_189 : rR1_ iV16464_ iV16465_.
Variable axiom_189_190 : (forall X : Universe, (rR1_ iV16465_ X -> cC68_ X)).
Variable axiom_190_191 : ~(cC70_ iV16465_).
Variable axiom_191_192 : ~(cC52_ iV16465_).
Variable axiom_192_193 : (forall X : Universe, (rR1_ iV16465_ X -> cC88_ X)).
Variable axiom_193_194 : (forall X : Universe, (rR1_ iV16465_ X -> cC34_ X)).
Variable axiom_194_195 : ~(cC8_ iV16465_).
Variable axiom_195_196 : ~(cC36_ iV16465_).
Variable axiom_196_197 : cTOP_ iV16465_.
Variable axiom_197_198 : (forall X : Universe, (rR1_ iV16465_ X -> cC50_ X)).
Variable axiom_198_199 : cowlThing_ iV16465_.
Variable axiom_199_200 : ~(cC90_ iV16465_).

Theorem the_axiom_201 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cC106_ iV16439_ /\ (cC28_ iV16439_ /\ (cC130_ iV16439_ /\ (cowlThing_ iV16439_ /\ (cC108_ iV16439_ /\ (cC104_ iV16439_ /\ (cC80_ iV16440_ /\ (cowlThing_ iV16440_ /\ (cC82_ iV16440_ /\ (cC98_ iV16440_ /\ (cowlThing_ iV16448_ /\ (cC38_ iV16448_ /\ (cC62_ iV16453_ /\ (cowlThing_ iV16453_ /\ (cC76_ iV16453_ /\ (cC60_ iV16453_ /\ (cC44_ iV16455_ /\ (cowlThing_ iV16455_ /\ (cC56_ iV16455_ /\ (cC42_ iV16455_ /\ (cowlThing_ iV16457_ /\ (cC38_ iV16457_ /\ (cC68_ iV16459_ /\ (cowlThing_ iV16459_ /\ (cC88_ iV16459_ /\ (cC50_ iV16459_ /\ (cC34_ iV16459_ /\ (cowlThing_ iV16460_ /\ (cC38_ iV16460_ /\ (cC44_ iV16461_ /\ (cowlThing_ iV16461_ /\ (cC56_ iV16461_ /\ (cC42_ iV16461_ /\ (cowlThing_ iV16462_ /\ (cC38_ iV16462_ /\ (cC62_ iV16463_ /\ (cowlThing_ iV16463_ /\ (cC76_ iV16463_ /\ (cC60_ iV16463_ /\ (cC44_ iV16464_ /\ (cowlThing_ iV16464_ /\ (cC56_ iV16464_ /\ (cC42_ iV16464_ /\ (cowlThing_ iV16465_ /\ cC38_ iV16465_)))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
