(*
% File     : KRS152+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_ph ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest207 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :   17 (   8 unit)
%            Number of atoms       :   37 (   0 equality)
%            Maximal formula depth :    6 (   3 average)
%            Number of connectives :   29 (   9 ~  ;   0  |;  12  &)
%                                         (   7 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   12 (   0 singleton;  10 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV21081_ : Universe.
Variable iV21080_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (cC2_ X /\ cC4_ X))).
Variable axiom_3_4 : (forall X : Universe, (cC12_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC10_ Y)))).
Variable axiom_4_5 : (forall X : Universe, (cC6_ X <-> (~(cC2_ X) /\ cC4_ X))).
Variable axiom_5_6 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6_ Y)))).
Variable axiom_6_7 : (forall X : Universe, (cTEST_ X <-> (cC12_ X /\ ~(cC8_ X)))).
Variable axiom_7_8 : cTEST_ iV21080_.
Variable axiom_8_9 : cowlThing_ iV21080_.
Variable axiom_9_10 : (forall X : Universe, (rR1_ iV21080_ X -> ~(cC6_ X))).
Variable axiom_10_11 : ~(cC8_ iV21080_).
Variable axiom_11_12 : rR1_ iV21080_ iV21081_.
Variable axiom_12_13 : ~(cC6_ iV21081_).
Variable axiom_13_14 : cowlThing_ iV21081_.
Variable axiom_14_15 : cC2_ iV21081_.
Variable axiom_15_16 : cC4_ iV21081_.

Theorem the_axiom_17 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cowlThing_ iV21080_ /\ (cC12_ iV21080_ /\ (cC10_ iV21081_ /\ cowlThing_ iV21081_))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
