(*
% File     : KRS151+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_path ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest206 [Bec03]
% Status   : Theorem
% Rating   : 0.33 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :  243 ( 127 unit)
%            Number of atoms       :  490 (   0 equality)
%            Maximal formula depth :   52 (   3 average)
%            Number of connectives :  399 ( 152 ~  ;   0  |; 132  &)
%                                         (  87 <=>;  28 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   97 (   0 propositional; 1-2 arity)
%            Number of functors    :   11 (  11 constant; 0-0 arity)
%            Number of variables   :  153 (   0 singleton; 117 !;  36 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTOP_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC98_ : Universe -> Prop.
Variable cC96_ : Universe -> Prop.
Variable cC94_ : Universe -> Prop.
Variable cC92_ : Universe -> Prop.
Variable cC90_ : Universe -> Prop.
Variable cC88_ : Universe -> Prop.
Variable cC86_ : Universe -> Prop.
Variable cC84_ : Universe -> Prop.
Variable cC82_ : Universe -> Prop.
Variable cC80_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC78_ : Universe -> Prop.
Variable cC76_ : Universe -> Prop.
Variable cC74_ : Universe -> Prop.
Variable cC72_ : Universe -> Prop.
Variable cC70_ : Universe -> Prop.
Variable cC68_ : Universe -> Prop.
Variable cC66_ : Universe -> Prop.
Variable cC64_ : Universe -> Prop.
Variable cC62_ : Universe -> Prop.
Variable cC60_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC58_ : Universe -> Prop.
Variable cC56_ : Universe -> Prop.
Variable cC54_ : Universe -> Prop.
Variable cC52_ : Universe -> Prop.
Variable cC50_ : Universe -> Prop.
Variable cC48_ : Universe -> Prop.
Variable cC46_ : Universe -> Prop.
Variable cC44_ : Universe -> Prop.
Variable cC42_ : Universe -> Prop.
Variable cC40_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC38_ : Universe -> Prop.
Variable cC36_ : Universe -> Prop.
Variable cC34_ : Universe -> Prop.
Variable cC32_ : Universe -> Prop.
Variable cC30_ : Universe -> Prop.
Variable cC28_ : Universe -> Prop.
Variable cC26_ : Universe -> Prop.
Variable cC24_ : Universe -> Prop.
Variable cC22_ : Universe -> Prop.
Variable cC20_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC180_ : Universe -> Prop.
Variable cC18_ : Universe -> Prop.
Variable cC178_ : Universe -> Prop.
Variable cC176_ : Universe -> Prop.
Variable cC174_ : Universe -> Prop.
Variable cC172_ : Universe -> Prop.
Variable cC170_ : Universe -> Prop.
Variable cC168_ : Universe -> Prop.
Variable cC166_ : Universe -> Prop.
Variable cC164_ : Universe -> Prop.
Variable cC162_ : Universe -> Prop.
Variable cC160_ : Universe -> Prop.
Variable cC16_ : Universe -> Prop.
Variable cC158_ : Universe -> Prop.
Variable cC156_ : Universe -> Prop.
Variable cC154_ : Universe -> Prop.
Variable cC152_ : Universe -> Prop.
Variable cC150_ : Universe -> Prop.
Variable cC148_ : Universe -> Prop.
Variable cC146_ : Universe -> Prop.
Variable cC144_ : Universe -> Prop.
Variable cC142_ : Universe -> Prop.
Variable cC140_ : Universe -> Prop.
Variable cC14_ : Universe -> Prop.
Variable cC138_ : Universe -> Prop.
Variable cC136_ : Universe -> Prop.
Variable cC134_ : Universe -> Prop.
Variable cC132_ : Universe -> Prop.
Variable cC130_ : Universe -> Prop.
Variable cC128_ : Universe -> Prop.
Variable cC126_ : Universe -> Prop.
Variable cC124_ : Universe -> Prop.
Variable cC122_ : Universe -> Prop.
Variable cC120_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC118_ : Universe -> Prop.
Variable cC116_ : Universe -> Prop.
Variable cC114_ : Universe -> Prop.
Variable cC112_ : Universe -> Prop.
Variable cC110_ : Universe -> Prop.
Variable cC108_ : Universe -> Prop.
Variable cC106_ : Universe -> Prop.
Variable cC104_ : Universe -> Prop.
Variable cC102_ : Universe -> Prop.
Variable cC100_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV21036_ : Universe.
Variable iV21035_ : Universe.
Variable iV21034_ : Universe.
Variable iV21033_ : Universe.
Variable iV21032_ : Universe.
Variable iV21031_ : Universe.
Variable iV21030_ : Universe.
Variable iV21029_ : Universe.
Variable iV21028_ : Universe.
Variable iV21027_ : Universe.
Variable iV21026_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (cC8_ X /\ cC4_ X))).
Variable axiom_3_4 : (forall X : Universe, (cC102_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC6_ Y))))).
Variable axiom_4_5 : (forall X : Universe, (cC104_ X <-> (~(cC100_ X) /\ ~(cC102_ X)))).
Variable axiom_5_6 : (forall X : Universe, (cC106_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC104_ Y)))).
Variable axiom_6_7 : (forall X : Universe, (cC108_ X <-> (~(cC106_ X) /\ ~(cC98_ X)))).
Variable axiom_7_8 : (forall X : Universe, (cC110_ X <-> (cC108_ X /\ cTOP_ X))).
Variable axiom_8_9 : (forall X : Universe, (cC112_ X <-> (cC90_ X /\ cC110_ X))).
Variable axiom_9_10 : (forall X : Universe, (cC114_ X <-> cTOP_ X)).
Variable axiom_10_11 : (forall X : Universe, (cC116_ X <-> (cC114_ X /\ cC112_ X))).
Variable axiom_11_12 : (forall X : Universe, (cC118_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC92_ Y))))).
Variable axiom_12_13 : (forall X : Universe, (cC120_ X <-> (~(cC118_ X) /\ ~(cC92_ X)))).
Variable axiom_13_14 : (forall X : Universe, (cC122_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC120_ Y)))).
Variable axiom_14_15 : (forall X : Universe, (cC124_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC92_ Y))))).
Variable axiom_15_16 : (forall X : Universe, (cC126_ X <-> (~(cC124_ X) /\ ~(cC100_ X)))).
Variable axiom_16_17 : (forall X : Universe, (cC128_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC126_ Y)))).
Variable axiom_17_18 : (forall X : Universe, (cC130_ X <-> (~(cC122_ X) /\ ~(cC128_ X)))).
Variable axiom_18_19 : (forall X : Universe, (cC132_ X <-> (cTOP_ X /\ cC130_ X))).
Variable axiom_19_20 : (forall X : Universe, (cC134_ X <-> (cC132_ X /\ cC116_ X))).
Variable axiom_20_21 : (forall X : Universe, (cC136_ X <-> cTOP_ X)).
Variable axiom_21_22 : (forall X : Universe, (cC138_ X <-> (cC136_ X /\ cC134_ X))).
Variable axiom_22_23 : (forall X : Universe, (cC14_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC12_ Y))))).
Variable axiom_23_24 : (forall X : Universe, (cC140_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC100_ Y))))).
Variable axiom_24_25 : (forall X : Universe, (cC142_ X <-> (~(cC140_ X) /\ ~(cC92_ X)))).
Variable axiom_25_26 : (forall X : Universe, (cC144_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC142_ Y)))).
Variable axiom_26_27 : (forall X : Universe, (cC146_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC100_ Y))))).
Variable axiom_27_28 : (forall X : Universe, (cC148_ X <-> (~(cC146_ X) /\ ~(cC100_ X)))).
Variable axiom_28_29 : (forall X : Universe, (cC150_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC148_ Y)))).
Variable axiom_29_30 : (forall X : Universe, (cC152_ X <-> (~(cC150_ X) /\ ~(cC144_ X)))).
Variable axiom_30_31 : (forall X : Universe, (cC154_ X <-> (cTOP_ X /\ cC152_ X))).
Variable axiom_31_32 : (forall X : Universe, (cC156_ X <-> (cC154_ X /\ cC138_ X))).
Variable axiom_32_33 : (forall X : Universe, (cC158_ X <-> (cC22_ X /\ cC156_ X))).
Variable axiom_33_34 : (forall X : Universe, (cC16_ X <-> (cC14_ X /\ cC10_ X))).
Variable axiom_34_35 : (forall X : Universe, (cC160_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC6_ Y))))).
Variable axiom_35_36 : (forall X : Universe, (cC162_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC160_ Y)))).
Variable axiom_36_37 : (forall X : Universe, (cC164_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC92_ Y))))).
Variable axiom_37_38 : (forall X : Universe, (cC166_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC164_ Y)))).
Variable axiom_38_39 : (forall X : Universe, (cC168_ X <-> (~(cC166_ X) /\ ~(cC162_ X)))).
Variable axiom_39_40 : (forall X : Universe, (cC170_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC18_ Y))))).
Variable axiom_40_41 : (forall X : Universe, (cC172_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC170_ Y)))).
Variable axiom_41_42 : (forall X : Universe, (cC174_ X <-> (cC168_ X /\ ~(cC172_ X)))).
Variable axiom_42_43 : (forall X : Universe, (cC176_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC100_ Y))))).
Variable axiom_43_44 : (forall X : Universe, (cC178_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC176_ Y)))).
Variable axiom_44_45 : (forall X : Universe, (cC180_ X <-> (~(cC178_ X) /\ cC174_ X))).
Variable axiom_45_46 : (forall X : Universe, (cC20_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC18_ Y))))).
Variable axiom_46_47 : (forall X : Universe, (cC22_ X <-> (cC16_ X /\ cC20_ X))).
Variable axiom_47_48 : (forall X : Universe, (cC24_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_48_49 : (forall X : Universe, (cC26_ X <-> (~(cC24_ X) /\ ~(cC2_ X)))).
Variable axiom_49_50 : (forall X : Universe, (cC28_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC26_ Y)))).
Variable axiom_50_51 : (forall X : Universe, (cC30_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC12_ Y))))).
Variable axiom_51_52 : (forall X : Universe, (cC32_ X <-> (~(cC2_ X) /\ ~(cC30_ X)))).
Variable axiom_52_53 : (forall X : Universe, (cC34_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC32_ Y)))).
Variable axiom_53_54 : (forall X : Universe, (cC36_ X <-> (~(cC28_ X) /\ ~(cC34_ X)))).
Variable axiom_54_55 : (forall X : Universe, (cC38_ X <-> (cC36_ X /\ cTOP_ X))).
Variable axiom_55_56 : (forall X : Universe, (cC4_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_56_57 : (forall X : Universe, (cC40_ X <-> cTOP_ X)).
Variable axiom_57_58 : (forall X : Universe, (cC42_ X <-> (cC40_ X /\ cC38_ X))).
Variable axiom_58_59 : (forall X : Universe, (cC44_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_59_60 : (forall X : Universe, (cC46_ X <-> (~(cC12_ X) /\ ~(cC44_ X)))).
Variable axiom_60_61 : (forall X : Universe, (cC48_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC46_ Y)))).
Variable axiom_61_62 : (forall X : Universe, (cC50_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC12_ Y))))).
Variable axiom_62_63 : (forall X : Universe, (cC52_ X <-> (~(cC12_ X) /\ ~(cC50_ X)))).
Variable axiom_63_64 : (forall X : Universe, (cC54_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC52_ Y)))).
Variable axiom_64_65 : (forall X : Universe, (cC56_ X <-> (~(cC48_ X) /\ ~(cC54_ X)))).
Variable axiom_65_66 : (forall X : Universe, (cC58_ X <-> (cC56_ X /\ cTOP_ X))).
Variable axiom_66_67 : (forall X : Universe, (cC60_ X <-> (cC58_ X /\ cC42_ X))).
Variable axiom_67_68 : (forall X : Universe, (cC62_ X <-> cTOP_ X)).
Variable axiom_68_69 : (forall X : Universe, (cC64_ X <-> (cC62_ X /\ cC60_ X))).
Variable axiom_69_70 : (forall X : Universe, (cC66_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_70_71 : (forall X : Universe, (cC68_ X <-> (~(cC66_ X) /\ ~(cC18_ X)))).
Variable axiom_71_72 : (forall X : Universe, (cC70_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC68_ Y)))).
Variable axiom_72_73 : (forall X : Universe, (cC72_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC12_ Y))))).
Variable axiom_73_74 : (forall X : Universe, (cC74_ X <-> (~(cC18_ X) /\ ~(cC72_ X)))).
Variable axiom_74_75 : (forall X : Universe, (cC76_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC74_ Y)))).
Variable axiom_75_76 : (forall X : Universe, (cC78_ X <-> (~(cC70_ X) /\ ~(cC76_ X)))).
Variable axiom_76_77 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC6_ Y))))).
Variable axiom_77_78 : (forall X : Universe, (cC80_ X <-> (cTOP_ X /\ cC78_ X))).
Variable axiom_78_79 : (forall X : Universe, (cC82_ X <-> (cC80_ X /\ cC64_ X))).
Variable axiom_79_80 : (forall X : Universe, (cC84_ X <-> cTOP_ X)).
Variable axiom_80_81 : (forall X : Universe, (cC86_ X <-> (cC82_ X /\ cC84_ X))).
Variable axiom_81_82 : (forall X : Universe, (cC88_ X <-> cTOP_ X)).
Variable axiom_82_83 : (forall X : Universe, (cC90_ X <-> (cC88_ X /\ cC86_ X))).
Variable axiom_83_84 : (forall X : Universe, (cC94_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC6_ Y))))).
Variable axiom_84_85 : (forall X : Universe, (cC96_ X <-> (~(cC92_ X) /\ ~(cC94_ X)))).
Variable axiom_85_86 : (forall X : Universe, (cC98_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC96_ Y)))).
Variable axiom_86_87 : (forall X : Universe, (cTEST_ X <-> (cC158_ X /\ cC180_ X))).
Variable axiom_87_88 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC26_ X))).
Variable axiom_88_89 : cTOP_ iV21026_.
Variable axiom_89_90 : cTEST_ iV21026_.
Variable axiom_90_91 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC104_ X))).
Variable axiom_91_92 : ~(cC98_ iV21026_).
Variable axiom_92_93 : ~(cC122_ iV21026_).
Variable axiom_93_94 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC148_ X))).
Variable axiom_94_95 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC160_ X))).
Variable axiom_95_96 : ~(cC34_ iV21026_).
Variable axiom_96_97 : ~(cC28_ iV21026_).
Variable axiom_97_98 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC126_ X))).
Variable axiom_98_99 : ~(cC70_ iV21026_).
Variable axiom_99_100 : ~(cC178_ iV21026_).
Variable axiom_100_101 : ~(cC162_ iV21026_).
Variable axiom_101_102 : ~(cC166_ iV21026_).
Variable axiom_102_103 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC68_ X))).
Variable axiom_103_104 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC164_ X))).
Variable axiom_104_105 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC46_ X))).
Variable axiom_105_106 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC52_ X))).
Variable axiom_106_107 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC176_ X))).
Variable axiom_107_108 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC142_ X))).
Variable axiom_108_109 : ~(cC150_ iV21026_).
Variable axiom_109_110 : ~(cC54_ iV21026_).
Variable axiom_110_111 : ~(cC106_ iV21026_).
Variable axiom_111_112 : ~(cC144_ iV21026_).
Variable axiom_112_113 : ~(cC48_ iV21026_).
Variable axiom_113_114 : ~(cC76_ iV21026_).
Variable axiom_114_115 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC32_ X))).
Variable axiom_115_116 : ~(cC128_ iV21026_).
Variable axiom_116_117 : ~(cC172_ iV21026_).
Variable axiom_117_118 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC120_ X))).
Variable axiom_118_119 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC96_ X))).
Variable axiom_119_120 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC170_ X))).
Variable axiom_120_121 : cowlThing_ iV21026_.
Variable axiom_121_122 : (forall X : Universe, (rR1_ iV21026_ X -> ~(cC74_ X))).
Variable axiom_122_123 : rR1_ iV21026_ iV21030_.
Variable axiom_123_124 : rR1_ iV21026_ iV21027_.
Variable axiom_124_125 : rR1_ iV21026_ iV21028_.
Variable axiom_125_126 : rR1_ iV21026_ iV21029_.
Variable axiom_126_127 : ~(cC26_ iV21027_).
Variable axiom_127_128 : ~(cC176_ iV21027_).
Variable axiom_128_129 : (forall X : Universe, (rR1_ iV21027_ X -> cC18_ X)).
Variable axiom_129_130 : ~(cC46_ iV21027_).
Variable axiom_130_131 : ~(cC170_ iV21027_).
Variable axiom_131_132 : cC12_ iV21027_.
Variable axiom_132_133 : ~(cC120_ iV21027_).
Variable axiom_133_134 : ~(cC74_ iV21027_).
Variable axiom_134_135 : (forall X : Universe, (rR1_ iV21027_ X -> cC6_ X)).
Variable axiom_135_136 : ~(cC52_ iV21027_).
Variable axiom_136_137 : ~(cC32_ iV21027_).
Variable axiom_137_138 : ~(cC96_ iV21027_).
Variable axiom_138_139 : ~(cC68_ iV21027_).
Variable axiom_139_140 : cC92_ iV21027_.
Variable axiom_140_141 : ~(cC126_ iV21027_).
Variable axiom_141_142 : cC100_ iV21027_.
Variable axiom_142_143 : ~(cC160_ iV21027_).
Variable axiom_143_144 : ~(cC104_ iV21027_).
Variable axiom_144_145 : ~(cC148_ iV21027_).
Variable axiom_145_146 : ~(cC142_ iV21027_).
Variable axiom_146_147 : cC18_ iV21027_.
Variable axiom_147_148 : (forall X : Universe, (rR1_ iV21027_ X -> cC92_ X)).
Variable axiom_148_149 : (forall X : Universe, (rR1_ iV21027_ X -> cC100_ X)).
Variable axiom_149_150 : ~(cC164_ iV21027_).
Variable axiom_150_151 : ~(cC2_ iV21027_).
Variable axiom_151_152 : cowlThing_ iV21027_.
Variable axiom_152_153 : rR1_ iV21027_ iV21036_.
Variable axiom_153_154 : rR1_ iV21027_ iV21035_.
Variable axiom_154_155 : cowlThing_ iV21028_.
Variable axiom_155_156 : ~(cC148_ iV21029_).
Variable axiom_156_157 : ~(cC68_ iV21029_).
Variable axiom_157_158 : ~(cC46_ iV21029_).
Variable axiom_158_159 : ~(cC104_ iV21029_).
Variable axiom_159_160 : (forall X : Universe, (rR1_ iV21029_ X -> cC100_ X)).
Variable axiom_160_161 : ~(cC176_ iV21029_).
Variable axiom_161_162 : ~(cC142_ iV21029_).
Variable axiom_162_163 : (forall X : Universe, (rR1_ iV21029_ X -> cC92_ X)).
Variable axiom_163_164 : ~(cC12_ iV21029_).
Variable axiom_164_165 : cC2_ iV21029_.
Variable axiom_165_166 : ~(cC74_ iV21029_).
Variable axiom_166_167 : ~(cC120_ iV21029_).
Variable axiom_167_168 : cC92_ iV21029_.
Variable axiom_168_169 : ~(cC52_ iV21029_).
Variable axiom_169_170 : ~(cC32_ iV21029_).
Variable axiom_170_171 : cC100_ iV21029_.
Variable axiom_171_172 : cC18_ iV21029_.
Variable axiom_172_173 : ~(cC170_ iV21029_).
Variable axiom_173_174 : ~(cC26_ iV21029_).
Variable axiom_174_175 : ~(cC96_ iV21029_).
Variable axiom_175_176 : ~(cC126_ iV21029_).
Variable axiom_176_177 : (forall X : Universe, (rR1_ iV21029_ X -> cC6_ X)).
Variable axiom_177_178 : ~(cC164_ iV21029_).
Variable axiom_178_179 : ~(cC160_ iV21029_).
Variable axiom_179_180 : (forall X : Universe, (rR1_ iV21029_ X -> cC18_ X)).
Variable axiom_180_181 : cowlThing_ iV21029_.
Variable axiom_181_182 : rR1_ iV21029_ iV21034_.
Variable axiom_182_183 : rR1_ iV21029_ iV21033_.
Variable axiom_183_184 : ~(cC32_ iV21030_).
Variable axiom_184_185 : ~(cC26_ iV21030_).
Variable axiom_185_186 : ~(cC126_ iV21030_).
Variable axiom_186_187 : (forall X : Universe, (rR1_ iV21030_ X -> cC18_ X)).
Variable axiom_187_188 : ~(cC148_ iV21030_).
Variable axiom_188_189 : ~(cC46_ iV21030_).
Variable axiom_189_190 : (forall X : Universe, (rR1_ iV21030_ X -> cC6_ X)).
Variable axiom_190_191 : cC12_ iV21030_.
Variable axiom_191_192 : ~(cC68_ iV21030_).
Variable axiom_192_193 : ~(cC74_ iV21030_).
Variable axiom_193_194 : ~(cC96_ iV21030_).
Variable axiom_194_195 : ~(cC176_ iV21030_).
Variable axiom_195_196 : cC2_ iV21030_.
Variable axiom_196_197 : ~(cC104_ iV21030_).
Variable axiom_197_198 : cC92_ iV21030_.
Variable axiom_198_199 : cC100_ iV21030_.
Variable axiom_199_200 : ~(cC120_ iV21030_).
Variable axiom_200_201 : (forall X : Universe, (rR1_ iV21030_ X -> cC100_ X)).
Variable axiom_201_202 : ~(cC170_ iV21030_).
Variable axiom_202_203 : ~(cC18_ iV21030_).
Variable axiom_203_204 : (forall X : Universe, (rR1_ iV21030_ X -> cC92_ X)).
Variable axiom_204_205 : ~(cC52_ iV21030_).
Variable axiom_205_206 : ~(cC160_ iV21030_).
Variable axiom_206_207 : ~(cC164_ iV21030_).
Variable axiom_207_208 : cowlThing_ iV21030_.
Variable axiom_208_209 : ~(cC142_ iV21030_).
Variable axiom_209_210 : rR1_ iV21030_ iV21032_.
Variable axiom_210_211 : rR1_ iV21030_ iV21031_.
Variable axiom_211_212 : cowlThing_ iV21031_.
Variable axiom_212_213 : cC92_ iV21032_.
Variable axiom_213_214 : cC100_ iV21032_.
Variable axiom_214_215 : ~(cC2_ iV21032_).
Variable axiom_215_216 : cC18_ iV21032_.
Variable axiom_216_217 : cC6_ iV21032_.
Variable axiom_217_218 : cowlThing_ iV21032_.
Variable axiom_218_219 : cC92_ iV21033_.
Variable axiom_219_220 : cC100_ iV21033_.
Variable axiom_220_221 : cC18_ iV21033_.
Variable axiom_221_222 : cC6_ iV21033_.
Variable axiom_222_223 : ~(cC12_ iV21033_).
Variable axiom_223_224 : cowlThing_ iV21033_.
Variable axiom_224_225 : cC92_ iV21034_.
Variable axiom_225_226 : cC100_ iV21034_.
Variable axiom_226_227 : cC18_ iV21034_.
Variable axiom_227_228 : cC6_ iV21034_.
Variable axiom_228_229 : ~(cC2_ iV21034_).
Variable axiom_229_230 : cowlThing_ iV21034_.
Variable axiom_230_231 : cC92_ iV21035_.
Variable axiom_231_232 : cC100_ iV21035_.
Variable axiom_232_233 : ~(cC12_ iV21035_).
Variable axiom_233_234 : cC18_ iV21035_.
Variable axiom_234_235 : cC6_ iV21035_.
Variable axiom_235_236 : cowlThing_ iV21035_.
Variable axiom_236_237 : cC92_ iV21036_.
Variable axiom_237_238 : cC100_ iV21036_.
Variable axiom_238_239 : cC18_ iV21036_.
Variable axiom_239_240 : cC6_ iV21036_.
Variable axiom_240_241 : ~(cC2_ iV21036_).
Variable axiom_241_242 : cowlThing_ iV21036_.

Theorem the_axiom_243 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cowlThing_ iV21026_ /\ (cC84_ iV21026_ /\ (cC16_ iV21026_ /\ (cC36_ iV21026_ /\ (cC42_ iV21026_ /\ (cC88_ iV21026_ /\ (cC86_ iV21026_ /\ (cC174_ iV21026_ /\ (cC20_ iV21026_ /\ (cC156_ iV21026_ /\ (cC60_ iV21026_ /\ (cC38_ iV21026_ /\ (cC158_ iV21026_ /\ (cC10_ iV21026_ /\ (cC134_ iV21026_ /\ (cC22_ iV21026_ /\ (cC168_ iV21026_ /\ (cC56_ iV21026_ /\ (cC78_ iV21026_ /\ (cC58_ iV21026_ /\ (cC152_ iV21026_ /\ (cC40_ iV21026_ /\ (cC132_ iV21026_ /\ (cC130_ iV21026_ /\ (cC62_ iV21026_ /\ (cC154_ iV21026_ /\ (cC80_ iV21026_ /\ (cC8_ iV21026_ /\ (cC136_ iV21026_ /\ (cC112_ iV21026_ /\ (cC180_ iV21026_ /\ (cC114_ iV21026_ /\ (cC64_ iV21026_ /\ (cC110_ iV21026_ /\ (cC116_ iV21026_ /\ (cC82_ iV21026_ /\ (cC138_ iV21026_ /\ (cC4_ iV21026_ /\ (cC108_ iV21026_ /\ (cC14_ iV21026_ /\ (cC90_ iV21026_ /\ (cowlThing_ iV21027_ /\ (cC30_ iV21027_ /\ (cC24_ iV21027_ /\ (cowlThing_ iV21029_ /\ (cC50_ iV21029_ /\ (cC44_ iV21029_ /\ (cowlThing_ iV21030_ /\ (cC66_ iV21030_ /\ cC72_ iV21030_))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
