(*
% File     : KRS150+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_lin ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest205 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   25 (  11 unit)
%            Number of atoms       :   59 (   0 equality)
%            Maximal formula depth :   11 (   3 average)
%            Number of connectives :   48 (  14 ~  ;   0  |;  21  &)
%                                         (  11 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   16 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   3 constant; 0-0 arity)
%            Number of variables   :   19 (   0 singleton;  15 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTOP_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC18_ : Universe -> Prop.
Variable cC16_ : Universe -> Prop.
Variable cC14_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV16562_ : Universe.
Variable iV16561_ : Universe.
Variable iV16560_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_3_4 : (forall X : Universe, (cC12_ X <-> (~(cC2_ X) /\ ~(cC10_ X)))).
Variable axiom_4_5 : (forall X : Universe, (cC14_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC12_ Y)))).
Variable axiom_5_6 : (forall X : Universe, (cC16_ X <-> (cC14_ X /\ cC8_ X))).
Variable axiom_6_7 : (forall X : Universe, (cC18_ X <-> (cTOP_ X /\ cC16_ X))).
Variable axiom_7_8 : (forall X : Universe, (cC4_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_8_9 : (forall X : Universe, (cC6_ X <-> (~(cC2_ X) /\ ~(cC4_ X)))).
Variable axiom_9_10 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6_ Y)))).
Variable axiom_10_11 : (forall X : Universe, (cTEST_ X <-> (cC18_ X /\ cTOP_ X))).
Variable axiom_11_12 : cTOP_ iV16560_.
Variable axiom_12_13 : cTEST_ iV16560_.
Variable axiom_13_14 : cowlThing_ iV16560_.
Variable axiom_14_15 : rR1_ iV16560_ iV16562_.
Variable axiom_15_16 : rR1_ iV16560_ iV16561_.
Variable axiom_16_17 : ~(cC4_ iV16561_).
Variable axiom_17_18 : cowlThing_ iV16561_.
Variable axiom_18_19 : (forall X : Universe, (rR1_ iV16561_ X -> cC2_ X)).
Variable axiom_19_20 : ~(cC2_ iV16561_).
Variable axiom_20_21 : ~(cC10_ iV16562_).
Variable axiom_21_22 : ~(cC2_ iV16562_).
Variable axiom_22_23 : cowlThing_ iV16562_.
Variable axiom_23_24 : (forall X : Universe, (rR1_ iV16562_ X -> cC2_ X)).

Theorem the_axiom_25 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cC18_ iV16560_ /\ (cC16_ iV16560_ /\ (cowlThing_ iV16560_ /\ (cC14_ iV16560_ /\ (cC8_ iV16560_ /\ (cowlThing_ iV16561_ /\ (cC6_ iV16561_ /\ (cowlThing_ iV16562_ /\ cC12_ iV16562_)))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
