(*
% File     : KRS147+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_d4 ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest202 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   87 (  34 unit)
%            Number of atoms       :  204 (   0 equality)
%            Maximal formula depth :   17 (   4 average)
%            Number of connectives :  164 (  47 ~  ;   0  |;  65  &)
%                                         (  49 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   54 (   0 propositional; 1-2 arity)
%            Number of functors    :   10 (  10 constant; 0-0 arity)
%            Number of variables   :   85 (   0 singleton;  54 !;  31 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTOP_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC94_ : Universe -> Prop.
Variable cC92_ : Universe -> Prop.
Variable cC90_ : Universe -> Prop.
Variable cC88_ : Universe -> Prop.
Variable cC86_ : Universe -> Prop.
Variable cC84_ : Universe -> Prop.
Variable cC82_ : Universe -> Prop.
Variable cC80_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC78_ : Universe -> Prop.
Variable cC76_ : Universe -> Prop.
Variable cC74_ : Universe -> Prop.
Variable cC72_ : Universe -> Prop.
Variable cC70_ : Universe -> Prop.
Variable cC68_ : Universe -> Prop.
Variable cC66_ : Universe -> Prop.
Variable cC64_ : Universe -> Prop.
Variable cC62_ : Universe -> Prop.
Variable cC60_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC58_ : Universe -> Prop.
Variable cC56_ : Universe -> Prop.
Variable cC54_ : Universe -> Prop.
Variable cC52_ : Universe -> Prop.
Variable cC50_ : Universe -> Prop.
Variable cC48_ : Universe -> Prop.
Variable cC46_ : Universe -> Prop.
Variable cC44_ : Universe -> Prop.
Variable cC42_ : Universe -> Prop.
Variable cC40_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC38_ : Universe -> Prop.
Variable cC36_ : Universe -> Prop.
Variable cC34_ : Universe -> Prop.
Variable cC32_ : Universe -> Prop.
Variable cC30_ : Universe -> Prop.
Variable cC28_ : Universe -> Prop.
Variable cC26_ : Universe -> Prop.
Variable cC24_ : Universe -> Prop.
Variable cC22_ : Universe -> Prop.
Variable cC20_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC18_ : Universe -> Prop.
Variable cC16_ : Universe -> Prop.
Variable cC14_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV8476_ : Universe.
Variable iV8475_ : Universe.
Variable iV8474_ : Universe.
Variable iV8473_ : Universe.
Variable iV8472_ : Universe.
Variable iV8471_ : Universe.
Variable iV8470_ : Universe.
Variable iV8469_ : Universe.
Variable iV8468_ : Universe.
Variable iV8467_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (cC4_ X /\ cC8_ X))).
Variable axiom_3_4 : (forall X : Universe, (cC12_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC10_ Y)))).
Variable axiom_4_5 : (forall X : Universe, (cC14_ X <-> (exists Y : Universe, (rR1_ X Y /\ cTOP_ Y)))).
Variable axiom_5_6 : (forall X : Universe, (cC16_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC14_ Y))))).
Variable axiom_6_7 : (forall X : Universe, (cC18_ X <-> (~(cC16_ X) /\ cC12_ X))).
Variable axiom_7_8 : (forall X : Universe, (cC20_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_8_9 : (forall X : Universe, (cC22_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_9_10 : (forall X : Universe, (cC24_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC22_ Y)))).
Variable axiom_10_11 : (forall X : Universe, (cC26_ X <-> (~(cC20_ X) /\ cC24_ X))).
Variable axiom_11_12 : (forall X : Universe, (cC28_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC26_ Y)))).
Variable axiom_12_13 : (forall X : Universe, (cC30_ X <-> (cC18_ X /\ ~(cC28_ X)))).
Variable axiom_13_14 : (forall X : Universe, (cC32_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2_ Y)))).
Variable axiom_14_15 : (forall X : Universe, (cC34_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC32_ Y))))).
Variable axiom_15_16 : (forall X : Universe, (cC36_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2_ Y)))).
Variable axiom_16_17 : (forall X : Universe, (cC38_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC36_ Y))))).
Variable axiom_17_18 : (forall X : Universe, (cC4_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_18_19 : (forall X : Universe, (cC40_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC38_ Y)))).
Variable axiom_19_20 : (forall X : Universe, (cC42_ X <-> (~(cC34_ X) /\ cC40_ X))).
Variable axiom_20_21 : (forall X : Universe, (cC44_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC42_ Y)))).
Variable axiom_21_22 : (forall X : Universe, (cC46_ X <-> (~(cC44_ X) /\ cC30_ X))).
Variable axiom_22_23 : (forall X : Universe, (cC48_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_23_24 : (forall X : Universe, (cC50_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2_ Y)))).
Variable axiom_24_25 : (forall X : Universe, (cC52_ X <-> (~(cC50_ X) /\ ~(cC48_ X)))).
Variable axiom_25_26 : (forall X : Universe, (cC54_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC52_ Y)))).
Variable axiom_26_27 : (forall X : Universe, (cC56_ X <-> (~(cC54_ X) /\ cC46_ X))).
Variable axiom_27_28 : (forall X : Universe, (cC58_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2_ Y)))).
Variable axiom_28_29 : (forall X : Universe, (cC6_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_29_30 : (forall X : Universe, (cC60_ X <-> (cC58_ X /\ ~(cC2_ X)))).
Variable axiom_30_31 : (forall X : Universe, (cC62_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC60_ Y)))).
Variable axiom_31_32 : (forall X : Universe, (cC64_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC2_ Y)))).
Variable axiom_32_33 : (forall X : Universe, (cC66_ X <-> (~(cC2_ X) /\ cC64_ X))).
Variable axiom_33_34 : (forall X : Universe, (cC68_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC66_ Y)))).
Variable axiom_34_35 : (forall X : Universe, (cC70_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC68_ Y)))).
Variable axiom_35_36 : (forall X : Universe, (cC72_ X <-> (~(cC62_ X) /\ cC70_ X))).
Variable axiom_36_37 : (forall X : Universe, (cC74_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC72_ Y)))).
Variable axiom_37_38 : (forall X : Universe, (cC76_ X <-> (~(cC74_ X) /\ cC56_ X))).
Variable axiom_38_39 : (forall X : Universe, (cC78_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_39_40 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC6_ Y))))).
Variable axiom_40_41 : (forall X : Universe, (cC80_ X <-> (~(cC2_ X) /\ ~(cC78_ X)))).
Variable axiom_41_42 : (forall X : Universe, (cC82_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC80_ Y)))).
Variable axiom_42_43 : (forall X : Universe, (cC84_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_43_44 : (forall X : Universe, (cC86_ X <-> (~(cC84_ X) /\ ~(cC2_ X)))).
Variable axiom_44_45 : (forall X : Universe, (cC88_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC86_ Y)))).
Variable axiom_45_46 : (forall X : Universe, (cC90_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC88_ Y)))).
Variable axiom_46_47 : (forall X : Universe, (cC92_ X <-> (~(cC82_ X) /\ cC90_ X))).
Variable axiom_47_48 : (forall X : Universe, (cC94_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC92_ Y)))).
Variable axiom_48_49 : (forall X : Universe, (cTEST_ X <-> (~(cC94_ X) /\ cC76_ X))).
Variable axiom_49_50 : ~(cC92_ iV8467_).
Variable axiom_50_51 : ~(cC72_ iV8467_).
Variable axiom_51_52 : ~(cC42_ iV8467_).
Variable axiom_52_53 : cowlThing_ iV8467_.
Variable axiom_53_54 : ~(cC52_ iV8467_).
Variable axiom_54_55 : ~(cC26_ iV8467_).
Variable axiom_55_56 : rR1_ iV8467_ iV8471_.
Variable axiom_56_57 : rR1_ iV8467_ iV8473_.
Variable axiom_57_58 : rR1_ iV8467_ iV8468_.
Variable axiom_58_59 : rR1_ iV8467_ iV8469_.
Variable axiom_59_60 : rR1_ iV8467_ iV8475_.
Variable axiom_60_61 : rR1_ iV8467_ iV8472_.
Variable axiom_61_62 : rR1_ iV8467_ iV8474_.
Variable axiom_62_63 : rR1_ iV8467_ iV8470_.
Variable axiom_63_64 : ~(cC2_ iV8468_).
Variable axiom_64_65 : cowlThing_ iV8468_.
Variable axiom_65_66 : ~(cC6_ iV8469_).
Variable axiom_66_67 : (forall X : Universe, (rR1_ iV8469_ X -> cC2_ X)).
Variable axiom_67_68 : cowlThing_ iV8469_.
Variable axiom_68_69 : cTOP_ iV8470_.
Variable axiom_69_70 : cowlThing_ iV8470_.
Variable axiom_70_71 : ~(cC2_ iV8471_).
Variable axiom_71_72 : ~(cC78_ iV8471_).
Variable axiom_72_73 : cowlThing_ iV8471_.
Variable axiom_73_74 : (forall X : Universe, (rR1_ iV8471_ X -> cC2_ X)).
Variable axiom_74_75 : ~(cC2_ iV8472_).
Variable axiom_75_76 : cowlThing_ iV8472_.
Variable axiom_76_77 : rR1_ iV8472_ iV8476_.
Variable axiom_77_78 : ~(cC2_ iV8473_).
Variable axiom_78_79 : cowlThing_ iV8473_.
Variable axiom_79_80 : (forall X : Universe, (rR1_ iV8474_ X -> ~(cC2_ X))).
Variable axiom_80_81 : ~(cC32_ iV8474_).
Variable axiom_81_82 : cowlThing_ iV8474_.
Variable axiom_82_83 : ~(cC2_ iV8475_).
Variable axiom_83_84 : cowlThing_ iV8475_.
Variable axiom_84_85 : cC2_ iV8476_.
Variable axiom_85_86 : cowlThing_ iV8476_.

Theorem the_axiom_87 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cC10_ iV8467_ /\ (cC48_ iV8467_ /\ (cC4_ iV8467_ /\ (cC82_ iV8467_ /\ (cC14_ iV8467_ /\ (cC8_ iV8467_ /\ (cC20_ iV8467_ /\ (cowlThing_ iV8467_ /\ (cC62_ iV8467_ /\ (cC34_ iV8467_ /\ (cowlThing_ iV8471_ /\ (cC80_ iV8471_ /\ (cC60_ iV8472_ /\ (cowlThing_ iV8472_ /\ cC58_ iV8472_)))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
