(*
% File     : KRS142+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : An owl:cardinality constraint is simply shorthand
% Version  : Especial.
% English  : An owl:cardinality constraint is simply shorthand for a pair of 
%            owl:minCardinality and owl:maxCardinality constraints.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_cardinality-Manifest001 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   11 (   0 unit)
%            Number of atoms       :   40 (   9 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   33 (   4 ~  ;   0  |;  15  &)
%                                         (   2 <=>;  12 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   29 (   0 singleton;  27 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rp_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.


Variable cc_substitution_1_1 : (forall A B : Universe, ((A = B /\ cc_ A) -> cc_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rp_substitution_1_4 : (forall A B C : Universe, ((A = B /\ rp_ A C) -> rp_ B C)).
Variable rp_substitution_2_5 : (forall A B C : Universe, ((A = B /\ rp_ C A) -> rp_ C B)).
Variable xsd_integer_substitution_1_6 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_7 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_8 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_9 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_10 : (forall X : Universe, (cc_ X -> ((exists Y0 : Universe, rp_ X Y0) /\ (forall Y0 Y1 : Universe, ((rp_ X Y0 /\ rp_ X Y1) -> Y0 = Y1))))).

Theorem the_axiom_11 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ ((forall X : Universe, (cc_ X -> (exists Y0 : Universe, rp_ X Y0))) /\ (forall X : Universe, (cc_ X -> (forall Y0 Y1 : Universe, ((rp_ X Y0 /\ rp_ X Y1) -> Y0 = Y1))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
