(*
% File     : KRS140+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Test illustrating extensional semantics of owl:TransitiveProperty
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_TransitiveProperty-Manifest002 [Bec03]
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   15 (   4 unit)
%            Number of atoms       :   40 (   8 equality)
%            Maximal formula depth :    9 (   4 average)
%            Number of connectives :   29 (   4 ~  ;   1  |;  13  &)
%                                         (   2 <=>;   9 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   26 (   0 singleton;  25 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rsymProp_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.

Variable ib_ : Universe.
Variable ia_ : Universe.

Variable cowlNothing_substitution_1_1 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rsymProp_substitution_1_3 : (forall A B C : Universe, ((A = B /\ rsymProp_ A C) -> rsymProp_ B C)).
Variable rsymProp_substitution_2_4 : (forall A B C : Universe, ((A = B /\ rsymProp_ C A) -> rsymProp_ C B)).
Variable xsd_integer_substitution_1_5 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_6 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_7 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_8 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_9 : (forall X Y : Universe, (rsymProp_ X Y -> (Y = ia_ \/ Y = ib_))).
Variable axiom_3_10 : (forall X Y : Universe, (rsymProp_ X Y -> rsymProp_ Y X)).
Variable axiom_4_11 : cowlThing_ ia_.
Variable axiom_5_12 : rsymProp_ ia_ ia_.
Variable axiom_6_13 : cowlThing_ ib_.
Variable axiom_7_14 : rsymProp_ ib_ ib_.

Theorem the_axiom_15 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ ((forall X Y Z : Universe, ((rsymProp_ X Y /\ rsymProp_ Y Z) -> rsymProp_ X Z)) /\ (exists X : Universe, (rsymProp_ ia_ X /\ cowlThing_ X))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
