(*
% File     : KRS139+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : A Lite version of test SymmetricProperty-001
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_SymmetricProperty-Manifest003 [Bec03]
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0
% Syntax   : Number of formulae    :    7 (   3 unit)
%            Number of atoms       :   16 (   0 equality)
%            Maximal formula depth :    6 (   3 average)
%            Number of connectives :   13 (   4 ~  ;   0  |;   6  &)
%                                         (   2 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :    6 (   0 singleton;   6 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rpath_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.

Variable iGhent_ : Universe.
Variable iAntwerp_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X Y : Universe, (rpath_ X Y -> rpath_ Y X)).
Variable axiom_3_4 : cowlThing_ iAntwerp_.
Variable axiom_4_5 : cowlThing_ iGhent_.
Variable axiom_5_6 : rpath_ iGhent_ iAntwerp_.

Theorem the_axiom_7 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cowlThing_ iAntwerp_ /\ (rpath_ iAntwerp_ iGhent_ /\ cowlThing_ iGhent_)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
