(*
% File     : KRS138+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Extensional semantics of owl:SymmetricProperty
% Version  : Especial.
% English  : Test illustrating extensional semantics of owl:SymmetricProperty.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_SymmetricProperty-Manifest002 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   18 (   5 unit)
%            Number of atoms       :   52 (  13 equality)
%            Maximal formula depth :    9 (   4 average)
%            Number of connectives :   38 (   4 ~  ;   3  |;  17  &)
%                                         (   3 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   3 constant; 0-0 arity)
%            Number of variables   :   30 (   0 singleton;  30 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable requalityOnA_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cA_ : Universe -> Prop.

Variable ic_ : Universe.
Variable ib_ : Universe.
Variable ia_ : Universe.

Variable cA_substitution_1_1 : (forall A B : Universe, ((A = B /\ cA_ A) -> cA_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable requalityOnA_substitution_1_4 : (forall A B C : Universe, ((A = B /\ requalityOnA_ A C) -> requalityOnA_ B C)).
Variable requalityOnA_substitution_2_5 : (forall A B C : Universe, ((A = B /\ requalityOnA_ C A) -> requalityOnA_ C B)).
Variable xsd_integer_substitution_1_6 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_7 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_8 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_9 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_10 : (forall X : Universe, (cA_ X <-> (X = ib_ \/ X = ia_))).
Variable axiom_3_11 : (forall X Y Z : Universe, ((requalityOnA_ Y X /\ requalityOnA_ Z X) -> Y = Z)).
Variable axiom_4_12 : (forall X Y : Universe, (requalityOnA_ X Y -> cA_ Y)).
Variable axiom_5_13 : cowlThing_ ia_.
Variable axiom_6_14 : requalityOnA_ ia_ ia_.
Variable axiom_7_15 : cowlThing_ ib_.
Variable axiom_8_16 : requalityOnA_ ib_ ib_.
Variable axiom_9_17 : cowlThing_ ic_.

Theorem the_axiom_18 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ ((forall X Y : Universe, (requalityOnA_ X Y -> (X = ia_ \/ (X = ib_ \/ X = ic_)))) /\ ((forall X Y : Universe, (requalityOnA_ X Y -> requalityOnA_ Y X)) /\ (cowlThing_ ia_ /\ (requalityOnA_ ia_ ia_ /\ (cowlThing_ ib_ /\ cowlThing_ ic_))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
