(*
% File     : KRS133+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : How to express mutual disjointness between classes
% Version  : Especial.
% English  : The construct used here shows how to express mutual disjointness 
%            between classes with  O(N) triples.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_I5.21-Manifest002 [Bec03]
% Status   : Theorem
% Rating   : 0.78 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :  125 (  78 unit)
%            Number of atoms       :  328 (  86 equality)
%            Maximal formula depth :   71 (   3 average)
%            Number of connectives :  339 ( 136 ~  ;   0  |; 156  &)
%                                         (   2 <=>;  45 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   19 (   0 propositional; 1-2 arity)
%            Number of functors    :   12 (  12 constant; 0-0 arity)
%            Number of variables   :  138 (   0 singleton; 137 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rfamily_name_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cXantusiidae_ : Universe -> Prop.
Variable cSphenodontidae_ : Universe -> Prop.
Variable cReptile_ : Universe -> Prop.
Variable cLoxocemidae_ : Universe -> Prop.
Variable cLeptotyphlopidae_ : Universe -> Prop.
Variable cGekkonidae_ : Universe -> Prop.
Variable cEmydidae_ : Universe -> Prop.
Variable cCrocodylidae_ : Universe -> Prop.
Variable cCordylidae_ : Universe -> Prop.
Variable cBipedidae_ : Universe -> Prop.
Variable cAnomalepidae_ : Universe -> Prop.
Variable cAmphisbaenidae_ : Universe -> Prop.
Variable cAgamidae_ : Universe -> Prop.

Variable xsd_string_9_ : Universe.
Variable xsd_string_8_ : Universe.
Variable xsd_string_7_ : Universe.
Variable xsd_string_6_ : Universe.
Variable xsd_string_5_ : Universe.
Variable xsd_string_4_ : Universe.
Variable xsd_string_3_ : Universe.
Variable xsd_string_2_ : Universe.
Variable xsd_string_11_ : Universe.
Variable xsd_string_10_ : Universe.
Variable xsd_string_1_ : Universe.
Variable xsd_string_0_ : Universe.

Variable cAgamidae_substitution_1_1 : (forall A B : Universe, ((A = B /\ cAgamidae_ A) -> cAgamidae_ B)).
Variable cAmphisbaenidae_substitution_1_2 : (forall A B : Universe, ((A = B /\ cAmphisbaenidae_ A) -> cAmphisbaenidae_ B)).
Variable cAnomalepidae_substitution_1_3 : (forall A B : Universe, ((A = B /\ cAnomalepidae_ A) -> cAnomalepidae_ B)).
Variable cBipedidae_substitution_1_4 : (forall A B : Universe, ((A = B /\ cBipedidae_ A) -> cBipedidae_ B)).
Variable cCordylidae_substitution_1_5 : (forall A B : Universe, ((A = B /\ cCordylidae_ A) -> cCordylidae_ B)).
Variable cCrocodylidae_substitution_1_6 : (forall A B : Universe, ((A = B /\ cCrocodylidae_ A) -> cCrocodylidae_ B)).
Variable cEmydidae_substitution_1_7 : (forall A B : Universe, ((A = B /\ cEmydidae_ A) -> cEmydidae_ B)).
Variable cGekkonidae_substitution_1_8 : (forall A B : Universe, ((A = B /\ cGekkonidae_ A) -> cGekkonidae_ B)).
Variable cLeptotyphlopidae_substitution_1_9 : (forall A B : Universe, ((A = B /\ cLeptotyphlopidae_ A) -> cLeptotyphlopidae_ B)).
Variable cLoxocemidae_substitution_1_10 : (forall A B : Universe, ((A = B /\ cLoxocemidae_ A) -> cLoxocemidae_ B)).
Variable cReptile_substitution_1_11 : (forall A B : Universe, ((A = B /\ cReptile_ A) -> cReptile_ B)).
Variable cSphenodontidae_substitution_1_12 : (forall A B : Universe, ((A = B /\ cSphenodontidae_ A) -> cSphenodontidae_ B)).
Variable cXantusiidae_substitution_1_13 : (forall A B : Universe, ((A = B /\ cXantusiidae_ A) -> cXantusiidae_ B)).
Variable cowlNothing_substitution_1_14 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_15 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rfamily_name_substitution_1_16 : (forall A B C : Universe, ((A = B /\ rfamily_name_ A C) -> rfamily_name_ B C)).
Variable rfamily_name_substitution_2_17 : (forall A B C : Universe, ((A = B /\ rfamily_name_ C A) -> rfamily_name_ C B)).
Variable xsd_integer_substitution_1_18 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_19 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_20 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_21 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_22 : xsd_string_ xsd_string_0_.
Variable axiom_3_23 : (forall X : Universe, (cAgamidae_ X -> rfamily_name_ X xsd_string_0_)).
Variable axiom_4_24 : (forall X : Universe, (cAgamidae_ X -> cReptile_ X)).
Variable axiom_5_25 : xsd_string_ xsd_string_1_.
Variable axiom_6_26 : (forall X : Universe, (cAmphisbaenidae_ X -> rfamily_name_ X xsd_string_1_)).
Variable axiom_7_27 : (forall X : Universe, (cAmphisbaenidae_ X -> cReptile_ X)).
Variable axiom_8_28 : xsd_string_ xsd_string_2_.
Variable axiom_9_29 : (forall X : Universe, (cAnomalepidae_ X -> rfamily_name_ X xsd_string_2_)).
Variable axiom_10_30 : (forall X : Universe, (cAnomalepidae_ X -> cReptile_ X)).
Variable axiom_11_31 : xsd_string_ xsd_string_3_.
Variable axiom_12_32 : (forall X : Universe, (cBipedidae_ X -> rfamily_name_ X xsd_string_3_)).
Variable axiom_13_33 : (forall X : Universe, (cBipedidae_ X -> cReptile_ X)).
Variable axiom_14_34 : xsd_string_ xsd_string_4_.
Variable axiom_15_35 : (forall X : Universe, (cCordylidae_ X -> rfamily_name_ X xsd_string_4_)).
Variable axiom_16_36 : (forall X : Universe, (cCordylidae_ X -> cReptile_ X)).
Variable axiom_17_37 : xsd_string_ xsd_string_5_.
Variable axiom_18_38 : (forall X : Universe, (cCrocodylidae_ X -> rfamily_name_ X xsd_string_5_)).
Variable axiom_19_39 : (forall X : Universe, (cCrocodylidae_ X -> cReptile_ X)).
Variable axiom_20_40 : xsd_string_ xsd_string_6_.
Variable axiom_21_41 : (forall X : Universe, (cEmydidae_ X -> rfamily_name_ X xsd_string_6_)).
Variable axiom_22_42 : (forall X : Universe, (cEmydidae_ X -> cReptile_ X)).
Variable axiom_23_43 : xsd_string_ xsd_string_7_.
Variable axiom_24_44 : (forall X : Universe, (cGekkonidae_ X -> rfamily_name_ X xsd_string_7_)).
Variable axiom_25_45 : (forall X : Universe, (cGekkonidae_ X -> cReptile_ X)).
Variable axiom_26_46 : xsd_string_ xsd_string_8_.
Variable axiom_27_47 : (forall X : Universe, (cLeptotyphlopidae_ X -> rfamily_name_ X xsd_string_8_)).
Variable axiom_28_48 : (forall X : Universe, (cLeptotyphlopidae_ X -> cReptile_ X)).
Variable axiom_29_49 : xsd_string_ xsd_string_9_.
Variable axiom_30_50 : (forall X : Universe, (cLoxocemidae_ X -> rfamily_name_ X xsd_string_9_)).
Variable axiom_31_51 : (forall X : Universe, (cLoxocemidae_ X -> cReptile_ X)).
Variable axiom_32_52 : (forall X : Universe, (cReptile_ X -> ((exists Y0 : Universe, rfamily_name_ X Y0) /\ (forall Y0 Y1 : Universe, ((rfamily_name_ X Y0 /\ rfamily_name_ X Y1) -> Y0 = Y1))))).
Variable axiom_33_53 : xsd_string_ xsd_string_10_.
Variable axiom_34_54 : (forall X : Universe, (cSphenodontidae_ X -> rfamily_name_ X xsd_string_10_)).
Variable axiom_35_55 : (forall X : Universe, (cSphenodontidae_ X -> cReptile_ X)).
Variable axiom_36_56 : xsd_string_ xsd_string_11_.
Variable axiom_37_57 : (forall X : Universe, (cXantusiidae_ X -> rfamily_name_ X xsd_string_11_)).
Variable axiom_38_58 : (forall X : Universe, (cXantusiidae_ X -> cReptile_ X)).
Variable axiom_39_59 : xsd_string_0_ <> xsd_string_1_.
Variable axiom_40_60 : xsd_string_0_ <> xsd_string_2_.
Variable axiom_41_61 : xsd_string_0_ <> xsd_string_3_.
Variable axiom_42_62 : xsd_string_0_ <> xsd_string_4_.
Variable axiom_43_63 : xsd_string_0_ <> xsd_string_5_.
Variable axiom_44_64 : xsd_string_0_ <> xsd_string_6_.
Variable axiom_45_65 : xsd_string_0_ <> xsd_string_7_.
Variable axiom_46_66 : xsd_string_0_ <> xsd_string_8_.
Variable axiom_47_67 : xsd_string_0_ <> xsd_string_9_.
Variable axiom_48_68 : xsd_string_0_ <> xsd_string_10_.
Variable axiom_49_69 : xsd_string_0_ <> xsd_string_11_.
Variable axiom_50_70 : xsd_string_1_ <> xsd_string_2_.
Variable axiom_51_71 : xsd_string_1_ <> xsd_string_3_.
Variable axiom_52_72 : xsd_string_1_ <> xsd_string_4_.
Variable axiom_53_73 : xsd_string_1_ <> xsd_string_5_.
Variable axiom_54_74 : xsd_string_1_ <> xsd_string_6_.
Variable axiom_55_75 : xsd_string_1_ <> xsd_string_7_.
Variable axiom_56_76 : xsd_string_1_ <> xsd_string_8_.
Variable axiom_57_77 : xsd_string_1_ <> xsd_string_9_.
Variable axiom_58_78 : xsd_string_1_ <> xsd_string_10_.
Variable axiom_59_79 : xsd_string_1_ <> xsd_string_11_.
Variable axiom_60_80 : xsd_string_2_ <> xsd_string_3_.
Variable axiom_61_81 : xsd_string_2_ <> xsd_string_4_.
Variable axiom_62_82 : xsd_string_2_ <> xsd_string_5_.
Variable axiom_63_83 : xsd_string_2_ <> xsd_string_6_.
Variable axiom_64_84 : xsd_string_2_ <> xsd_string_7_.
Variable axiom_65_85 : xsd_string_2_ <> xsd_string_8_.
Variable axiom_66_86 : xsd_string_2_ <> xsd_string_9_.
Variable axiom_67_87 : xsd_string_2_ <> xsd_string_10_.
Variable axiom_68_88 : xsd_string_2_ <> xsd_string_11_.
Variable axiom_69_89 : xsd_string_3_ <> xsd_string_4_.
Variable axiom_70_90 : xsd_string_3_ <> xsd_string_5_.
Variable axiom_71_91 : xsd_string_3_ <> xsd_string_6_.
Variable axiom_72_92 : xsd_string_3_ <> xsd_string_7_.
Variable axiom_73_93 : xsd_string_3_ <> xsd_string_8_.
Variable axiom_74_94 : xsd_string_3_ <> xsd_string_9_.
Variable axiom_75_95 : xsd_string_3_ <> xsd_string_10_.
Variable axiom_76_96 : xsd_string_3_ <> xsd_string_11_.
Variable axiom_77_97 : xsd_string_4_ <> xsd_string_5_.
Variable axiom_78_98 : xsd_string_4_ <> xsd_string_6_.
Variable axiom_79_99 : xsd_string_4_ <> xsd_string_7_.
Variable axiom_80_100 : xsd_string_4_ <> xsd_string_8_.
Variable axiom_81_101 : xsd_string_4_ <> xsd_string_9_.
Variable axiom_82_102 : xsd_string_4_ <> xsd_string_10_.
Variable axiom_83_103 : xsd_string_4_ <> xsd_string_11_.
Variable axiom_84_104 : xsd_string_5_ <> xsd_string_6_.
Variable axiom_85_105 : xsd_string_5_ <> xsd_string_7_.
Variable axiom_86_106 : xsd_string_5_ <> xsd_string_8_.
Variable axiom_87_107 : xsd_string_5_ <> xsd_string_9_.
Variable axiom_88_108 : xsd_string_5_ <> xsd_string_10_.
Variable axiom_89_109 : xsd_string_5_ <> xsd_string_11_.
Variable axiom_90_110 : xsd_string_6_ <> xsd_string_7_.
Variable axiom_91_111 : xsd_string_6_ <> xsd_string_8_.
Variable axiom_92_112 : xsd_string_6_ <> xsd_string_9_.
Variable axiom_93_113 : xsd_string_6_ <> xsd_string_10_.
Variable axiom_94_114 : xsd_string_6_ <> xsd_string_11_.
Variable axiom_95_115 : xsd_string_7_ <> xsd_string_8_.
Variable axiom_96_116 : xsd_string_7_ <> xsd_string_9_.
Variable axiom_97_117 : xsd_string_7_ <> xsd_string_10_.
Variable axiom_98_118 : xsd_string_7_ <> xsd_string_11_.
Variable axiom_99_119 : xsd_string_8_ <> xsd_string_9_.
Variable axiom_100_120 : xsd_string_8_ <> xsd_string_10_.
Variable axiom_101_121 : xsd_string_8_ <> xsd_string_11_.
Variable axiom_102_122 : xsd_string_9_ <> xsd_string_10_.
Variable axiom_103_123 : xsd_string_9_ <> xsd_string_11_.
Variable axiom_104_124 : xsd_string_10_ <> xsd_string_11_.

Theorem the_axiom_125 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cBipedidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cAnomalepidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cGekkonidae_ X))) /\ ((forall X : Universe, ~((cAmphisbaenidae_ X /\ cSphenodontidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cGekkonidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cSphenodontidae_ X))) /\ ((forall X : Universe, ~((cGekkonidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cGekkonidae_ X /\ cSphenodontidae_ X))) /\ ((forall X : Universe, ~((cAgamidae_ X /\ cSphenodontidae_ X))) /\ ((forall X : Universe, ~((cAnomalepidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cCrocodylidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cAmphisbaenidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cAgamidae_ X))) /\ ((forall X : Universe, ~((cAmphisbaenidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cCrocodylidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cAmphisbaenidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cAgamidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cAgamidae_ X))) /\ ((forall X : Universe, ~((cGekkonidae_ X /\ cAmphisbaenidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cSphenodontidae_ X /\ cCordylidae_ X))) /\ ((forall X : Universe, ~((cAmphisbaenidae_ X /\ cCordylidae_ X))) /\ ((forall X : Universe, ~((cCordylidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cGekkonidae_ X /\ cCordylidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cAgamidae_ X))) /\ ((forall X : Universe, ~((cAnomalepidae_ X /\ cCordylidae_ X))) /\ ((forall X : Universe, ~((cAgamidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cCordylidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cAgamidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cGekkonidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cBipedidae_ X))) /\ ((forall X : Universe, ~((cAnomalepidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cSphenodontidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cAmphisbaenidae_ X))) /\ ((forall X : Universe, ~((cSphenodontidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cCordylidae_ X))) /\ ((forall X : Universe, ~((cGekkonidae_ X /\ cAnomalepidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cCordylidae_ X))) /\ ((forall X : Universe, ~((cBipedidae_ X /\ cAmphisbaenidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cCordylidae_ X))) /\ ((forall X : Universe, ~((cAnomalepidae_ X /\ cAgamidae_ X))) /\ ((forall X : Universe, ~((cSphenodontidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cAmphisbaenidae_ X))) /\ ((forall X : Universe, ~((cGekkonidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cSphenodontidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cEmydidae_ X))) /\ ((forall X : Universe, ~((cAmphisbaenidae_ X /\ cAnomalepidae_ X))) /\ ((forall X : Universe, ~((cGekkonidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cAnomalepidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cAnomalepidae_ X))) /\ ((forall X : Universe, ~((cCordylidae_ X /\ cCrocodylidae_ X))) /\ ((forall X : Universe, ~((cXantusiidae_ X /\ cAnomalepidae_ X))) /\ ((forall X : Universe, ~((cAnomalepidae_ X /\ cSphenodontidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cXantusiidae_ X))) /\ ((forall X : Universe, ~((cGekkonidae_ X /\ cAgamidae_ X))) /\ ((forall X : Universe, ~((cAgamidae_ X /\ cCordylidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cEmydidae_ X /\ cLoxocemidae_ X))) /\ ((forall X : Universe, ~((cLeptotyphlopidae_ X /\ cSphenodontidae_ X))) /\ (forall X : Universe, ~((cAmphisbaenidae_ X /\ cAgamidae_ X)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
