(*
% File     : KRS117+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t6.1 Double blocking example
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest626 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   32 (   1 unit)
%            Number of atoms       :   92 (  20 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   63 (   3 ~  ;   0  |;  28  &)
%                                         (   8 <=>;  24 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   15 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   73 (   0 singleton;  68 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : The concept should be incoherent but needs double blocking
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable rinvF_ : Universe -> Universe -> Prop.
Variable rf_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cd_ : Universe -> Prop.
Variable ccxcomp_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable ca_Vx3_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_21_37349_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable ca_Vx3_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_Vx3_ A) -> ca_Vx3_ B)).
Variable cc_substitution_1_3 : (forall A B : Universe, ((A = B /\ cc_ A) -> cc_ B)).
Variable ccxcomp_substitution_1_4 : (forall A B : Universe, ((A = B /\ ccxcomp_ A) -> ccxcomp_ B)).
Variable cd_substitution_1_5 : (forall A B : Universe, ((A = B /\ cd_ A) -> cd_ B)).
Variable cowlNothing_substitution_1_6 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_7 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable ra_Px1_substitution_1_8 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_9 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable rf_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rinvF_substitution_1_12 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_13 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvR_substitution_1_14 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_15 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_16 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_17 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_18 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_19 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_20 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_21 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_22 : (forall X : Universe, (cUnsatisfiable_ X <-> (ccxcomp_ X /\ ((forall Y : Universe, (rinvR_ X Y -> ca_Vx3_ Y)) /\ (exists Y : Universe, (rinvF_ X Y /\ cd_ Y)))))).
Variable axiom_3_23 : (forall X : Universe, (cc_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_4_24 : (forall X : Universe, (ccxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_25 : (forall X : Universe, (cd_ X <-> ((exists Y : Universe, (rf_ X Y /\ ccxcomp_ Y)) /\ cc_ X))).
Variable axiom_6_26 : (forall X : Universe, (ca_Vx3_ X <-> (exists Y : Universe, (rinvF_ X Y /\ cd_ Y)))).
Variable axiom_7_27 : (forall X : Universe, (cowlThing_ X -> (forall Y0 Y1 : Universe, ((rf_ X Y0 /\ rf_ X Y1) -> Y0 = Y1)))).
Variable axiom_8_28 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_9_29 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_10_30 : (forall X Y Z : Universe, ((rr_ X Y /\ rr_ Y Z) -> rr_ X Z)).
Variable axiom_11_31 : cUnsatisfiable_ i2003_11_14_17_21_37349_.
Variable axiom_12_32 : (forall X Y : Universe, (rf_ X Y -> rr_ X Y)).

Theorem conjecture_33 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
