(*
% File     : KRS113+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t11.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest614 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   25 (   1 unit)
%            Number of atoms       :   73 (  17 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   51 (   3 ~  ;   0  |;  23  &)
%                                         (   6 <=>;  19 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   57 (   0 singleton;  53 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rs_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvS_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cpxcomp_ : Universe -> Prop.
Variable cp_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable ca_Vx2_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_21_22376_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable ca_Vx2_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_Vx2_ A) -> ca_Vx2_ B)).
Variable cowlNothing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp_substitution_1_5 : (forall A B : Universe, ((A = B /\ cp_ A) -> cp_ B)).
Variable cpxcomp_substitution_1_6 : (forall A B : Universe, ((A = B /\ cpxcomp_ A) -> cpxcomp_ B)).
Variable ra_Px1_substitution_1_7 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_8 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable rinvS_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rinvS_ A C) -> rinvS_ B C)).
Variable rinvS_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rinvS_ C A) -> rinvS_ C B)).
Variable rr_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable rs_substitution_1_13 : (forall A B C : Universe, ((A = B /\ rs_ A C) -> rs_ B C)).
Variable rs_substitution_2_14 : (forall A B C : Universe, ((A = B /\ rs_ C A) -> rs_ C B)).
Variable xsd_integer_substitution_1_15 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_16 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_17 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_18 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_19 : (forall X : Universe, (cUnsatisfiable_ X <-> ((forall Y0 Y1 : Universe, ((rr_ X Y0 /\ rr_ X Y1) -> Y0 = Y1)) /\ ((exists Y : Universe, (rr_ X Y /\ ca_Vx2_ Y)) /\ ((exists Y : Universe, (rs_ X Y /\ cp_ Y)) /\ cpxcomp_ X))))).
Variable axiom_3_20 : (forall X : Universe, (cp_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_4_21 : (forall X : Universe, (cpxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_22 : (forall X : Universe, (ca_Vx2_ X <-> (forall Y : Universe, (rinvS_ X Y -> cp_ Y)))).
Variable axiom_6_23 : (forall X Y : Universe, (rinvS_ X Y <-> rs_ Y X)).
Variable axiom_7_24 : cUnsatisfiable_ i2003_11_14_17_21_22376_.
Variable axiom_8_25 : (forall X Y : Universe, (rs_ X Y -> rr_ X Y)).

Theorem conjecture_26 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
