(*
% File     : KRS112+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t10.5
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest613 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   39 (   1 unit)
%            Number of atoms       :  109 (  26 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :   73 (   3 ~  ;   0  |;  32  &)
%                                         (   9 <=>;  29 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   17 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   92 (   0 singleton;  87 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rs_ : Universe -> Universe -> Prop.
Variable rinvS_ : Universe -> Universe -> Prop.
Variable rinvF1_ : Universe -> Universe -> Prop.
Variable rinvF_ : Universe -> Universe -> Prop.
Variable rf1_ : Universe -> Universe -> Prop.
Variable rf_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cpxcomp_ : Universe -> Prop.
Variable cp_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable ca_Vx3_ : Universe -> Prop.
Variable ca_Ax2_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_21_19256_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable ca_Ax2_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_Ax2_ A) -> ca_Ax2_ B)).
Variable ca_Vx3_substitution_1_3 : (forall A B : Universe, ((A = B /\ ca_Vx3_ A) -> ca_Vx3_ B)).
Variable cowlNothing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp_substitution_1_6 : (forall A B : Universe, ((A = B /\ cp_ A) -> cp_ B)).
Variable cpxcomp_substitution_1_7 : (forall A B : Universe, ((A = B /\ cpxcomp_ A) -> cpxcomp_ B)).
Variable ra_Px1_substitution_1_8 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_9 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable rf_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rf1_substitution_1_12 : (forall A B C : Universe, ((A = B /\ rf1_ A C) -> rf1_ B C)).
Variable rf1_substitution_2_13 : (forall A B C : Universe, ((A = B /\ rf1_ C A) -> rf1_ C B)).
Variable rinvF_substitution_1_14 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_15 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvF1_substitution_1_16 : (forall A B C : Universe, ((A = B /\ rinvF1_ A C) -> rinvF1_ B C)).
Variable rinvF1_substitution_2_17 : (forall A B C : Universe, ((A = B /\ rinvF1_ C A) -> rinvF1_ C B)).
Variable rinvS_substitution_1_18 : (forall A B C : Universe, ((A = B /\ rinvS_ A C) -> rinvS_ B C)).
Variable rinvS_substitution_2_19 : (forall A B C : Universe, ((A = B /\ rinvS_ C A) -> rinvS_ C B)).
Variable rs_substitution_1_20 : (forall A B C : Universe, ((A = B /\ rs_ A C) -> rs_ B C)).
Variable rs_substitution_2_21 : (forall A B C : Universe, ((A = B /\ rs_ C A) -> rs_ C B)).
Variable xsd_integer_substitution_1_22 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_23 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_24 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_25 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_26 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rf1_ X Y /\ ca_Ax2_ Y)) /\ (exists Y : Universe, (rf_ X Y /\ cp_ Y))))).
Variable axiom_3_27 : (forall X : Universe, (cp_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_4_28 : (forall X : Universe, (cpxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_29 : (forall X : Universe, (ca_Ax2_ X <-> (cpxcomp_ X /\ (forall Y : Universe, (rinvF1_ X Y -> ca_Vx3_ Y))))).
Variable axiom_6_30 : (forall X : Universe, (ca_Vx3_ X <-> (exists Y : Universe, (rs_ X Y /\ cowlThing_ Y)))).
Variable axiom_7_31 : (forall X Y Z : Universe, ((rf_ X Y /\ rf_ X Z) -> Y = Z)).
Variable axiom_8_32 : (forall X Y Z : Universe, ((rf1_ X Y /\ rf1_ X Z) -> Y = Z)).
Variable axiom_9_33 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_10_34 : (forall X Y : Universe, (rinvF1_ X Y <-> rf1_ Y X)).
Variable axiom_11_35 : (forall X Y : Universe, (rinvS_ X Y <-> rs_ Y X)).
Variable axiom_12_36 : (forall X Y Z : Universe, ((rs_ X Y /\ rs_ X Z) -> Y = Z)).
Variable axiom_13_37 : cUnsatisfiable_ i2003_11_14_17_21_19256_.
Variable axiom_14_38 : (forall X Y : Universe, (rs_ X Y -> rf_ X Y)).
Variable axiom_15_39 : (forall X Y : Universe, (rs_ X Y -> rf1_ X Y)).

Theorem conjecture_40 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
