(*
% File     : KRS108+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t1.3
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest608 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :   66 (   1 unit)
%            Number of atoms       :  182 (  40 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :  125 (   9 ~  ;   0  |;  51  &)
%                                         (  21 <=>;  44 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   31 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :  141 (   0 singleton; 125 !;  16 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable ra_Px7_ : Universe -> Universe -> Prop.
Variable ra_Px6_ : Universe -> Universe -> Prop.
Variable ra_Px5_ : Universe -> Universe -> Prop.
Variable ra_Px4_ : Universe -> Universe -> Prop.
Variable ra_Px3_ : Universe -> Universe -> Prop.
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cp5xcomp_ : Universe -> Prop.
Variable cp5_ : Universe -> Prop.
Variable cp4xcomp_ : Universe -> Prop.
Variable cp4_ : Universe -> Prop.
Variable cp3xcomp_ : Universe -> Prop.
Variable cp3_ : Universe -> Prop.
Variable cp2xcomp_ : Universe -> Prop.
Variable cp2_ : Universe -> Prop.
Variable cp1_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable ca_Cx3xcomp_ : Universe -> Prop.
Variable ca_Cx3_ : Universe -> Prop.
Variable ca_Cx2xcomp_ : Universe -> Prop.
Variable ca_Cx2_ : Universe -> Prop.
Variable ca_Cx1xcomp_ : Universe -> Prop.
Variable ca_Cx1_ : Universe -> Prop.
Variable ca_Ax14_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_21_04740_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable ca_Ax14_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_Ax14_ A) -> ca_Ax14_ B)).
Variable ca_Cx1_substitution_1_3 : (forall A B : Universe, ((A = B /\ ca_Cx1_ A) -> ca_Cx1_ B)).
Variable ca_Cx1xcomp_substitution_1_4 : (forall A B : Universe, ((A = B /\ ca_Cx1xcomp_ A) -> ca_Cx1xcomp_ B)).
Variable ca_Cx2_substitution_1_5 : (forall A B : Universe, ((A = B /\ ca_Cx2_ A) -> ca_Cx2_ B)).
Variable ca_Cx2xcomp_substitution_1_6 : (forall A B : Universe, ((A = B /\ ca_Cx2xcomp_ A) -> ca_Cx2xcomp_ B)).
Variable ca_Cx3_substitution_1_7 : (forall A B : Universe, ((A = B /\ ca_Cx3_ A) -> ca_Cx3_ B)).
Variable ca_Cx3xcomp_substitution_1_8 : (forall A B : Universe, ((A = B /\ ca_Cx3xcomp_ A) -> ca_Cx3xcomp_ B)).
Variable cowlNothing_substitution_1_9 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_10 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp1_substitution_1_11 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable cp2_substitution_1_12 : (forall A B : Universe, ((A = B /\ cp2_ A) -> cp2_ B)).
Variable cp2xcomp_substitution_1_13 : (forall A B : Universe, ((A = B /\ cp2xcomp_ A) -> cp2xcomp_ B)).
Variable cp3_substitution_1_14 : (forall A B : Universe, ((A = B /\ cp3_ A) -> cp3_ B)).
Variable cp3xcomp_substitution_1_15 : (forall A B : Universe, ((A = B /\ cp3xcomp_ A) -> cp3xcomp_ B)).
Variable cp4_substitution_1_16 : (forall A B : Universe, ((A = B /\ cp4_ A) -> cp4_ B)).
Variable cp4xcomp_substitution_1_17 : (forall A B : Universe, ((A = B /\ cp4xcomp_ A) -> cp4xcomp_ B)).
Variable cp5_substitution_1_18 : (forall A B : Universe, ((A = B /\ cp5_ A) -> cp5_ B)).
Variable cp5xcomp_substitution_1_19 : (forall A B : Universe, ((A = B /\ cp5xcomp_ A) -> cp5xcomp_ B)).
Variable ra_Px1_substitution_1_20 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_21 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable ra_Px2_substitution_1_22 : (forall A B C : Universe, ((A = B /\ ra_Px2_ A C) -> ra_Px2_ B C)).
Variable ra_Px2_substitution_2_23 : (forall A B C : Universe, ((A = B /\ ra_Px2_ C A) -> ra_Px2_ C B)).
Variable ra_Px3_substitution_1_24 : (forall A B C : Universe, ((A = B /\ ra_Px3_ A C) -> ra_Px3_ B C)).
Variable ra_Px3_substitution_2_25 : (forall A B C : Universe, ((A = B /\ ra_Px3_ C A) -> ra_Px3_ C B)).
Variable ra_Px4_substitution_1_26 : (forall A B C : Universe, ((A = B /\ ra_Px4_ A C) -> ra_Px4_ B C)).
Variable ra_Px4_substitution_2_27 : (forall A B C : Universe, ((A = B /\ ra_Px4_ C A) -> ra_Px4_ C B)).
Variable ra_Px5_substitution_1_28 : (forall A B C : Universe, ((A = B /\ ra_Px5_ A C) -> ra_Px5_ B C)).
Variable ra_Px5_substitution_2_29 : (forall A B C : Universe, ((A = B /\ ra_Px5_ C A) -> ra_Px5_ C B)).
Variable ra_Px6_substitution_1_30 : (forall A B C : Universe, ((A = B /\ ra_Px6_ A C) -> ra_Px6_ B C)).
Variable ra_Px6_substitution_2_31 : (forall A B C : Universe, ((A = B /\ ra_Px6_ C A) -> ra_Px6_ C B)).
Variable ra_Px7_substitution_1_32 : (forall A B C : Universe, ((A = B /\ ra_Px7_ A C) -> ra_Px7_ B C)).
Variable ra_Px7_substitution_2_33 : (forall A B C : Universe, ((A = B /\ ra_Px7_ C A) -> ra_Px7_ C B)).
Variable rinvR_substitution_1_34 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_35 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_36 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_37 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_38 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_39 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_40 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_41 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_42 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rinvR_ X Y /\ ca_Ax14_ Y)) /\ cp2_ X))).
Variable axiom_3_43 : (forall X : Universe, (cp1_ X -> ca_Cx1_ X)).
Variable axiom_4_44 : (forall X : Universe, (cp2_ X <-> (exists Y0 : Universe, ra_Px5_ X Y0))).
Variable axiom_5_45 : (forall X : Universe, (cp2_ X -> ca_Cx2_ X)).
Variable axiom_6_46 : (forall X : Universe, (cp2xcomp_ X <-> ~((exists Y : Universe, ra_Px5_ X Y)))).
Variable axiom_7_47 : (forall X : Universe, (cp3_ X <-> (exists Y0 : Universe, ra_Px6_ X Y0))).
Variable axiom_8_48 : (forall X : Universe, (cp3_ X -> ca_Cx3_ X)).
Variable axiom_9_49 : (forall X : Universe, (cp3xcomp_ X <-> ~((exists Y : Universe, ra_Px6_ X Y)))).
Variable axiom_10_50 : (forall X : Universe, (cp4_ X <-> ~((exists Y : Universe, ra_Px7_ X Y)))).
Variable axiom_11_51 : (forall X : Universe, (cp4_ X -> cp5xcomp_ X)).
Variable axiom_12_52 : (forall X : Universe, (cp4xcomp_ X <-> (exists Y0 : Universe, ra_Px7_ X Y0))).
Variable axiom_13_53 : (forall X : Universe, (cp5_ X <-> ~((exists Y : Universe, ra_Px4_ X Y)))).
Variable axiom_14_54 : (forall X : Universe, (cp5xcomp_ X <-> (exists Y0 : Universe, ra_Px4_ X Y0))).
Variable axiom_15_55 : (forall X : Universe, (ca_Ax14_ X <-> ((exists Y : Universe, (rr_ X Y /\ cp1_ Y)) /\ (forall Y0 Y1 : Universe, ((rr_ X Y0 /\ rr_ X Y1) -> Y0 = Y1))))).
Variable axiom_16_56 : (forall X : Universe, (ca_Cx1_ X <-> (cp2xcomp_ X /\ (cp5xcomp_ X /\ (cp3xcomp_ X /\ cp4xcomp_ X))))).
Variable axiom_17_57 : (forall X : Universe, (ca_Cx1_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_18_58 : (forall X : Universe, (ca_Cx1xcomp_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_19_59 : (forall X : Universe, (ca_Cx2_ X <-> (cp5xcomp_ X /\ (cp3xcomp_ X /\ cp4xcomp_ X)))).
Variable axiom_20_60 : (forall X : Universe, (ca_Cx2_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_21_61 : (forall X : Universe, (ca_Cx2xcomp_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_22_62 : (forall X : Universe, (ca_Cx3_ X <-> ~((exists Y : Universe, ra_Px3_ X Y)))).
Variable axiom_23_63 : (forall X : Universe, (ca_Cx3_ X <-> (cp5xcomp_ X /\ cp4xcomp_ X))).
Variable axiom_24_64 : (forall X : Universe, (ca_Cx3xcomp_ X <-> (exists Y0 : Universe, ra_Px3_ X Y0))).
Variable axiom_25_65 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_26_66 : cUnsatisfiable_ i2003_11_14_17_21_04740_.

Theorem conjecture_67 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
